/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.ls.core.internal.IContentProvider;
import org.eclipse.jdt.ls.core.internal.IDecompiler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class ContentProviderManager {
    private static final String EMPTY_CONTENT = "";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jdt.ls.core.contentProvider";
    private static final String CLASS = "class";
    private static final String ID = "id";
    private static final String PRIORITY = "priority";
    private static final String URI_PATTERN = "uriPattern";
    private static final int DEFAULT_PRIORITY = 500;
    private static final Pattern DEFAULT_URI_PATTERN = Pattern.compile(".*\\.class.*");
    private final PreferenceManager preferenceManager;
    private Set<ContentProviderDescriptor> descriptors;

    public ContentProviderManager(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public String getSource(IClassFile classFile, IProgressMonitor monitor) {
        if (classFile == null) {
            return null;
        }
        return this.getContent(classFile, classFile.getHandleIdentifier(), IDecompiler.class, monitor);
    }

    public String getContent(URI uri, IProgressMonitor monitor) {
        if (uri == null) {
            return null;
        }
        return this.getContent(uri, uri.toString(), IContentProvider.class, monitor);
    }

    /*
     * WARNING - void declaration
     */
    private String getContent(Object source, String cacheKey, Class<? extends IContentProvider> providerType, IProgressMonitor monitor) {
        URI uRI;
        Object object = source;
        if (object instanceof URI) {
            void u;
            URI uRI2 = (URI)object;
            URI cfr_ignored_0 = (URI)object;
            uRI = u;
        } else {
            uRI = null;
        }
        URI uri = uRI;
        List<ContentProviderDescriptor> matches = this.findMatchingProviders(uri);
        if (monitor.isCanceled()) {
            return EMPTY_CONTENT;
        }
        int previousPriority = -1;
        for (ContentProviderDescriptor match : matches) {
            String content;
            block14: {
                IContentProvider contentProvider = match.getContentProvider();
                if (!providerType.isInstance(contentProvider)) {
                    JavaLanguageServerPlugin.logError("Unable to load " + providerType.getSimpleName() + " class for " + match.id);
                    continue;
                }
                if (monitor.isCanceled()) {
                    return EMPTY_CONTENT;
                }
                if (previousPriority == match.priority) {
                    this.requestPreferredProvider(match.priority, matches);
                }
                contentProvider.setPreferences(this.preferenceManager.getPreferences());
                content = null;
                if (uri != null) {
                    content = contentProvider.getContent(uri, monitor);
                } else {
                    Object object2 = source;
                    if (object2 instanceof IClassFile) {
                        void classFile;
                        IClassFile cfr_ignored_1 = (IClassFile)object2;
                        IClassFile cfr_ignored_2 = (IClassFile)object2;
                        content = ((IDecompiler)contentProvider).getSource((IClassFile)classFile, monitor);
                    }
                }
                if (!monitor.isCanceled()) break block14;
                return EMPTY_CONTENT;
            }
            try {
                if (content != null) {
                    return content;
                }
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException("Error getting content via " + match.id, e);
            }
            previousPriority = match.priority;
        }
        return EMPTY_CONTENT;
    }

    private synchronized Set<ContentProviderDescriptor> getDescriptors(List<String> preferredProviderIds) {
        if (this.descriptors == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            this.descriptors = Stream.of(elements).map(e -> new ContentProviderDescriptor((IConfigurationElement)e)).collect(Collectors.toSet());
        }
        return this.descriptors;
    }

    private List<ContentProviderDescriptor> findMatchingProviders(URI uri) {
        List<String> preferredProviderIds = this.preferenceManager.getPreferences().getPreferredContentProviderIds();
        Set<ContentProviderDescriptor> descriptors = this.getDescriptors(preferredProviderIds);
        if (descriptors.isEmpty()) {
            JavaLanguageServerPlugin.logError("No content providers found");
            return null;
        }
        String uriString = uri != null ? uri.toString() : null;
        List<ContentProviderDescriptor> matches = descriptors.stream().filter(d -> uriString != null ? d.uriPattern.matcher(uriString).find() : true).peek(d -> d.calculateEffectivePriority(preferredProviderIds)).sorted((d1, d2) -> d1.priority - d2.priority).collect(Collectors.toList());
        if (matches.isEmpty()) {
            JavaLanguageServerPlugin.logError("Unable to find content provider for URI " + uri);
            return null;
        }
        return matches;
    }

    private void requestPreferredProvider(int duplicatePriority, List<ContentProviderDescriptor> matches) {
        Object[] unprioritizedIds = matches.stream().filter(d -> d.priority == duplicatePriority).map(d -> d.id).toArray();
        JavaLanguageServerPlugin.logError(String.format("You have more than one content provider installed: %s. Please use the \"java.contentProvider.preferred\" setting to choose which one you want to use.", Arrays.toString(unprioritizedIds)));
    }

    private static class ContentProviderDescriptor {
        private final IConfigurationElement configurationElement;
        public final String id;
        private final int basePriority;
        public int priority;
        public final Pattern uriPattern;

        public ContentProviderDescriptor(IConfigurationElement element) {
            this.configurationElement = element;
            this.id = this.configurationElement.getAttribute(ContentProviderManager.ID);
            this.priority = this.basePriority = this.parsePriority();
            String uriPatternString = this.configurationElement.getAttribute(ContentProviderManager.URI_PATTERN);
            this.uriPattern = uriPatternString != null ? Pattern.compile(uriPatternString) : DEFAULT_URI_PATTERN;
        }

        private int parsePriority() {
            try {
                return Integer.parseInt(this.configurationElement.getAttribute(ContentProviderManager.PRIORITY));
            }
            catch (NumberFormatException nfe) {
                return 500;
            }
        }

        public void calculateEffectivePriority(List<String> preferredProviderIds) {
            int index;
            this.priority = this.basePriority;
            if (preferredProviderIds != null && (index = preferredProviderIds.indexOf(this.id)) != -1) {
                this.priority = index + 1;
            }
        }

        /*
         * WARNING - void declaration
         */
        public synchronized IContentProvider getContentProvider() {
            try {
                Object extension;
                Object object = extension = this.configurationElement.createExecutableExtension(ContentProviderManager.CLASS);
                if (object instanceof IContentProvider) {
                    void contentProvider;
                    IContentProvider iContentProvider = (IContentProvider)object;
                    IContentProvider cfr_ignored_0 = (IContentProvider)object;
                    return contentProvider;
                }
                String message = "Invalid extension to org.eclipse.jdt.ls.core.contentProvider. Must implement " + IContentProvider.class.getName();
                JavaLanguageServerPlugin.logError(message);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Unable to create content provider ", e);
            }
            return null;
        }
    }
}

