/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import org.eclipse.jface.text.templates.Template;

public enum PostfixTemplate {
    CAST("org.eclipse.jdt.postfixcompletion.cast", "postfix", "(($${1})${inner_expression})$${0}", "Casts the expression to a new type"),
    IF("org.eclipse.jdt.ls.postfixcompletion.if", "postfix", "if (${i:inner_expression(boolean)}) {\n\t$${0}\n}", "Creates a if statement"),
    ELSE("org.eclipse.jdt.ls.postfixcompletion.else", "postfix", "if (!${i:inner_expression(boolean)}) {\n\t$${0}\n}", "Creates a negated if statement"),
    FOR("org.eclipse.jdt.postfixcompletion.for", "postfix", "for (${type:newActualType(i)} $${1:${n:newName(i)}} : ${i:inner_expression(java.util.Collection,array)}) {\n\t$${0}\n}", "Creates a for statement"),
    FORI("org.eclipse.jdt.postfixcompletion.fori", "postfix", "for (int $${1:${index}} = 0; $${1:${index}} < ${i:inner_expression(array)}.length; $${1:${index}}++) {\n\t$${0}\n}", "Creates a for statement which iterates over an array"),
    FORR("org.eclipse.jdt.postfixcompletion.forr", "postfix", "for (int $${1:${index}} = ${i:inner_expression(array)}.length - 1; $${1:${index}} >= 0; $${1:${index}}--) {\n\t$${0}\n}", "Creates a for statement which iterates over an array in reverse order"),
    FORMAT("org.eclipse.jdt.postfixcompletion.format", "postfix", "String.format(${i:inner_expression(java.lang.String)}${}, $${0});", "Sends the affected object to the String.format(..) method"),
    NNULL("org.eclipse.jdt.postfixcompletion.nnull", "postfix", "if (${i:inner_expression(java.lang.Object,array)} != null) {\n\t$${0}\n}", "Creates an if statement and checks if the expression does not resolve to null"),
    NULL("org.eclipse.jdt.postfixcompletion.null", "postfix", "if (${i:inner_expression(java.lang.Object,array)} == null) {\n\t$${0}\n}", "Creates an if statement which checks if expression resolves to null"),
    NOT("org.eclipse.jdt.postfixcompletion.not", "postfix", "!${i:inner_expression(boolean)}${}", "Negates the expression"),
    SYSOUT("org.eclipse.jdt.postfixcompletion.sysout", "postfix", "System.out.println(${i:inner_expression(java.lang.Object)}${});$${0}", "Sends the affected object to a System.out.println(..) call"),
    SYSOUF("org.eclipse.jdt.postfixcompletion.sysouf", "postfix", "System.out.printf(\"\", ${i:inner_expression(java.lang.Object)}${});$${0}", "Sends the affected object to a System.out.printf(..) call"),
    SYSOUTV("org.eclipse.jdt.postfixcompletion.sysoutv", "postfix", "System.out.println(\"${i:inner_expression(java.lang.Object)}${} = \" + ${i:inner_expression(java.lang.Object)}${});$${0}", "Sends the affected object to a System.out.println(..) call"),
    SYSERR("org.eclipse.jdt.postfixcompletion.syserr", "postfix", "System.err.println(${i:inner_expression(java.lang.Object)}${});$${0}", "Sends the affected object to a System.err.println(..) call"),
    THROW("org.eclipse.jdt.postfixcompletion.throw", "postfix", "throw ${true:inner_expression(java.lang.Throwable)};", "Throws the given Exception"),
    VAR("org.eclipse.jdt.postfixcompletion.var", "postfix", "${field:newType(inner_expression)} $${1:${var:newName(inner_expression)}} = ${inner_expression};$${0}", "Creates a new variable"),
    PAR("org.eclipse.jdt.postfixcompletion.par", "postfix", "(${i:inner_expression}${})", "Places the expression in parentheses"),
    WHILE("org.eclipse.jdt.postfixcompletion.while", "postfix", "while (${i:inner_expression(boolean)}) {\n\t$${0}\n}", "Creates a while loop");

    private final String templateId;
    private final String contextType;
    private final String defaultContent;
    private final String description;

    private PostfixTemplate(String templatesId, String contextType, String defaultContent, String description) {
        this.templateId = templatesId;
        this.contextType = contextType;
        this.defaultContent = defaultContent;
        this.description = description;
    }

    public Template createTemplate() {
        return new Template(this.name().toLowerCase(), this.description, this.contextType, this.defaultContent, false);
    }

    public String getId() {
        return this.templateId;
    }
}

