/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;

public class EclipseProjectImporter
extends AbstractProjectImporter {
    @Override
    public boolean applies(IProgressMonitor monitor) throws CoreException {
        if (this.directories == null) {
            BasicFileDetector eclipseDetector = new BasicFileDetector(this.rootFolder.toPath(), ".project").addExclusions("**/bin");
            IProject[] iProjectArray = ProjectUtils.getAllProjects(false);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                File projectFile = project.getLocation().toFile();
                eclipseDetector.addExclusions(projectFile.getAbsolutePath());
                ++n2;
            }
            this.directories = eclipseDetector.scan(monitor);
        }
        this.directories = this.directories.stream().filter(path -> new File(path.toFile(), ".classpath").exists()).collect(Collectors.toList());
        return !this.directories.isEmpty();
    }

    @Override
    public void reset() {
        this.directories = null;
    }

    public void setDirectories(Collection<java.nio.file.Path> paths) {
        this.directories = paths;
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.applies(monitor)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.directories.size());
        JavaLanguageServerPlugin.logInfo("Importing Eclipse project(s)");
        this.directories.forEach(d -> this.importDir((java.nio.file.Path)d, (IProgressMonitor)subMonitor.newChild(1)));
        subMonitor.done();
    }

    /*
     * Unable to fully structure code
     */
    private void importDir(java.nio.file.Path dir, IProgressMonitor m) {
        monitor = SubMonitor.convert((IProgressMonitor)m, (int)4);
        workspace = ResourcesPlugin.getWorkspace();
        dotProjectPath = new Path(dir.resolve(".project").toAbsolutePath().toString());
        try {
            descriptor = workspace.loadProjectDescription((IPath)dotProjectPath);
            name = descriptor.getName();
            if (!descriptor.hasNature("org.eclipse.jdt.core.javanature")) {
                return;
            }
            project = workspace.getRoot().getProject(name);
            if (!project.exists()) ** GOTO lbl19
            existingProjectPath = project.getLocation();
            if ((existingProjectPath = this.fixDevice(existingProjectPath)).equals((Object)(dotProjectPath = this.fixDevice((IPath)dotProjectPath)).removeLastSegments(1))) {
                project.open(0, (IProgressMonitor)monitor.newChild(1));
                project.refreshLocal(2, (IProgressMonitor)monitor.newChild(1));
                return;
            }
            try {
                project = this.findUniqueProject(workspace, name);
                descriptor.setName(project.getName());
lbl19:
                // 2 sources

                project.create(descriptor, (IProgressMonitor)monitor.newChild(1));
                project.open(0, (IProgressMonitor)monitor.newChild(1));
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e.getStatus());
                throw new RuntimeException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IPath fixDevice(IPath path) {
        if (path != null && path.getDevice() != null) {
            return path.setDevice(path.getDevice().toUpperCase());
        }
        if ("win32".equals(Platform.getOS()) && path != null && path.toString().startsWith("//")) {
            String server = path.segment(0);
            String pathStr = path.toString().replace(server, server.toUpperCase());
            return new Path(pathStr);
        }
        return path;
    }

    public IProject findUniqueProject(IWorkspace workspace, String basename) {
        IProject project = null;
        int i = 1;
        while (project == null || project.exists()) {
            String name = i < 2 ? basename : String.valueOf(basename) + " (" + i + ")";
            project = workspace.getRoot().getProject(name);
            ++i;
        }
        return project;
    }
}

