"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
const editorExtensions_1 = require("../../../browser/editorExtensions");
const editorConfigurationSchema_1 = require("../../../common/config/editorConfigurationSchema");
const codeActionCommands_1 = require("./codeActionCommands");
const nls = require("../../../../nls");
const configurationRegistry_1 = require("../../../../platform/configuration/common/configurationRegistry");
const platform_1 = require("../../../../platform/registry/common/platform");
(0, editorExtensions_1.registerEditorContribution)(codeActionCommands_1.CodeActionController.ID, codeActionCommands_1.CodeActionController);
(0, editorExtensions_1.registerEditorAction)(codeActionCommands_1.QuickFixAction);
(0, editorExtensions_1.registerEditorAction)(codeActionCommands_1.RefactorAction);
(0, editorExtensions_1.registerEditorAction)(codeActionCommands_1.RefactorPreview);
(0, editorExtensions_1.registerEditorAction)(codeActionCommands_1.SourceAction);
(0, editorExtensions_1.registerEditorAction)(codeActionCommands_1.OrganizeImportsAction);
(0, editorExtensions_1.registerEditorAction)(codeActionCommands_1.AutoFixAction);
(0, editorExtensions_1.registerEditorAction)(codeActionCommands_1.FixAllAction);
(0, editorExtensions_1.registerEditorCommand)(new codeActionCommands_1.CodeActionCommand());
platform_1.Registry.as(configurationRegistry_1.Extensions.Configuration).registerConfiguration(Object.assign(Object.assign({}, editorConfigurationSchema_1.editorConfigurationBaseNode), { properties: {
        'editor.codeActionWidget.showHeaders': {
            type: 'boolean',
            scope: 5 /* ConfigurationScope.LANGUAGE_OVERRIDABLE */,
            description: nls.localize('showCodeActionHeaders', "Enable/disable showing group headers in the code action menu."),
            default: true,
        },
    } }));
//# sourceMappingURL=codeActionContributions.js.map