/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.handlers.BaseInitHandler;
import org.eclipse.jdt.ls.core.internal.handlers.BundleUtils;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.RenameHandler;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceExecuteCommandHandler;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingService;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.DocumentOnTypeFormattingOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.SemanticHighlightingServerCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;

public final class InitHandler
extends BaseInitHandler {
    private static final String BUNDLES_KEY = "bundles";
    private JavaClientConnection connection;
    private PreferenceManager preferenceManager;
    private WorkspaceExecuteCommandHandler commandHandler;

    public InitHandler(ProjectsManager manager, PreferenceManager preferenceManager, JavaClientConnection connection, WorkspaceExecuteCommandHandler commandHandler) {
        super(manager, preferenceManager);
        this.connection = connection;
        this.preferenceManager = preferenceManager;
        this.commandHandler = commandHandler;
    }

    @Override
    public Map<?, ?> handleInitializationOptions(InitializeParams param) {
        Map<?, ?> initializationOptions = super.handleInitializationOptions(param);
        try {
            Collection bundleList = this.getInitializationOption(initializationOptions, BUNDLES_KEY, Collection.class);
            BundleUtils.loadBundles(bundleList);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to load extension bundles ", e);
        }
        return initializationOptions;
    }

    @Override
    public void registerCapabilities(InitializeResult initializeResult) {
        ServerCapabilities capabilities = new ServerCapabilities();
        if (!this.preferenceManager.getClientPreferences().isCompletionDynamicRegistered()) {
            capabilities.setCompletionProvider(CompletionHandler.DEFAULT_COMPLETION_OPTIONS);
        }
        if (!this.preferenceManager.getClientPreferences().isFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentFormattingProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isRangeFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentRangeFormattingProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isOnTypeFormattingDynamicRegistrationSupported()) {
            capabilities.setDocumentOnTypeFormattingProvider(new DocumentOnTypeFormattingOptions(";", Arrays.asList("\n", "}")));
        }
        if (!this.preferenceManager.getClientPreferences().isCodeLensDynamicRegistrationSupported()) {
            capabilities.setCodeLensProvider(new CodeLensOptions(true));
        }
        if (!this.preferenceManager.getClientPreferences().isSignatureHelpDynamicRegistrationSupported()) {
            capabilities.setSignatureHelpProvider(SignatureHelpHandler.createOptions());
        }
        if (!this.preferenceManager.getClientPreferences().isRenameDynamicRegistrationSupported()) {
            capabilities.setRenameProvider(RenameHandler.createOptions());
        }
        if (!this.preferenceManager.getClientPreferences().isCodeActionDynamicRegistered()) {
            capabilities.setCodeActionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isExecuteCommandDynamicRegistrationSupported()) {
            Set<String> commands = this.commandHandler.getAllCommands();
            if (!commands.isEmpty()) {
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(new ArrayList<String>(commands)));
            }
        } else {
            Set<String> staticCommands = this.commandHandler.getStaticCommands();
            if (!staticCommands.isEmpty()) {
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(new ArrayList<String>(staticCommands)));
            }
        }
        if (!this.preferenceManager.getClientPreferences().isWorkspaceSymbolDynamicRegistered()) {
            capabilities.setWorkspaceSymbolProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isClientDocumentSymbolProviderRegistered() && !this.preferenceManager.getClientPreferences().isDocumentSymbolDynamicRegistered()) {
            capabilities.setDocumentSymbolProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDefinitionDynamicRegistered()) {
            capabilities.setDefinitionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isTypeDefinitionDynamicRegistered()) {
            capabilities.setTypeDefinitionProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isClientHoverProviderRegistered() && !this.preferenceManager.getClientPreferences().isHoverDynamicRegistered()) {
            capabilities.setHoverProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isReferencesDynamicRegistered()) {
            capabilities.setReferencesProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isDocumentHighlightDynamicRegistered()) {
            capabilities.setDocumentHighlightProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isFoldgingRangeDynamicRegistered()) {
            capabilities.setFoldingRangeProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isImplementationDynamicRegistered()) {
            capabilities.setImplementationProvider(Boolean.TRUE);
        }
        if (!this.preferenceManager.getClientPreferences().isSelectionRangeDynamicRegistered()) {
            capabilities.setSelectionRangeProvider(Boolean.TRUE);
        }
        capabilities.setCallHierarchyProvider(Boolean.TRUE);
        TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
        textDocumentSyncOptions.setOpenClose(Boolean.TRUE);
        textDocumentSyncOptions.setSave(new SaveOptions(Boolean.TRUE));
        textDocumentSyncOptions.setChange(TextDocumentSyncKind.Incremental);
        if (this.preferenceManager.getClientPreferences().isWillSaveRegistered()) {
            textDocumentSyncOptions.setWillSave(Boolean.TRUE);
        }
        if (this.preferenceManager.getClientPreferences().isWillSaveWaitUntilRegistered()) {
            textDocumentSyncOptions.setWillSaveWaitUntil(Boolean.TRUE);
        }
        capabilities.setTextDocumentSync(textDocumentSyncOptions);
        if (this.preferenceManager.getClientPreferences().isSemanticHighlightingSupported()) {
            SemanticHighlightingServerCapabilities semanticHighlightingCapabilities = new SemanticHighlightingServerCapabilities();
            semanticHighlightingCapabilities.setScopes(SemanticHighlightingService.getAllScopes());
            capabilities.setSemanticHighlighting(semanticHighlightingCapabilities);
        }
        WorkspaceServerCapabilities wsCapabilities = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions wsFoldersOptions = new WorkspaceFoldersOptions();
        wsFoldersOptions.setSupported(Boolean.TRUE);
        wsFoldersOptions.setChangeNotifications(Boolean.TRUE);
        wsCapabilities.setWorkspaceFolders(wsFoldersOptions);
        capabilities.setWorkspace(wsCapabilities);
        initializeResult.setCapabilities(capabilities);
    }

    @Override
    public void triggerInitialization(final Collection<IPath> roots) {
        WorkspaceJob job = new WorkspaceJob("Initialize Workspace"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                InitHandler.this.connection.sendStatus(ServiceStatus.Starting, "Init...");
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ProjectsManager.setAutoBuilding(false);
                    InitHandler.this.projectsManager.initializeProjects(roots, (IProgressMonitor)subMonitor);
                    InitHandler.this.projectsManager.configureFilters(monitor);
                    ProjectsManager.setAutoBuilding(InitHandler.this.preferenceManager.getPreferences().isAutobuildEnabled());
                    JavaLanguageServerPlugin.logInfo("Workspace initialized in " + (System.currentTimeMillis() - start) + "ms");
                    InitHandler.this.connection.sendStatus(ServiceStatus.Started, "Ready");
                }
                catch (OperationCanceledException e) {
                    InitHandler.this.connection.sendStatus(ServiceStatus.Error, "Initialization has been cancelled.");
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException("Initialization failed ", e);
                    InitHandler.this.connection.sendStatus(ServiceStatus.Error, e.getMessage());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                Collection rootPathsSet = roots.stream().collect(Collectors.toSet());
                boolean equalToRootPaths = false;
                if (family instanceof Collection) {
                    equalToRootPaths = rootPathsSet.equals(((Collection)family).stream().collect(Collectors.toSet()));
                }
                return "java-ls-initialization-jobs".equals(family) || equalToRootPaths;
            }
        };
        job.setPriority(40);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }
}

