/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.code;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CodeRefactoringUtil {
    public static RefactoringStatus checkMethodSyntaxErrors(int selectionStart, int selectionLength, CompilationUnit cuNode, String invalidSelectionMessage) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength((int)selectionStart, (int)selectionLength), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode coveringNode = analyzer.getLastCoveringNode();
        if (!(coveringNode instanceof Block) || !(coveringNode.getParent() instanceof MethodDeclaration)) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        if (ASTNodes.getMessages((ASTNode)coveringNode, (int)0).length == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        MethodDeclaration methodDecl = (MethodDeclaration)coveringNode.getParent();
        String message = Messages.format(RefactoringCoreMessages.CodeRefactoringUtil_error_message, BasicElementLabels.getJavaElementName((String)methodDecl.getName().getIdentifier()));
        return RefactoringStatus.createFatalErrorStatus((String)message);
    }

    private CodeRefactoringUtil() {
    }
}

