/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.runner.common;

import com.microsoft.java.test.runner.common.Pair;
import com.microsoft.java.test.runner.common.TestMessageType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;

public class TestMessageItem {
    String name;
    List<Pair> attributes;
    TestMessageType type;

    public TestMessageItem(TestMessageType type, String name, List<Pair> attributes) {
        this.type = type;
        this.name = name;
        this.attributes = attributes;
    }

    public TestMessageItem(TestMessageType type, String name, Pair ... attributes) {
        this(type, name, attributes != null ? Arrays.asList(attributes) : null);
    }

    public TestMessageItem(String message, Throwable e) {
        this(TestMessageType.Error, "error", new Pair("message", message), new Pair("trace", TestMessageItem.getStacktrace(e)));
    }

    private static String getStacktrace(Throwable throwable) {
        StringWriter errors = new StringWriter();
        throwable.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }
}

