/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDiagnosticsHandler;

public class DiagnosticsHandler
extends BaseDiagnosticsHandler {
    private final ICompilationUnit cu;
    private final String uri;
    private boolean isDefaultProject;
    private boolean nonProjectFile = false;

    public DiagnosticsHandler(JavaClientConnection conn, ICompilationUnit cu) {
        super(conn, cu);
        this.cu = cu;
        this.uri = JDTUtils.toURI(cu);
        this.isDefaultProject = JDTUtils.isDefaultProject(cu);
        this.nonProjectFile = this.isDefaultProject || !JDTUtils.isOnClassPath(cu);
    }

    @Override
    public boolean isSyntaxMode() {
        return this.nonProjectFile && JavaLanguageServerPlugin.getNonProjectDiagnosticsState().isOnlySyntaxReported(this.uri);
    }

    @Override
    public void beginReporting() {
        super.beginReporting();
        if (this.nonProjectFile) {
            this.problems.add(this.createNonProjectProblem());
        }
    }

    private IProblem createNonProjectProblem() {
        String fileName = this.cu.getElementName();
        String projectName = this.cu.getJavaProject().getProject().getName();
        String message = null;
        int problemId = 16;
        if (this.isSyntaxMode()) {
            if (this.isDefaultProject) {
                message = String.valueOf(fileName) + " is a non-project file, only syntax errors are reported";
                problemId = 16;
            } else {
                message = String.valueOf(fileName) + " is not on the classpath of project " + projectName + ", only syntax errors are reported";
                problemId = 32;
            }
        } else if (this.isDefaultProject) {
            message = String.valueOf(fileName) + " is a non-project file, only JDK classes are added to its build path";
            problemId = 16;
        } else {
            message = String.valueOf(fileName) + " is not on the classpath of project " + projectName + ", it will not be compiled to a .class file";
            problemId = 32;
        }
        return new DefaultProblem(fileName.toCharArray(), message, problemId, null, 0, 0, 0, 1, 1);
    }

    public List<IProblem> getProblems() {
        return this.problems;
    }
}

