/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternConstructor {
    private PatternConstructor() {
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        if (!isRegexSearch) {
            pattern = PatternConstructor.asRegEx(pattern, new StringBuffer()).toString();
        }
        if (!isCaseSensitive) {
            return Pattern.compile(pattern, 74);
        }
        return Pattern.compile(pattern, 8);
    }

    public static Pattern createPattern(String[] patterns, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        StringBuffer pattern = new StringBuffer();
        int i = 0;
        while (i < patterns.length) {
            if (i > 0) {
                pattern.append('|');
            }
            if (isRegexSearch) {
                pattern.append(patterns[i]);
            } else {
                PatternConstructor.asRegEx(patterns[i], pattern);
            }
            ++i;
        }
        return PatternConstructor.createPattern(pattern.toString(), isCaseSensitive, true);
    }

    private static StringBuffer asRegEx(String stringMatcherPattern, StringBuffer out) {
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < stringMatcherPattern.length()) {
            char ch;
            if ((ch = stringMatcherPattern.charAt(i++)) == '*' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".*");
                escaped = false;
                continue;
            }
            if (ch == '?' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".");
                escaped = false;
                continue;
            }
            if (ch == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (ch == '\\' && escaped) {
                escaped = false;
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
                continue;
            }
            if (!quoting) {
                out.append("\\Q");
                quoting = true;
            }
            if (escaped && ch != '*' && ch != '?' && ch != '\\') {
                out.append('\\');
            }
            out.append(ch);
            boolean bl = escaped = ch == '\\';
        }
        if (quoting) {
            out.append("\\E");
        }
        return out;
    }
}

