/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.ManagedExecutorImpl;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.ManagedScheduledExecutorImpl;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.ThreadFactoryImpl;

public class DefaultExecutorFactory
implements ExecutorFactory,
Stoppable {
    private final Set<ManagedExecutor> executors = new CopyOnWriteArraySet<ManagedExecutor>();

    @Override
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.executors).stop();
        }
        finally {
            this.executors.clear();
        }
    }

    @Override
    public ManagedExecutor create(String displayName) {
        TrackedManagedExecutor executor = new TrackedManagedExecutor(this.createExecutor(displayName), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    protected ExecutorService createExecutor(String displayName) {
        return Executors.newCachedThreadPool(new ThreadFactoryImpl(displayName));
    }

    @Override
    public ManagedExecutor create(String displayName, int fixedSize) {
        TrackedManagedExecutor executor = new TrackedManagedExecutor(this.createExecutor(displayName, fixedSize), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    protected ExecutorService createExecutor(String displayName, int fixedSize) {
        return Executors.newFixedThreadPool(fixedSize, new ThreadFactoryImpl(displayName));
    }

    @Override
    public ManagedScheduledExecutor createScheduled(String displayName, int fixedSize) {
        TrackedScheduledManagedExecutor executor = new TrackedScheduledManagedExecutor(this.createScheduledExecutor(displayName, fixedSize), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    private ScheduledExecutorService createScheduledExecutor(String displayName, int fixedSize) {
        return new ScheduledThreadPoolExecutor(fixedSize, new ThreadFactoryImpl(displayName));
    }

    private class TrackedManagedExecutor
    extends ManagedExecutorImpl {
        TrackedManagedExecutor(ExecutorService executor, ExecutorPolicy executorPolicy) {
            super(executor, executorPolicy);
        }

        @Override
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            try {
                super.stop(timeoutValue, timeoutUnits);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }

    private class TrackedScheduledManagedExecutor
    extends ManagedScheduledExecutorImpl {
        TrackedScheduledManagedExecutor(ScheduledExecutorService executor, ExecutorPolicy executorPolicy) {
            super(executor, executorPolicy);
        }

        @Override
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            try {
                super.stop(timeoutValue, timeoutUnits);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }
}

