/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

import { SimpleWorkerServer } from '../base/common/worker/simpleWorker';
import { EditorSimpleWorker } from './common/services/editorSimpleWorker';
import { IEditorWorkerHost } from './common/services/editorWorkerHost';

let initialized = false;

export function initialize(foreignModule: any) {
	if (initialized) {
		return;
	}
	initialized = true;

	const simpleWorker = new SimpleWorkerServer((msg) => {
		(<any>self).postMessage(msg);
	}, (host: IEditorWorkerHost) => new EditorSimpleWorker(host, foreignModule));

	self.onmessage = (e: MessageEvent) => {
		simpleWorker.onmessage(e.data);
	};
}

self.onmessage = (e: MessageEvent) => {
	// Ignore first message in this case and initialize if not yet initialized
	if (!initialized) {
		initialize(null);
	}
};
