"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ISymbolNavigationService = exports.ctxHasSymbols = void 0;
const event_1 = require("../../../../base/common/event");
const lifecycle_1 = require("../../../../base/common/lifecycle");
const resources_1 = require("../../../../base/common/resources");
const editorExtensions_1 = require("../../../browser/editorExtensions");
const codeEditorService_1 = require("../../../browser/services/codeEditorService");
const range_1 = require("../../../common/core/range");
const nls_1 = require("../../../../nls");
const contextkey_1 = require("../../../../platform/contextkey/common/contextkey");
const extensions_1 = require("../../../../platform/instantiation/common/extensions");
const instantiation_1 = require("../../../../platform/instantiation/common/instantiation");
const keybinding_1 = require("../../../../platform/keybinding/common/keybinding");
const keybindingsRegistry_1 = require("../../../../platform/keybinding/common/keybindingsRegistry");
const notification_1 = require("../../../../platform/notification/common/notification");
exports.ctxHasSymbols = new contextkey_1.RawContextKey('hasSymbols', false, (0, nls_1.localize)('hasSymbols', "Whether there are symbol locations that can be navigated via keyboard-only."));
exports.ISymbolNavigationService = (0, instantiation_1.createDecorator)('ISymbolNavigationService');
let SymbolNavigationService = class SymbolNavigationService {
    constructor(contextKeyService, _editorService, _notificationService, _keybindingService) {
        this._editorService = _editorService;
        this._notificationService = _notificationService;
        this._keybindingService = _keybindingService;
        this._currentModel = undefined;
        this._currentIdx = -1;
        this._ignoreEditorChange = false;
        this._ctxHasSymbols = exports.ctxHasSymbols.bindTo(contextKeyService);
    }
    reset() {
        var _a, _b;
        this._ctxHasSymbols.reset();
        (_a = this._currentState) === null || _a === void 0 ? void 0 : _a.dispose();
        (_b = this._currentMessage) === null || _b === void 0 ? void 0 : _b.dispose();
        this._currentModel = undefined;
        this._currentIdx = -1;
    }
    put(anchor) {
        const refModel = anchor.parent.parent;
        if (refModel.references.length <= 1) {
            this.reset();
            return;
        }
        this._currentModel = refModel;
        this._currentIdx = refModel.references.indexOf(anchor);
        this._ctxHasSymbols.set(true);
        this._showMessage();
        const editorState = new EditorState(this._editorService);
        const listener = editorState.onDidChange(_ => {
            if (this._ignoreEditorChange) {
                return;
            }
            const editor = this._editorService.getActiveCodeEditor();
            if (!editor) {
                return;
            }
            const model = editor.getModel();
            const position = editor.getPosition();
            if (!model || !position) {
                return;
            }
            let seenUri = false;
            let seenPosition = false;
            for (const reference of refModel.references) {
                if ((0, resources_1.isEqual)(reference.uri, model.uri)) {
                    seenUri = true;
                    seenPosition = seenPosition || range_1.Range.containsPosition(reference.range, position);
                }
                else if (seenUri) {
                    break;
                }
            }
            if (!seenUri || !seenPosition) {
                this.reset();
            }
        });
        this._currentState = (0, lifecycle_1.combinedDisposable)(editorState, listener);
    }
    revealNext(source) {
        if (!this._currentModel) {
            return Promise.resolve();
        }
        // get next result and advance
        this._currentIdx += 1;
        this._currentIdx %= this._currentModel.references.length;
        const reference = this._currentModel.references[this._currentIdx];
        // status
        this._showMessage();
        // open editor, ignore events while that happens
        this._ignoreEditorChange = true;
        return this._editorService.openCodeEditor({
            resource: reference.uri,
            options: {
                selection: range_1.Range.collapseToStart(reference.range),
                selectionRevealType: 3 /* TextEditorSelectionRevealType.NearTopIfOutsideViewport */
            }
        }, source).finally(() => {
            this._ignoreEditorChange = false;
        });
    }
    _showMessage() {
        var _a;
        (_a = this._currentMessage) === null || _a === void 0 ? void 0 : _a.dispose();
        const kb = this._keybindingService.lookupKeybinding('editor.gotoNextSymbolFromResult');
        const message = kb
            ? (0, nls_1.localize)('location.kb', "Symbol {0} of {1}, {2} for next", this._currentIdx + 1, this._currentModel.references.length, kb.getLabel())
            : (0, nls_1.localize)('location', "Symbol {0} of {1}", this._currentIdx + 1, this._currentModel.references.length);
        this._currentMessage = this._notificationService.status(message);
    }
};
SymbolNavigationService = __decorate([
    __param(0, contextkey_1.IContextKeyService),
    __param(1, codeEditorService_1.ICodeEditorService),
    __param(2, notification_1.INotificationService),
    __param(3, keybinding_1.IKeybindingService)
], SymbolNavigationService);
(0, extensions_1.registerSingleton)(exports.ISymbolNavigationService, SymbolNavigationService, true);
(0, editorExtensions_1.registerEditorCommand)(new class extends editorExtensions_1.EditorCommand {
    constructor() {
        super({
            id: 'editor.gotoNextSymbolFromResult',
            precondition: exports.ctxHasSymbols,
            kbOpts: {
                weight: 100 /* KeybindingWeight.EditorContrib */,
                primary: 70 /* KeyCode.F12 */
            }
        });
    }
    runEditorCommand(accessor, editor) {
        return accessor.get(exports.ISymbolNavigationService).revealNext(editor);
    }
});
keybindingsRegistry_1.KeybindingsRegistry.registerCommandAndKeybindingRule({
    id: 'editor.gotoNextSymbolFromResult.cancel',
    weight: 100 /* KeybindingWeight.EditorContrib */,
    when: exports.ctxHasSymbols,
    primary: 9 /* KeyCode.Escape */,
    handler(accessor) {
        accessor.get(exports.ISymbolNavigationService).reset();
    }
});
//
let EditorState = class EditorState {
    constructor(editorService) {
        this._listener = new Map();
        this._disposables = new lifecycle_1.DisposableStore();
        this._onDidChange = new event_1.Emitter();
        this.onDidChange = this._onDidChange.event;
        this._disposables.add(editorService.onCodeEditorRemove(this._onDidRemoveEditor, this));
        this._disposables.add(editorService.onCodeEditorAdd(this._onDidAddEditor, this));
        editorService.listCodeEditors().forEach(this._onDidAddEditor, this);
    }
    dispose() {
        this._disposables.dispose();
        this._onDidChange.dispose();
        (0, lifecycle_1.dispose)(this._listener.values());
    }
    _onDidAddEditor(editor) {
        this._listener.set(editor, (0, lifecycle_1.combinedDisposable)(editor.onDidChangeCursorPosition(_ => this._onDidChange.fire({ editor })), editor.onDidChangeModelContent(_ => this._onDidChange.fire({ editor }))));
    }
    _onDidRemoveEditor(editor) {
        var _a;
        (_a = this._listener.get(editor)) === null || _a === void 0 ? void 0 : _a.dispose();
        this._listener.delete(editor);
    }
};
EditorState = __decorate([
    __param(0, codeEditorService_1.ICodeEditorService)
], EditorState);
//# sourceMappingURL=symbolNavigation.js.map