"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectBox = exports.defaultStyles = void 0;
const selectBoxCustom_1 = require("./selectBoxCustom");
const selectBoxNative_1 = require("./selectBoxNative");
const widget_1 = require("../widget");
const color_1 = require("../../../common/color");
const objects_1 = require("../../../common/objects");
const platform_1 = require("../../../common/platform");
require("./selectBox.css");
exports.defaultStyles = {
    selectBackground: color_1.Color.fromHex('#3C3C3C'),
    selectForeground: color_1.Color.fromHex('#F0F0F0'),
    selectBorder: color_1.Color.fromHex('#3C3C3C')
};
class SelectBox extends widget_1.Widget {
    constructor(options, selected, contextViewProvider, styles = (0, objects_1.deepClone)(exports.defaultStyles), selectBoxOptions) {
        super();
        // Default to native SelectBox for OSX unless overridden
        if (platform_1.isMacintosh && !(selectBoxOptions === null || selectBoxOptions === void 0 ? void 0 : selectBoxOptions.useCustomDrawn)) {
            this.selectBoxDelegate = new selectBoxNative_1.SelectBoxNative(options, selected, styles, selectBoxOptions);
        }
        else {
            this.selectBoxDelegate = new selectBoxCustom_1.SelectBoxList(options, selected, contextViewProvider, styles, selectBoxOptions);
        }
        this._register(this.selectBoxDelegate);
    }
    // Public SelectBox Methods - routed through delegate interface
    get onDidSelect() {
        return this.selectBoxDelegate.onDidSelect;
    }
    setOptions(options, selected) {
        this.selectBoxDelegate.setOptions(options, selected);
    }
    select(index) {
        this.selectBoxDelegate.select(index);
    }
    setAriaLabel(label) {
        this.selectBoxDelegate.setAriaLabel(label);
    }
    focus() {
        this.selectBoxDelegate.focus();
    }
    blur() {
        this.selectBoxDelegate.blur();
    }
    setFocusable(focusable) {
        this.selectBoxDelegate.setFocusable(focusable);
    }
    render(container) {
        this.selectBoxDelegate.render(container);
    }
    style(styles) {
        this.selectBoxDelegate.style(styles);
    }
    applyStyles() {
        this.selectBoxDelegate.applyStyles();
    }
}
exports.SelectBox = SelectBox;
//# sourceMappingURL=selectBox.js.map