"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatRule = void 0;
const codicons_1 = require("../../../common/codicons");
require("./codicon/codicon.css");
require("./codicon/codicon-modifiers.css");
function formatRule(c) {
    let def = c.definition;
    while (def instanceof codicons_1.Codicon) {
        def = def.definition;
    }
    return `.codicon-${c.id}:before { content: '${def.fontCharacter}'; }`;
}
exports.formatRule = formatRule;
//# sourceMappingURL=codiconStyles.js.map