"use strict";
// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.loggerFrontendModule = void 0;
const inversify_1 = require("inversify");
const logger_protocol_1 = require("../common/logger-protocol");
const logger_1 = require("../common/logger");
const logger_watcher_1 = require("../common/logger-watcher");
const messaging_1 = require("./messaging");
const frontend_application_1 = require("./frontend-application");
const rpc_message_encoder_1 = require("../common/message-rpc/rpc-message-encoder");
exports.loggerFrontendModule = new inversify_1.ContainerModule(bind => {
    bind(frontend_application_1.FrontendApplicationContribution).toDynamicValue(ctx => ({
        initialize() {
            (0, logger_1.setRootLogger)(ctx.container.get(logger_1.ILogger));
        }
    }));
    bind(logger_1.LoggerName).toConstantValue(logger_1.rootLoggerName);
    bind(logger_1.ILogger).to(logger_1.Logger).inSingletonScope().whenTargetIsDefault();
    bind(logger_watcher_1.LoggerWatcher).toSelf().inSingletonScope();
    bind(logger_protocol_1.ILoggerServer).toDynamicValue(ctx => {
        const loggerWatcher = ctx.container.get(logger_watcher_1.LoggerWatcher);
        const connection = ctx.container.get(messaging_1.WebSocketConnectionProvider);
        const target = connection.createProxy(logger_protocol_1.loggerPath, loggerWatcher.getLoggerClient());
        function get(_, property) {
            if (property === 'log') {
                return (name, logLevel, message, params) => {
                    logger_protocol_1.ConsoleLogger.log(name, logLevel, message, params);
                    return target.log(name, logLevel, message, params).catch(err => {
                        if (err instanceof rpc_message_encoder_1.EncodingError) {
                            // In case of an EncodingError no RPC call is sent to the backend `ILoggerServer`. Nevertheless, we want to continue normally.
                            return;
                        }
                        throw err;
                    });
                };
            }
            return target[property];
        }
        return new Proxy(target, { get });
    }).inSingletonScope();
    bind(logger_1.LoggerFactory).toFactory(ctx => (name) => {
        const child = new inversify_1.Container({ defaultScope: 'Singleton' });
        child.parent = ctx.container;
        child.bind(logger_1.ILogger).to(logger_1.Logger).inTransientScope();
        child.bind(logger_1.LoggerName).toConstantValue(name);
        return child.get(logger_1.ILogger);
    });
});
//# sourceMappingURL=logger-frontend-module.js.map