"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var temp = require("temp");
var Path = require("path");
var stage_1 = require("./stage");
var chai_1 = require("chai");
var status_1 = require("./status");
var commit_1 = require("./commit");
var log_1 = require("./log");
var test_helper_1 = require("./test-helper");
var show_1 = require("./show");
var track = temp.track();
describe('show', function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        after(function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                track.cleanupSync();
                return [2 /*return*/];
            });
        }); });
        it('diff', function () { return __awaiter(void 0, void 0, void 0, function () {
            var repositoryPath, fileName, _a, _b, _c, _d, SHAs, _e, HEAD, second, first, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, nestedFileName, _v, _w, _x, _y, _z;
            var _0;
            return __generator(this, function (_1) {
                switch (_1.label) {
                    case 0:
                        repositoryPath = track.mkdirSync('test-repo-path');
                        return [4 /*yield*/, (0, test_helper_1.createTestRepository)(repositoryPath)];
                    case 1:
                        _1.sent();
                        fileName = Path.join(repositoryPath, 'A.txt');
                        fs.writeFileSync(fileName, 'second commit', { encoding: 'utf8' });
                        (0, chai_1.expect)(fs.readFileSync(fileName, { encoding: 'utf8' })).to.be.equal('second commit');
                        return [4 /*yield*/, (0, stage_1.stage)(repositoryPath, fileName)];
                    case 2:
                        _1.sent();
                        _a = chai_1.expect;
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 3:
                        _a.apply(void 0, [(_1.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.lengthOf(1);
                        return [4 /*yield*/, (0, commit_1.createCommit)(repositoryPath, 'second')];
                    case 4:
                        _1.sent();
                        _b = chai_1.expect;
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 5:
                        _b.apply(void 0, [(_1.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.empty;
                        fs.writeFileSync(fileName, 'third commit', { encoding: 'utf8' });
                        (0, chai_1.expect)(fs.readFileSync(fileName, { encoding: 'utf8' })).to.be.equal('third commit');
                        return [4 /*yield*/, (0, stage_1.stage)(repositoryPath, fileName)];
                    case 6:
                        _1.sent();
                        _c = chai_1.expect;
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 7:
                        _c.apply(void 0, [(_1.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.lengthOf(1);
                        return [4 /*yield*/, (0, commit_1.createCommit)(repositoryPath, 'third')];
                    case 8:
                        _1.sent();
                        _d = chai_1.expect;
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 9:
                        _d.apply(void 0, [(_1.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.empty;
                        return [4 /*yield*/, (0, log_1.logCommitSHAs)(repositoryPath, fileName)];
                    case 10:
                        SHAs = _1.sent();
                        (0, chai_1.expect)(SHAs).to.be.lengthOf(3);
                        _e = __read(SHAs, 3), HEAD = _e[0], second = _e[1], first = _e[2];
                        _f = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, HEAD, fileName)];
                    case 11:
                        _f.apply(void 0, [(_1.sent()).toString()]).to.be.equal('third commit');
                        _g = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, second, fileName)];
                    case 12:
                        _g.apply(void 0, [(_1.sent()).toString()]).to.be.equal('second commit');
                        _h = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, first, fileName)];
                    case 13:
                        _h.apply(void 0, [(_1.sent()).toString()]).to.be.equal('A');
                        _j = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, 'HEAD', fileName)];
                    case 14:
                        _j.apply(void 0, [(_1.sent()).toString()]).to.be.equal('third commit');
                        fs.writeFileSync(fileName, 'just staged', { encoding: 'utf8' });
                        (0, chai_1.expect)(fs.readFileSync(fileName, { encoding: 'utf8' })).to.be.equal('just staged');
                        return [4 /*yield*/, (0, stage_1.stage)(repositoryPath, fileName)];
                    case 15:
                        _1.sent();
                        _k = chai_1.expect;
                        return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                    case 16:
                        _k.apply(void 0, [(_1.sent()).workingDirectory.files.filter(function (f) { return f.staged; })]).to.be.lengthOf(1);
                        fs.writeFileSync(fileName, 'changed but un-staged', { encoding: 'utf8' });
                        (0, chai_1.expect)(fs.readFileSync(fileName, { encoding: 'utf8' })).to.be.equal('changed but un-staged');
                        return [4 /*yield*/, (0, log_1.logCommitSHAs)(repositoryPath, fileName)];
                    case 17:
                        SHAs = _1.sent();
                        (0, chai_1.expect)(SHAs).to.be.lengthOf(3);
                        _0 = __read(SHAs, 3), HEAD = _0[0], second = _0[1], first = _0[2];
                        _l = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, HEAD, fileName)];
                    case 18:
                        _l.apply(void 0, [(_1.sent()).toString()]).to.be.equal('third commit');
                        _m = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, second, fileName)];
                    case 19:
                        _m.apply(void 0, [(_1.sent()).toString()]).to.be.equal('second commit');
                        _o = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, first, fileName)];
                    case 20:
                        _o.apply(void 0, [(_1.sent()).toString()]).to.be.equal('A');
                        _p = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, 'HEAD', fileName)];
                    case 21:
                        _p.apply(void 0, [(_1.sent()).toString()]).to.be.equal('third commit');
                        _q = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, 'HEAD~1', fileName)];
                    case 22:
                        _q.apply(void 0, [(_1.sent()).toString()]).to.be.equal('second commit');
                        _r = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, 'HEAD~2', fileName)];
                    case 23:
                        _r.apply(void 0, [(_1.sent()).toString()]).to.be.equal('A');
                        _s = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, HEAD + "~1", fileName)];
                    case 24:
                        _s.apply(void 0, [(_1.sent()).toString()]).to.be.equal('second commit');
                        _t = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, HEAD + "~2", fileName)];
                    case 25:
                        _t.apply(void 0, [(_1.sent()).toString()]).to.be.equal('A');
                        _u = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, '', fileName)];
                    case 26:
                        _u.apply(void 0, [(_1.sent()).toString()]).to.be.equal('just staged');
                        nestedFileName = Path.join(repositoryPath, 'folder', 'C.txt');
                        (0, chai_1.expect)(fs.readFileSync(nestedFileName, { encoding: 'utf8' })).to.be.equal('C');
                        _v = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, 'HEAD', nestedFileName)];
                    case 27:
                        _v.apply(void 0, [(_1.sent()).toString()]).to.be.equal('C');
                        fs.writeFileSync(nestedFileName, 'some other content', { encoding: 'utf8' });
                        (0, chai_1.expect)(fs.readFileSync(nestedFileName, { encoding: 'utf8' })).to.be.equal('some other content');
                        _w = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, 'HEAD', nestedFileName)];
                    case 28:
                        _w.apply(void 0, [(_1.sent()).toString()]).to.be.equal('C');
                        _x = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, '', nestedFileName)];
                    case 29:
                        _x.apply(void 0, [(_1.sent()).toString()]).to.be.equal('C');
                        return [4 /*yield*/, (0, stage_1.stage)(repositoryPath, nestedFileName)];
                    case 30:
                        _1.sent();
                        _y = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, 'HEAD', nestedFileName)];
                    case 31:
                        _y.apply(void 0, [(_1.sent()).toString()]).to.be.equal('C');
                        _z = chai_1.expect;
                        return [4 /*yield*/, (0, show_1.getTextContents)(repositoryPath, '', nestedFileName)];
                    case 32:
                        _z.apply(void 0, [(_1.sent()).toString()]).to.be.equal('some other content');
                        return [2 /*return*/];
                }
            });
        }); });
        return [2 /*return*/];
    });
}); });
//# sourceMappingURL=show.spec.js.map