"use strict";
// *****************************************************************************
// Copyright (C) 2021 Arm and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooltipServiceImpl = exports.TooltipService = void 0;
const inversify_1 = require("inversify");
const React = require("react");
const react_tooltip_1 = require("react-tooltip");
const react_renderer_1 = require("./widgets/react-renderer");
const core_preferences_1 = require("./core-preferences");
const uuid_1 = require("uuid");
exports.TooltipService = Symbol('TooltipService');
const DELAY_PREFERENCE = 'workbench.hover.delay';
let TooltipServiceImpl = class TooltipServiceImpl extends react_renderer_1.ReactRenderer {
    constructor(host) {
        super(host);
        this.rendered = false;
        this.tooltipId = (0, uuid_1.v4)();
    }
    init() {
        this.toDispose.push(this.corePreferences.onPreferenceChanged(preference => {
            if (preference.preferenceName === DELAY_PREFERENCE) {
                this.update(true);
            }
        }));
    }
    attachTo(host) {
        host.appendChild(this.host);
    }
    update(fullRender = false) {
        if (fullRender || !this.rendered) {
            this.render();
            this.rendered = true;
        }
        react_tooltip_1.default.rebuild();
    }
    doRender() {
        const hoverDelay = this.corePreferences.get(DELAY_PREFERENCE);
        return React.createElement(react_tooltip_1.default, { id: this.tooltipId, className: 'theia-tooltip', html: true, delayShow: hoverDelay });
    }
    dispose() {
        this.toDispose.dispose();
        super.dispose();
    }
};
__decorate([
    (0, inversify_1.inject)(core_preferences_1.CorePreferences),
    __metadata("design:type", Object)
], TooltipServiceImpl.prototype, "corePreferences", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TooltipServiceImpl.prototype, "init", null);
TooltipServiceImpl = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(react_renderer_1.RendererHost)),
    __param(0, (0, inversify_1.optional)()),
    __metadata("design:paramtypes", [Object])
], TooltipServiceImpl);
exports.TooltipServiceImpl = TooltipServiceImpl;
//# sourceMappingURL=tooltip-service.js.map