/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.launchers;

import com.microsoft.java.test.plugin.launchers.JUnitLaunchUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JUnitLaunchConfigurationDelegate
extends org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate {
    public JUnitLaunchArguments getJUnitLaunchArguments(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        Launch launch = new Launch(configuration, mode, null);
        try {
            Method getVMRunnerConfiguration = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredMethod("getVMRunnerConfiguration", ILaunchConfiguration.class, ILaunch.class, String.class, IProgressMonitor.class);
            getVMRunnerConfiguration.setAccessible(true);
            VMRunnerConfiguration config = (VMRunnerConfiguration)getVMRunnerConfiguration.invoke((Object)this, configuration, launch, mode, new NullProgressMonitor());
            IJavaProject javaProject = this.getJavaProject(configuration);
            JUnitLaunchArguments launchArguments = new JUnitLaunchArguments();
            launchArguments.workingDirectory = config.getWorkingDirectory();
            launchArguments.mainClass = config.getClassToLaunch();
            launchArguments.projectName = javaProject.getProject().getName();
            launchArguments.classpath = config.getClassPath();
            launchArguments.modulepath = config.getModulepath();
            launchArguments.vmArguments = this.getVmArguments(config);
            launchArguments.programArguments = config.getProgramArguments();
            return launchArguments;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    private String[] getVmArguments(VMRunnerConfiguration config) {
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.addAll(Arrays.asList(config.getVMArguments()));
        if (config.isPreviewEnabled()) {
            vmArgs.add("--enable-preview");
        }
        String dependencies = config.getOverrideDependencies();
        JUnitLaunchUtils.addOverrideDependencies(vmArgs, dependencies);
        return vmArgs.toArray(new String[vmArgs.size()]);
    }

    public static class JUnitLaunchArguments {
        String workingDirectory;
        String mainClass;
        String projectName;
        String[] classpath;
        String[] modulepath;
        String[] vmArguments;
        String[] programArguments;
    }
}

