/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.semantictokens;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.ls.core.internal.semantictokens.SemanticTokens;
import org.eclipse.jdt.ls.core.internal.semantictokens.TokenModifier;
import org.eclipse.jdt.ls.core.internal.semantictokens.TokenType;

public class SemanticTokensVisitor
extends ASTVisitor {
    private CompilationUnit cu;
    private List<SemanticToken> tokens;
    private boolean isInsideImportDeclaration = false;

    public SemanticTokensVisitor(CompilationUnit cu) {
        this.cu = cu;
        this.tokens = new ArrayList<SemanticToken>();
    }

    public SemanticTokens getSemanticTokens() {
        return new SemanticTokens(this.encodedTokens());
    }

    private int[] encodedTokens() {
        int numTokens = this.tokens.size();
        int[] data = new int[numTokens * 5];
        int currentLine = 0;
        int currentColumn = 0;
        int i = 0;
        while (i < numTokens) {
            SemanticToken token = this.tokens.get(i);
            int line = this.cu.getLineNumber(token.getOffset()) - 1;
            int column = this.cu.getColumnNumber(token.getOffset());
            int deltaLine = line - currentLine;
            if (deltaLine != 0) {
                currentLine = line;
                currentColumn = 0;
            }
            int deltaColumn = column - currentColumn;
            currentColumn = column;
            if (deltaLine != 0 || deltaColumn != 0) {
                int tokenTypeIndex = token.getTokenType().ordinal();
                int tokenModifiers = token.getTokenModifiers();
                int offset = i * 5;
                data[offset] = deltaLine;
                data[offset + 1] = deltaColumn;
                data[offset + 2] = token.getLength();
                data[offset + 3] = tokenTypeIndex;
                data[offset + 4] = tokenModifiers;
            }
            ++i;
        }
        return data;
    }

    private void addToken(ASTNode node, TokenType tokenType, int modifiers) {
        int offset = node.getStartPosition();
        int length = node.getLength();
        SemanticToken token = new SemanticToken(offset, length, tokenType, modifiers);
        this.tokens.add(token);
    }

    public boolean visit(ImportDeclaration node) {
        this.isInsideImportDeclaration = true;
        IBinding binding = node.resolveBinding();
        if (binding == null || binding instanceof IPackageBinding) {
            this.visitPackageName(node.getName());
        } else {
            this.visitNonPackageName(node.getName());
        }
        this.isInsideImportDeclaration = false;
        return false;
    }

    private void visitPackageName(Name packageName) {
        int modifiers;
        int n = modifiers = this.isInsideImportDeclaration ? TokenModifier.IMPORT_DECLARATION.bitmask : 0;
        if (packageName instanceof SimpleName) {
            this.addToken((ASTNode)packageName, TokenType.PACKAGE, modifiers);
        } else {
            QualifiedName qualifiedName = (QualifiedName)packageName;
            this.visitPackageName(qualifiedName.getQualifier());
            this.addToken((ASTNode)qualifiedName.getName(), TokenType.PACKAGE, modifiers);
        }
    }

    private void visitNonPackageName(Name nonPackageName) {
        if (nonPackageName instanceof SimpleName) {
            nonPackageName.accept((ASTVisitor)this);
        } else {
            QualifiedName qualifiedName = (QualifiedName)nonPackageName;
            Name qualifier = qualifiedName.getQualifier();
            if (this.hasPackageQualifier(qualifiedName)) {
                this.visitPackageName(qualifier);
            } else {
                this.visitNonPackageName(qualifier);
            }
            qualifiedName.getName().accept((ASTVisitor)this);
        }
    }

    private boolean hasPackageQualifier(QualifiedName qualifiedName) {
        IBinding qualifierBinding = qualifiedName.getQualifier().resolveBinding();
        if (qualifierBinding != null) {
            return qualifierBinding instanceof IPackageBinding;
        }
        IBinding parentBinding = qualifiedName.resolveBinding();
        return parentBinding instanceof IPackageBinding || parentBinding instanceof ITypeBinding;
    }

    public boolean visit(Modifier node) {
        this.addToken((ASTNode)node, TokenType.MODIFIER, 0);
        return super.visit(node);
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        TokenType tokenType = TokenType.getApplicableType(binding);
        if (tokenType != null) {
            int modifiers = TokenModifier.getApplicableModifiers(binding);
            if (TokenModifier.isGeneric(binding)) {
                modifiers |= TokenModifier.GENERIC.bitmask;
            }
            if (this.isInsideImportDeclaration) {
                modifiers |= TokenModifier.IMPORT_DECLARATION.bitmask;
            } else if (TokenModifier.isDeclaration(node)) {
                modifiers |= TokenModifier.DECLARATION.bitmask;
            }
            this.addToken((ASTNode)node, tokenType, modifiers);
        }
        return super.visit(node);
    }

    public boolean visit(ParameterizedType node) {
        node.getType().accept((ASTVisitor)this);
        for (Object typeArgument : node.typeArguments()) {
            this.visitTypeArgument((Type)typeArgument);
        }
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        for (Object typeArgument : node.typeArguments()) {
            ((ASTNode)typeArgument).accept((ASTVisitor)this);
        }
        this.visitSimpleNameOfType(node.getType(), simpleName -> {
            IMethodBinding constructorBinding = node.resolveConstructorBinding();
            int modifiers = TokenModifier.getApplicableModifiers((IBinding)constructorBinding);
            if (TokenModifier.isGeneric(constructorBinding) || node.getType().isParameterizedType()) {
                modifiers |= TokenModifier.GENERIC.bitmask;
            }
            this.addToken(simpleName, TokenType.METHOD, modifiers);
        });
        for (Object argument : node.arguments()) {
            ((ASTNode)argument).accept((ASTVisitor)this);
        }
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    private void visitTypeArgument(Type typeArgument) {
        this.visitSimpleNameOfType(typeArgument, simpleName -> {
            IBinding binding = simpleName.resolveBinding();
            TokenType tokenType = TokenType.getApplicableType(binding);
            if (tokenType != null) {
                int modifiers = TokenModifier.getApplicableModifiers(binding);
                if (TokenModifier.isGeneric((ITypeBinding)binding)) {
                    modifiers |= TokenModifier.GENERIC.bitmask;
                }
                this.addToken(simpleName, tokenType, modifiers |= TokenModifier.TYPE_ARGUMENT.bitmask);
            }
        });
    }

    private void visitSimpleNameOfType(Type type, NodeVisitor<SimpleName> visitor) {
        if (type == null) {
            return;
        }
        if (type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            for (Object annotation : simpleType.annotations()) {
                ((ASTNode)annotation).accept((ASTVisitor)this);
            }
            Name simpleTypeName = simpleType.getName();
            if (simpleTypeName instanceof SimpleName) {
                visitor.visit((SimpleName)simpleTypeName);
            } else {
                QualifiedName qualifiedName = (QualifiedName)simpleTypeName;
                qualifiedName.getQualifier().accept((ASTVisitor)this);
                visitor.visit(qualifiedName.getName());
            }
        } else if (type instanceof QualifiedType) {
            QualifiedType qualifiedType = (QualifiedType)type;
            qualifiedType.getQualifier().accept((ASTVisitor)this);
            for (Object annotation : qualifiedType.annotations()) {
                ((ASTNode)annotation).accept((ASTVisitor)this);
            }
            visitor.visit(qualifiedType.getName());
        } else if (type instanceof NameQualifiedType) {
            NameQualifiedType nameQualifiedType = (NameQualifiedType)type;
            nameQualifiedType.getQualifier().accept((ASTVisitor)this);
            for (Object annotation : nameQualifiedType.annotations()) {
                ((ASTNode)annotation).accept((ASTVisitor)this);
            }
            visitor.visit(nameQualifiedType.getName());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.visitSimpleNameOfType(parameterizedType.getType(), visitor);
            for (Object typeArgument : parameterizedType.typeArguments()) {
                this.visitTypeArgument((Type)typeArgument);
            }
        } else {
            type.accept((ASTVisitor)this);
        }
    }

    @FunctionalInterface
    private static interface NodeVisitor<T extends ASTNode> {
        public void visit(T var1);
    }

    private class SemanticToken {
        private final TokenType tokenType;
        private final int tokenModifiers;
        private final int offset;
        private final int length;

        public SemanticToken(int offset, int length, TokenType tokenType, int tokenModifiers) {
            this.offset = offset;
            this.length = length;
            this.tokenType = tokenType;
            this.tokenModifiers = tokenModifiers;
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }

        public int getTokenModifiers() {
            return this.tokenModifiers;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }
}

