/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.OccurrencesFinder;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class DocumentHighlightHandler {
    private List<DocumentHighlight> computeOccurrences(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        if (unit != null) {
            try {
                String error;
                int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
                OccurrencesFinder finder = new OccurrencesFinder();
                CompilationUnit ast = CoreASTProvider.getInstance().getAST(unit, CoreASTProvider.WAIT_YES, monitor);
                if (ast != null && (error = finder.initialize(ast, offset, 0)) == null) {
                    ArrayList<DocumentHighlight> result = new ArrayList<DocumentHighlight>();
                    IOccurrencesFinder.OccurrenceLocation[] occurrences = finder.getOccurrences();
                    if (occurrences != null) {
                        IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = occurrences;
                        int n = occurrences.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IOccurrencesFinder.OccurrenceLocation loc = occurrenceLocationArray[n2];
                            if (monitor.isCanceled()) {
                                return Collections.emptyList();
                            }
                            result.add(this.convertToHighlight(unit, loc));
                            ++n2;
                        }
                    }
                    return result;
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException("Problem with compute occurrences for" + unit.getElementName(), e);
            }
        }
        return Collections.emptyList();
    }

    private DocumentHighlight convertToHighlight(ITypeRoot unit, IOccurrencesFinder.OccurrenceLocation occurrence) throws JavaModelException {
        DocumentHighlight h = new DocumentHighlight();
        if ((occurrence.getFlags() | 1) == 1) {
            h.setKind(DocumentHighlightKind.Write);
        } else if ((occurrence.getFlags() | 2) == 2) {
            h.setKind(DocumentHighlightKind.Read);
        }
        int[] loc = JsonRpcHelpers.toLine(unit.getBuffer(), occurrence.getOffset());
        int[] endLoc = JsonRpcHelpers.toLine(unit.getBuffer(), occurrence.getOffset() + occurrence.getLength());
        h.setRange(new Range(new Position(loc[0], loc[1]), new Position(endLoc[0], endLoc[1])));
        return h;
    }

    public List<? extends DocumentHighlight> documentHighlight(TextDocumentPositionParams position, IProgressMonitor monitor) {
        ITypeRoot type = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri());
        return this.computeOccurrences(type, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
    }
}

