/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JVMConfigurator;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.osgi.service.prefs.BackingStoreException;

public abstract class BaseInitHandler {
    public static final String JAVA_LS_INITIALIZATION_JOBS = "java-ls-initialization-jobs";
    public static final String SETTINGS_KEY = "settings";
    private PreferenceManager preferenceManager;
    protected ProjectsManager projectsManager;

    public BaseInitHandler(ProjectsManager projectsManager, PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.projectsManager = projectsManager;
        this.projectsManager.registerListeners();
    }

    public InitializeResult initialize(InitializeParams param) {
        JavaLanguageServerPlugin.logInfo("Initializing Java Language Server " + JavaLanguageServerPlugin.getVersion());
        InitializeResult result = new InitializeResult();
        this.handleInitializationOptions(param);
        this.registerCapabilities(result);
        this.triggerInitialization(this.preferenceManager.getPreferences().getRootPaths());
        return result;
    }

    public Map<?, ?> handleInitializationOptions(InitializeParams param) {
        Map<?, ?> initializationOptions = this.getInitializationOptions(param);
        Map extendedClientCapabilities = this.getInitializationOption(initializationOptions, "extendedClientCapabilities", Map.class);
        if (param.getCapabilities() == null) {
            this.preferenceManager.updateClientPrefences(new ClientCapabilities(), extendedClientCapabilities);
        } else {
            this.preferenceManager.updateClientPrefences(param.getCapabilities(), extendedClientCapabilities);
        }
        ArrayList<IPath> rootPaths = new ArrayList<IPath>();
        Collection workspaceFolders = this.getInitializationOption(initializationOptions, "workspaceFolders", Collection.class);
        if (workspaceFolders != null && !workspaceFolders.isEmpty()) {
            for (String uri : workspaceFolders) {
                IPath filePath = ResourceUtils.canonicalFilePathFromURI(uri);
                if (filePath == null) continue;
                rootPaths.add(filePath);
            }
        } else {
            IPath filePath;
            String rootPath = param.getRootUri();
            if (rootPath == null && (rootPath = param.getRootPath()) != null) {
                JavaLanguageServerPlugin.logInfo("In LSP 3.0, InitializeParams.rootPath is deprecated in favour of InitializeParams.rootUri!");
            }
            if (rootPath != null && (filePath = ResourceUtils.canonicalFilePathFromURI(rootPath)) != null) {
                rootPaths.add(filePath);
            }
        }
        if (rootPaths.isEmpty()) {
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            JavaLanguageServerPlugin.logInfo("No workspace folders or root uri was defined. Falling back on " + workspaceLocation);
            rootPaths.add(workspaceLocation);
        }
        if (initializationOptions.get(SETTINGS_KEY) instanceof Map) {
            Object settings = initializationOptions.get(SETTINGS_KEY);
            Preferences prefs = Preferences.createFrom((Map)settings);
            prefs.setRootPaths(rootPaths);
            this.preferenceManager.update(prefs);
            if (!this.isWorkspaceInitialized()) {
                try {
                    JVMConfigurator.configureJVMs(prefs);
                    this.registerWorkspaceInitialized();
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException("Failed to configure Java Runtimes", e);
                }
            }
        } else {
            this.preferenceManager.getPreferences().setRootPaths(rootPaths);
        }
        ArrayList<IPath> triggerPaths = new ArrayList<IPath>();
        Collection triggerFiles = this.getInitializationOption(initializationOptions, "triggerFiles", Collection.class);
        if (triggerFiles != null) {
            for (String uri : triggerFiles) {
                IPath filePath = ResourceUtils.canonicalFilePathFromURI(uri);
                if (filePath == null) continue;
                triggerPaths.add(filePath);
            }
        }
        this.preferenceManager.getPreferences().setTriggerFiles(triggerPaths);
        Integer processId = param.getProcessId();
        if (processId != null) {
            JavaLanguageServerPlugin.getLanguageServer().setParentProcessId(processId.longValue());
        }
        return initializationOptions;
    }

    private void registerWorkspaceInitialized() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        prefs.putBoolean("workspaceInitialized", true);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }

    private boolean isWorkspaceInitialized() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ls.core");
        return prefs.getBoolean("workspaceInitialized", false);
    }

    public abstract void registerCapabilities(InitializeResult var1);

    public abstract void triggerInitialization(Collection<IPath> var1);

    protected Map<?, ?> getInitializationOptions(InitializeParams params) {
        Map initOptions = JSONUtility.toModel(params.getInitializationOptions(), Map.class);
        return initOptions == null ? Collections.emptyMap() : initOptions;
    }

    protected <T> T getInitializationOption(Map<?, ?> initializationOptions, String key, Class<T> clazz) {
        Object bundleObject;
        if (initializationOptions != null && clazz.isInstance(bundleObject = initializationOptions.get(key))) {
            return clazz.cast(bundleObject);
        }
        return null;
    }
}

