/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CleanUpConstants;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFixCore;
import org.eclipse.jdt.internal.corext.fix.ICleanUpCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LambdaExpressionsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.LambdaExpressionsCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InvertBooleanUtility;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.TypeChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactorProposalUtility;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactoringCorrectionCommandProposal;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;

public class RefactorProcessor {
    public static final String CONVERT_ANONYMOUS_CLASS_TO_NESTED_COMMAND = "convertAnonymousClassToNestedCommand";
    private PreferenceManager preferenceManager;

    public RefactorProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<ChangeCorrectionProposal> getProposals(CodeActionParams params, IInvocationContext context, IProblemLocationCore[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList<ChangeCorrectionProposal> proposals = new ArrayList<ChangeCorrectionProposal>();
            InvertBooleanUtility.getInverseConditionProposals(params, context, coveringNode, proposals);
            this.getInverseLocalVariableProposals(params, context, coveringNode, proposals);
            this.getMoveRefactoringProposals(params, context, coveringNode, proposals);
            boolean noErrorsAtLocation = RefactorProcessor.noErrorsAtLocation(locations);
            if (noErrorsAtLocation) {
                boolean problemsAtLocation = locations.length != 0;
                this.getExtractVariableProposal(params, context, problemsAtLocation, proposals);
                this.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, proposals);
                this.getExtractFieldProposal(params, context, problemsAtLocation, proposals);
                this.getInlineProposal(context, coveringNode, proposals);
                this.getConvertAnonymousToNestedProposals(params, context, coveringNode, proposals);
                RefactorProcessor.getConvertAnonymousClassCreationsToLambdaProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertLambdaToAnonymousClassCreationsProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertVarTypeToResolvedTypeProposal(context, coveringNode, proposals);
                RefactorProcessor.getConvertResolvedTypeToVarTypeProposal(context, coveringNode, proposals);
                RefactorProcessor.getAddStaticImportProposals(context, coveringNode, proposals);
                RefactorProcessor.getConvertForLoopProposal(context, coveringNode, proposals);
                this.getAssignToVariableProposals(context, coveringNode, locations, proposals, params);
                this.getIntroduceParameterProposals(params, context, coveringNode, locations, proposals);
            }
            return proposals;
        }
        return Collections.emptyList();
    }

    private boolean getIntroduceParameterProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, IProblemLocationCore[] locations, ArrayList<ChangeCorrectionProposal> resultingCollections) throws CoreException {
        if (resultingCollections == null) {
            return false;
        }
        CUCorrectionProposal proposal = RefactorProposalUtility.getIntroduceParameterRefactoringProposals(params, context, coveringNode, this.preferenceManager.getClientPreferences().isAdvancedIntroduceParameterRefactoringSupported(), locations);
        if (proposal != null) {
            return resultingCollections.add(proposal);
        }
        return false;
    }

    private boolean getInverseLocalVariableProposals(CodeActionParams params, IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> proposals) {
        if (proposals == null) {
            return false;
        }
        ChangeCorrectionProposal proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? InvertBooleanUtility.getInvertVariableProposal(params, context, covering, true) : InvertBooleanUtility.getInvertVariableProposal(params, context, covering, false);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getMoveRefactoringProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, ArrayList<ChangeCorrectionProposal> resultingCollections) {
        List<CUCorrectionProposal> newProposals;
        if (resultingCollections == null) {
            return false;
        }
        if (this.preferenceManager.getClientPreferences().isMoveRefactoringSupported() && (newProposals = RefactorProposalUtility.getMoveRefactoringProposals(params, context)) != null && !newProposals.isEmpty()) {
            resultingCollections.addAll(newProposals);
            return true;
        }
        return false;
    }

    static boolean noErrorsAtLocation(IProblemLocationCore[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                IProblemLocationCore location = locations[i];
                if (location.isError() && (!"org.eclipse.jdt.core.problem".equals(location.getMarkerType()) || JavaCore.getOptionForConfigurableSeverity((int)location.getProblemId()) == null)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        List<CUCorrectionProposal> newProposals = null;
        newProposals = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProposalUtility.getExtractVariableCommandProposals(params, context, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractVariableInferSelectionSupported()) : RefactorProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractVariableInferSelectionSupported());
        if (newProposals == null || newProposals.isEmpty()) {
            return false;
        }
        proposals.addAll(newProposals);
        return true;
    }

    private boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, IProblemLocationCore[] locations, Collection<ChangeCorrectionProposal> resultingCollections, CodeActionParams params) {
        try {
            Map formatterOptions = null;
            CUCorrectionProposal proposal = RefactorProposalUtility.getAssignVariableProposal(params, context, locations != null && locations.length != 0, formatterOptions, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), locations);
            if (proposal != null) {
                resultingCollections.add(proposal);
            }
            if ((proposal = RefactorProposalUtility.getAssignFieldProposal(params, context, locations != null && locations.length != 0, formatterOptions, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), locations)) != null) {
                resultingCollections.add(proposal);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e);
        }
        return true;
    }

    private boolean getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        CUCorrectionProposal proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProposalUtility.getExtractMethodCommandProposal(params, context, coveringNode, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractMethodInferSelectionSupported()) : RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, this.preferenceManager.getClientPreferences().isExtractMethodInferSelectionSupported());
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        CUCorrectionProposal proposal = RefactorProposalUtility.getGenericExtractFieldProposal(params, context, problemsAtLocation, null, null, this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported(), this.preferenceManager.getClientPreferences().isExtractFieldInferSelectionSupported());
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    private boolean getInlineProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        IBinding binding;
        block12: {
            InlineTempRefactoring refactoring;
            ASTNode decl;
            block17: {
                IVariableBinding varBinding;
                block14: {
                    block15: {
                        CreateChangeOperation create;
                        block16: {
                            Change[] refactoringChanges;
                            InlineConstantRefactoring refactoring2;
                            block13: {
                                if (resultingCollections == null) {
                                    return false;
                                }
                                if (!(node instanceof SimpleName)) {
                                    return false;
                                }
                                SimpleName name = (SimpleName)node;
                                binding = name.resolveBinding();
                                if (!(binding instanceof IVariableBinding)) break block12;
                                varBinding = (IVariableBinding)binding;
                                if (!varBinding.isParameter()) break block13;
                                return false;
                            }
                            if (!varBinding.isField()) break block14;
                            if (!RefactoringAvailabilityTesterCore.isInlineConstantAvailable((IField)((IField)varBinding.getJavaElement())) || (refactoring2 = new InlineConstantRefactoring(context.getCompilationUnit(), context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength())) == null || !refactoring2.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) break block15;
                            refactoring2.setRemoveDeclaration(refactoring2.isDeclarationSelected());
                            refactoring2.setReplaceAllReferences(refactoring2.isDeclarationSelected());
                            CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring2, 4);
                            create = new CreateChangeOperation(check, 4);
                            create.run((IProgressMonitor)new NullProgressMonitor());
                            int referenceCount = 0;
                            Change change = create.getChange();
                            Change[] changeArray = refactoringChanges = ((DynamicValidationRefactoringChange)change).getChildren();
                            int n = refactoringChanges.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Change refactoringChange = changeArray[n2];
                                referenceCount += ((CompilationUnitChange)refactoringChange).getChangeGroups().length;
                                ++n2;
                            }
                            if (referenceCount > true || !refactoring2.isDeclarationSelected()) break block16;
                            return true;
                        }
                        String label = ActionMessages.InlineConstantRefactoringAction_label;
                        int relevance = 5;
                        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label, "refactor.inline", create.getChange(), relevance);
                        resultingCollections.add(proposal);
                        return true;
                    }
                    return false;
                }
                decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
                if (decl instanceof VariableDeclarationFragment && decl.getLocationInParent() == VariableDeclarationStatement.FRAGMENTS_PROPERTY) break block17;
                return false;
            }
            if (binding.getJavaElement() instanceof ILocalVariable && RefactoringAvailabilityTesterCore.isInlineTempAvailable((ILocalVariable)((ILocalVariable)binding.getJavaElement())) && (refactoring = new InlineTempRefactoring((VariableDeclaration)decl)).checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK() && refactoring.getReferences().length > 0) {
                String label = CorrectionMessages.QuickAssistProcessor_inline_local_description;
                int relevance = 5;
                RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.inline", context.getCompilationUnit(), (Refactoring)refactoring, relevance);
                resultingCollections.add(proposal);
                return true;
            }
        }
        try {
            InlineMethodRefactoring refactoring;
            if (binding instanceof IMethodBinding && RefactoringAvailabilityTesterCore.isInlineMethodAvailable((IMethod)((IMethod)binding.getJavaElement())) && (refactoring = InlineMethodRefactoring.create((ITypeRoot)context.getCompilationUnit(), (CompilationUnit)context.getASTRoot(), (int)context.getSelectionOffset(), (int)context.getSelectionLength())) != null && refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                CheckConditionsOperation check = new CheckConditionsOperation((Refactoring)refactoring, 4);
                CreateChangeOperation create = new CreateChangeOperation(check, 4);
                create.run((IProgressMonitor)new NullProgressMonitor());
                String label = ActionMessages.InlineMethodRefactoringAction_label;
                int relevance = 5;
                ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label, "refactor.inline", create.getChange(), relevance);
                resultingCollections.add(proposal);
                return true;
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
        }
        return false;
    }

    private boolean getConvertAnonymousToNestedProposals(CodeActionParams params, IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> proposals) throws CoreException {
        if (proposals == null) {
            return false;
        }
        RefactoringCorrectionProposal proposal = null;
        proposal = this.preferenceManager.getClientPreferences().isAdvancedExtractRefactoringSupported() ? RefactorProcessor.getConvertAnonymousToNestedProposal(params, context, node, true) : RefactorProcessor.getConvertAnonymousToNestedProposal(params, context, node, false);
        if (proposal == null) {
            return false;
        }
        proposals.add(proposal);
        return true;
    }

    public static RefactoringCorrectionProposal getConvertAnonymousToNestedProposal(CodeActionParams params, IInvocationContext context, ASTNode node, boolean returnAsCommand) throws CoreException {
        String label = CorrectionMessages.QuickAssistProcessor_convert_anonym_to_nested;
        ClassInstanceCreation cic = RefactorProcessor.getClassInstanceCreation(node);
        if (cic == null) {
            return null;
        }
        AnonymousClassDeclaration anonymTypeDecl = cic.getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return null;
        }
        ConvertAnonymousToNestedRefactoring refactoring = new ConvertAnonymousToNestedRefactoring(anonymTypeDecl);
        if (!refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            return null;
        }
        if (returnAsCommand) {
            return new RefactoringCorrectionCommandProposal(label, "refactor", context.getCompilationUnit(), 5, "java.action.applyRefactoringCommand", Arrays.asList(CONVERT_ANONYMOUS_CLASS_TO_NESTED_COMMAND, params));
        }
        String extTypeName = ASTNodes.getTypeName((Type)cic.getType());
        ITypeBinding anonymTypeBinding = anonymTypeDecl.resolveBinding();
        String className = anonymTypeBinding.getInterfaces().length == 0 ? Messages.format((String)CorrectionMessages.QuickAssistProcessor_name_extension_from_interface, (Object)extTypeName) : Messages.format((String)CorrectionMessages.QuickAssistProcessor_name_extension_from_class, (Object)extTypeName);
        String[][] existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(className);
        int i = 1;
        while (existingTypes != null) {
            existingTypes = ((IType)anonymTypeBinding.getJavaElement()).resolveType(String.valueOf(className) + ++i);
        }
        refactoring.setClassName(i == 1 ? className : String.valueOf(className) + i);
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        refactoring.setLinkedProposalModel(linkedProposalModel);
        ICompilationUnit cu = context.getCompilationUnit();
        RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor", cu, (Refactoring)refactoring, 5);
        proposal.setLinkedProposalModel(linkedProposalModel);
        return proposal;
    }

    private static ClassInstanceCreation getClassInstanceCreation(ASTNode node) {
        while (node instanceof Name || node instanceof Type || node instanceof Dimension || node.getParent() instanceof MethodDeclaration || node.getLocationInParent() == AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY) {
            node = node.getParent();
        }
        if (node instanceof ClassInstanceCreation) {
            return (ClassInstanceCreation)node;
        }
        if (node.getLocationInParent() == ClassInstanceCreation.ANONYMOUS_CLASS_DECLARATION_PROPERTY) {
            return (ClassInstanceCreation)node.getParent();
        }
        return null;
    }

    private static boolean getConvertAnonymousClassCreationsToLambdaProposals(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) {
        ClassInstanceCreation cic = RefactorProcessor.getClassInstanceCreation(covering);
        if (cic == null) {
            return false;
        }
        LambdaExpressionsFixCore fix = LambdaExpressionsFixCore.createConvertToLambdaFix((ClassInstanceCreation)cic);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_lambda", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal((IProposableFix)fix, (ICleanUpCore)new LambdaExpressionsCleanUpCore(options), 6, context, "refactor");
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertLambdaToAnonymousClassCreationsProposals(IInvocationContext context, ASTNode covering, Collection<ChangeCorrectionProposal> resultingCollections) {
        LambdaExpression lambda;
        if (resultingCollections == null) {
            return true;
        }
        if (covering instanceof LambdaExpression) {
            lambda = (LambdaExpression)covering;
        } else if (covering.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)covering.getParent();
        } else {
            return false;
        }
        IProposableFix fix = LambdaExpressionsFixCore.createConvertToAnonymousClassCreationsFix((LambdaExpression)lambda);
        if (fix == null) {
            return false;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_functional_interfaces", "true");
        options.put("cleanup.use_anonymous_class_creation", "true");
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, (ICleanUpCore)new LambdaExpressionsCleanUpCore(options), 2, context, "refactor");
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertVarTypeToResolvedTypeProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        IJavaElement root = astRoot.getJavaElement();
        if (root == null) {
            return false;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        if (!JavaModelUtil.is10OrHigher((IJavaProject)javaProject)) {
            return false;
        }
        SimpleName name = RefactorProcessor.getSimpleNameForVariable(node);
        if (name == null) {
            return false;
        }
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode varDeclaration = astRoot.findDeclaringNode((IBinding)varBinding);
        if (varDeclaration == null) {
            return false;
        }
        ITypeBinding typeBinding = varBinding.getType();
        if (typeBinding == null || typeBinding.isAnonymous() || typeBinding.isIntersectionType() || typeBinding.isWildcardType()) {
            return false;
        }
        Type type = null;
        if (varDeclaration instanceof SingleVariableDeclaration) {
            type = ((SingleVariableDeclaration)varDeclaration).getType();
        } else if (varDeclaration instanceof VariableDeclarationFragment) {
            ASTNode parent = varDeclaration.getParent();
            if (parent instanceof VariableDeclarationStatement) {
                type = ((VariableDeclarationStatement)parent).getType();
            } else if (parent instanceof VariableDeclarationExpression) {
                type = ((VariableDeclarationExpression)parent).getType();
            }
        }
        if (type == null || !type.isVar()) {
            return false;
        }
        TypeChangeCorrectionProposal proposal = new TypeChangeCorrectionProposal(context.getCompilationUnit(), (IBinding)varBinding, astRoot, typeBinding, false, 8);
        proposal.setKind("refactor");
        proposals.add(proposal);
        return true;
    }

    private static SimpleName getSimpleNameForVariable(ASTNode node) {
        if (!(node instanceof SimpleName)) {
            return null;
        }
        SimpleName name = (SimpleName)node;
        if (!name.isDeclaration()) {
            List fragments;
            while (node instanceof Name || node instanceof Type) {
                node = node.getParent();
            }
            if (node instanceof VariableDeclarationStatement && (fragments = ((VariableDeclarationStatement)node).fragments()).size() > 0) {
                name = ((VariableDeclarationFragment)fragments.get(0)).getName();
            }
        }
        return name;
    }

    private static boolean getConvertResolvedTypeToVarTypeProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        IJavaElement root = astRoot.getJavaElement();
        if (root == null) {
            return false;
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        if (!JavaModelUtil.is10OrHigher((IJavaProject)javaProject)) {
            return false;
        }
        SimpleName name = RefactorProcessor.getSimpleNameForVariable(node);
        if (name == null) {
            return false;
        }
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode varDeclaration = astRoot.findDeclaringNode((IBinding)varBinding);
        if (varDeclaration == null) {
            return false;
        }
        Type type = null;
        Expression expression = null;
        ITypeBinding typeBinding = varBinding.getType();
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding expressionTypeBinding = null;
        if (varDeclaration instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration svDecl = (SingleVariableDeclaration)varDeclaration;
            type = svDecl.getType();
            expression = svDecl.getInitializer();
            if (expression != null) {
                expressionTypeBinding = expression.resolveTypeBinding();
            } else {
                ITypeBinding expBinding;
                EnhancedForStatement efStmt;
                ASTNode parent = svDecl.getParent();
                if (parent instanceof EnhancedForStatement && (expression = (efStmt = (EnhancedForStatement)parent).getExpression()) != null && (expBinding = expression.resolveTypeBinding()) != null) {
                    if (expBinding.isArray()) {
                        expressionTypeBinding = expBinding.getElementType();
                    } else {
                        ITypeBinding[] typeArguments;
                        ITypeBinding iterable = Bindings.findTypeInHierarchy((ITypeBinding)expBinding, (String)"java.lang.Iterable");
                        if (iterable != null && (typeArguments = iterable.getTypeArguments()).length == 1) {
                            expressionTypeBinding = typeArguments[0];
                            expressionTypeBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)expressionTypeBinding, (AST)context.getASTRoot().getAST());
                        }
                    }
                }
            }
        } else if (varDeclaration instanceof VariableDeclarationFragment) {
            ASTNode parent = varDeclaration.getParent();
            expression = ((VariableDeclarationFragment)varDeclaration).getInitializer();
            if (expression != null) {
                expressionTypeBinding = expression.resolveTypeBinding();
            }
            if (parent instanceof VariableDeclarationStatement) {
                type = ((VariableDeclarationStatement)parent).getType();
            } else if (parent instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression varDecl = (VariableDeclarationExpression)parent;
                if (varDecl.fragments().size() > 1) {
                    return false;
                }
                type = varDecl.getType();
            }
        }
        if (type == null || type.isVar()) {
            return false;
        }
        if (expression == null || expression instanceof ArrayInitializer || expression instanceof LambdaExpression || expression instanceof MethodReference) {
            return false;
        }
        if (expressionTypeBinding == null || !expressionTypeBinding.isEqualTo((IBinding)typeBinding)) {
            return false;
        }
        TypeChangeCorrectionProposal proposal = new TypeChangeCorrectionProposal(context.getCompilationUnit(), (IBinding)varBinding, astRoot, typeBinding, 8);
        proposal.setKind("refactor");
        proposals.add(proposal);
        return true;
    }

    private static boolean getAddStaticImportProposals(IInvocationContext context, final ASTNode node, Collection<ChangeCorrectionProposal> proposals) {
        QualifiedName qn;
        MethodInvocation mi;
        int[] referencesFromOtherOccurences;
        int[] allReferencesToDeclaringClass;
        ASTRewrite astRewriteReplaceAllOccurrences;
        ASTRewrite astRewrite;
        ImportRewrite importRewriteReplaceAllOccurences;
        ImportRewrite importRewrite;
        boolean needImport;
        ITypeBinding declaringClass;
        IMethodBinding binding;
        SimpleName name;
        block22: {
            if (!(node instanceof SimpleName)) {
                return false;
            }
            name = (SimpleName)node;
            if (name.getParent() instanceof MethodInvocation) {
                MethodInvocation mi2 = (MethodInvocation)name.getParent();
                Expression expression = mi2.getExpression();
                if (expression == null || expression.equals((Object)name)) {
                    return false;
                }
                binding = mi2.resolveMethodBinding();
                if (binding == null) {
                    return false;
                }
                declaringClass = binding.getDeclaringClass();
            } else if (name.getParent() instanceof QualifiedName) {
                QualifiedName qn2 = (QualifiedName)name.getParent();
                if (name.equals((Object)qn2.getQualifier()) || qn2.getParent() instanceof ImportDeclaration) {
                    return false;
                }
                binding = qn2.resolveBinding();
                if (!(binding instanceof IVariableBinding)) {
                    return false;
                }
                declaringClass = ((IVariableBinding)binding).getDeclaringClass();
            } else {
                return false;
            }
            if (!Modifier.isStatic((int)binding.getModifiers())) {
                return false;
            }
            needImport = false;
            if (!RefactorProcessor.isDirectlyAccessible((ASTNode)name, declaringClass)) {
                if (Modifier.isPrivate((int)declaringClass.getModifiers())) {
                    return false;
                }
                needImport = true;
            }
            if (proposals == null) {
                return true;
            }
            importRewrite = StubUtility.createImportRewrite((ICompilationUnit)context.getCompilationUnit(), (boolean)true);
            importRewriteReplaceAllOccurences = StubUtility.createImportRewrite((ICompilationUnit)context.getCompilationUnit(), (boolean)true);
            astRewrite = ASTRewrite.create((AST)node.getAST());
            astRewriteReplaceAllOccurrences = ASTRewrite.create((AST)node.getAST());
            allReferencesToDeclaringClass = new int[]{0};
            referencesFromOtherOccurences = new int[]{0};
            mi = null;
            qn = null;
            if (name.getParent() instanceof MethodInvocation) {
                mi = (MethodInvocation)name.getParent();
                astRewrite.remove((ASTNode)mi.getExpression(), null);
                mi.typeArguments().forEach(type -> astRewrite.remove((ASTNode)((Type)type), null));
                break block22;
            }
            if (name.getParent() instanceof QualifiedName) {
                qn = (QualifiedName)name.getParent();
                astRewrite.replace((ASTNode)qn, (ASTNode)ASTNodeFactory.newName((AST)node.getAST(), (String)name.getFullyQualifiedName()), null);
                break block22;
            }
            return false;
        }
        try {
            final MethodInvocation miFinal = mi;
            name.getRoot().accept(new ASTVisitor(){

                public boolean visit(MethodInvocation methodInvocation) {
                    String typeName;
                    ClassInstanceCreation classInstanceCreation;
                    Expression methodInvocationExpression = methodInvocation.getExpression();
                    if (methodInvocationExpression == null) {
                        return super.visit(methodInvocation);
                    }
                    if (methodInvocationExpression instanceof Name) {
                        String fullyQualifiedName = ((Name)methodInvocationExpression).getFullyQualifiedName();
                        if (miFinal != null && miFinal.getExpression() instanceof Name && ((Name)miFinal.getExpression()).getFullyQualifiedName().equals(fullyQualifiedName) && miFinal.getName().getIdentifier().equals(methodInvocation.getName().getIdentifier())) {
                            methodInvocation.typeArguments().forEach(type -> astRewriteReplaceAllOccurrences.remove((ASTNode)((Type)type), null));
                            astRewriteReplaceAllOccurrences.remove((ASTNode)methodInvocationExpression, null);
                            allReferencesToDeclaringClass[0] = allReferencesToDeclaringClass[0] + 1;
                        } else if (declaringClass.getName().equals(fullyQualifiedName)) {
                            allReferencesToDeclaringClass[0] = allReferencesToDeclaringClass[0] + 1;
                            referencesFromOtherOccurences[0] = referencesFromOtherOccurences[0] + 1;
                        }
                    } else if (methodInvocationExpression instanceof ClassInstanceCreation && (classInstanceCreation = (ClassInstanceCreation)methodInvocationExpression).getType() instanceof SimpleType && (typeName = ((SimpleType)classInstanceCreation.getType()).getName().getFullyQualifiedName()).equals(declaringClass.getName())) {
                        allReferencesToDeclaringClass[0] = allReferencesToDeclaringClass[0] + 1;
                        referencesFromOtherOccurences[0] = referencesFromOtherOccurences[0] + 1;
                    }
                    return super.visit(methodInvocation);
                }
            });
            final QualifiedName qnFinal = qn;
            name.getRoot().accept(new ASTVisitor(){

                public boolean visit(QualifiedName qualifiedName) {
                    if (qnFinal != null && qualifiedName.getFullyQualifiedName().equals(qnFinal.getFullyQualifiedName())) {
                        astRewriteReplaceAllOccurrences.replace((ASTNode)qualifiedName, (ASTNode)ASTNodeFactory.newName((AST)node.getAST(), (String)name.getFullyQualifiedName()), null);
                        allReferencesToDeclaringClass[0] = allReferencesToDeclaringClass[0] + 1;
                    } else if (declaringClass.getName().equals(qualifiedName.getQualifier().getFullyQualifiedName())) {
                        allReferencesToDeclaringClass[0] = allReferencesToDeclaringClass[0] + 1;
                        referencesFromOtherOccurences[0] = referencesFromOtherOccurences[0] + 1;
                    }
                    return super.visit(qualifiedName);
                }
            });
            if (needImport) {
                importRewrite.addStaticImport((IBinding)binding);
                if (allReferencesToDeclaringClass[0] == 1) {
                    importRewrite.removeImport(declaringClass.getQualifiedName());
                }
                importRewriteReplaceAllOccurences.addStaticImport((IBinding)binding);
                if (referencesFromOtherOccurences[0] == 0) {
                    importRewriteReplaceAllOccurences.removeImport(declaringClass.getQualifiedName());
                }
            }
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(CorrectionMessages.QuickAssistProcessor_convert_to_static_import, "refactor", context.getCompilationUnit(), astRewrite, 5);
            proposal.setImportRewrite(importRewrite);
            proposals.add(proposal);
            ASTRewriteCorrectionProposal proposalReplaceAllOccurrences = new ASTRewriteCorrectionProposal(CorrectionMessages.QuickAssistProcessor_convert_to_static_import_replace_all, "refactor", context.getCompilationUnit(), astRewriteReplaceAllOccurrences, 5);
            proposalReplaceAllOccurrences.setImportRewrite(importRewriteReplaceAllOccurences);
            proposals.add(proposalReplaceAllOccurrences);
        }
        catch (IllegalArgumentException e) {
            JavaLanguageServerPlugin.logException("Failed to get static import proposal", e);
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
        return true;
    }

    private static boolean isDirectlyAccessible(ASTNode nameNode, ITypeBinding declaringClass) {
        ASTNode node = nameNode.getParent();
        while (node != null) {
            ITypeBinding binding;
            if (node instanceof AbstractTypeDeclaration ? (binding = ((AbstractTypeDeclaration)node).resolveBinding()) != null && binding.isSubTypeCompatible(declaringClass) : node instanceof AnonymousClassDeclaration && (binding = ((AnonymousClassDeclaration)node).resolveBinding()) != null && binding.isSubTypeCompatible(declaringClass)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static boolean getConvertForLoopProposal(IInvocationContext context, ASTNode node, Collection<ChangeCorrectionProposal> resultingCollections) {
        ForStatement forStatement = RefactorProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ConvertLoopFixCore fix = ConvertLoopFixCore.createConvertForLoopToEnhancedFix((CompilationUnit)context.getASTRoot(), (ForStatement)forStatement);
        if (fix == null) {
            return false;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_to_enhanced_for_loop", "true");
        AbstractCleanUpCore cleanUp = new AbstractCleanUpCore(options){

            public CleanUpRequirementsCore getRequirementsCore() {
                return new CleanUpRequirementsCore(this.isEnabled("cleanup.convert_to_enhanced_for_loop"), false, false, null);
            }

            public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
                CompilationUnit compilationUnit = context.getAST();
                if (compilationUnit == null) {
                    return null;
                }
                boolean convertForLoops = this.isEnabled("cleanup.convert_to_enhanced_for_loop");
                boolean checkIfLoopVarUsed = this.isEnabled(CleanUpConstants.CONTROL_STATMENTS_CONVERT_FOR_LOOP_ONLY_IF_LOOP_VAR_USED);
                return ConvertLoopFixCore.createCleanUp((CompilationUnit)compilationUnit, (boolean)convertForLoops, (boolean)convertForLoops, (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final") ? 1 : 0) != 0, (boolean)checkIfLoopVarUsed);
            }

            public String[] getStepDescriptions() {
                ArrayList<String> result = new ArrayList<String>();
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
                    result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
                    if (this.isEnabled(CleanUpConstants.CONTROL_STATMENTS_CONVERT_FOR_LOOP_ONLY_IF_LOOP_VAR_USED)) {
                        result.add(MultiFixMessages.Java50CleanUp_ConvertLoopOnlyIfLoopVarUsed_description);
                    }
                }
                return result.toArray(new String[result.size()]);
            }

            public String getPreview() {
                StringBuilder buf = new StringBuilder();
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
                    buf.append("for (int element : ids) {\n");
                    buf.append("    double value= element / 2; \n");
                    buf.append("    System.out.println(value);\n");
                    buf.append("}\n");
                } else {
                    buf.append("for (int i = 0; i < ids.length; i++) {\n");
                    buf.append("    double value= ids[i] / 2; \n");
                    buf.append("    System.out.println(value);\n");
                    buf.append("}\n");
                }
                if (this.isEnabled("cleanup.convert_to_enhanced_for_loop") && !this.isEnabled(CleanUpConstants.CONTROL_STATMENTS_CONVERT_FOR_LOOP_ONLY_IF_LOOP_VAR_USED)) {
                    buf.append("for (int id : ids) {\n");
                    buf.append("    System.out.println(\"here\");\n");
                    buf.append("}\n");
                } else {
                    buf.append("for (int i = 0; i < ids.length; i++) {\n");
                    buf.append("    System.out.println(\"here\");\n");
                    buf.append("}\n");
                }
                return buf.toString();
            }
        };
        FixCorrectionProposal proposal = new FixCorrectionProposal((IProposableFix)fix, (ICleanUpCore)cleanUp, 1, context, "refactor");
        resultingCollections.add(proposal);
        return true;
    }

    private static ForStatement getEnclosingForStatementHeader(ASTNode node) {
        return RefactorProcessor.getEnclosingHeader(node, ForStatement.class, new StructuralPropertyDescriptor[]{ForStatement.INITIALIZERS_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ForStatement.UPDATERS_PROPERTY});
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends ASTNode> T getEnclosingHeader(ASTNode node, Class<T> headerType, StructuralPropertyDescriptor ... headerProperties) {
        if (!headerType.isInstance(node)) ** GOTO lbl17
        return (T)((ASTNode)headerType.cast(node));
lbl-1000:
        // 1 sources

        {
            parent = node.getParent();
            if (headerType.isInstance(parent)) {
                locationInParent = node.getLocationInParent();
                var8_5 = headerProperties;
                var7_6 = headerProperties.length;
                var6_7 = 0;
                while (var6_7 < var7_6) {
                    property = var8_5[var6_7];
                    if (locationInParent == property) {
                        return (T)((ASTNode)headerType.cast(parent));
                    }
                    ++var6_7;
                }
                return null;
            }
            node = parent;
lbl17:
            // 2 sources

            ** while (node != null)
        }
lbl18:
        // 1 sources

        return null;
    }
}

