/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public abstract class RefactoringModifications {
    private ResourceModifications fResourceModifications = new ResourceModifications();

    public ResourceModifications getResourceModifications() {
        return this.fResourceModifications;
    }

    public abstract RefactoringParticipant[] loadParticipants(RefactoringStatus var1, RefactoringProcessor var2, String[] var3, SharableParticipants var4);

    public abstract void buildDelta(IResourceChangeDescriptionFactory var1);

    public void buildValidateEdits(ValidateEditChecker checker) {
    }

    protected void createIncludingParents(IContainer container) {
        while (container != null && !container.exists() && !this.getResourceModifications().willExist((IResource)container)) {
            this.getResourceModifications().addCreate((IResource)container);
            container = container.getParent();
        }
    }

    protected IResource[] collectResourcesOfInterest(IPackageFragment source) throws CoreException {
        IJavaElement[] children = source.getChildren();
        int childOfInterest = 5;
        if (source.getKind() == 2) {
            childOfInterest = 6;
        }
        ArrayList<IResource> result = new ArrayList<IResource>(children.length);
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            if (child.getElementType() == childOfInterest && child.getResource() != null) {
                result.add(child.getResource());
            }
            ++i;
        }
        Object[] nonJavaResources = source.getNonJavaResources();
        int i2 = 0;
        while (i2 < nonJavaResources.length) {
            Object element = nonJavaResources[i2];
            if (element instanceof IResource) {
                result.add((IResource)element);
            }
            ++i2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected IFile getClasspathFile(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        IResource result = project.findMember(".classpath");
        if (result instanceof IFile) {
            return (IFile)result;
        }
        return null;
    }
}

