/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    ExceptionAnalyzer() {
    }

    public static ITypeBinding[] perform(ASTNode[] statements) {
        ExceptionAnalyzer analyzer = new ExceptionAnalyzer();
        int i = 0;
        while (i < statements.length) {
            statements[i].accept((ASTVisitor)analyzer);
            ++i;
        }
        List<ITypeBinding> exceptions = analyzer.getCurrentExceptions();
        return exceptions.toArray(new ITypeBinding[exceptions.size()]);
    }

    @Override
    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (exception == null) {
            return true;
        }
        this.addException(exception, node.getAST());
        return true;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        return this.handleExceptions((IMethodBinding)node.getName().resolveBinding(), (ASTNode)node);
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.handleExceptions((IMethodBinding)node.getName().resolveBinding(), (ASTNode)node);
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        return this.handleExceptions(node.resolveConstructorBinding(), (ASTNode)node);
    }

    private boolean handleExceptions(IMethodBinding binding, ASTNode node) {
        if (binding == null) {
            return true;
        }
        this.addExceptions(binding.getExceptionTypes(), node.getAST());
        return true;
    }
}

