/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.model.TestItem;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.searcher.JUnit4TestSearcher;
import com.microsoft.java.test.plugin.searcher.JUnit5TestSearcher;
import com.microsoft.java.test.plugin.searcher.TestFrameworkSearcher;
import com.microsoft.java.test.plugin.searcher.TestNGTestSearcher;
import com.microsoft.java.test.plugin.util.TestItemUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.junit.launcher.JUnit4TestFinder;
import org.eclipse.jdt.internal.junit.launcher.JUnit5TestFinder;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class TestFrameworkUtils {
    public static final TestFrameworkSearcher[] FRAMEWORK_SEARCHERS = new TestFrameworkSearcher[]{new JUnit4TestSearcher(), new JUnit5TestSearcher(), new TestNGTestSearcher()};
    private static final JUnit4TestFinder JUNIT4_TEST_FINDER = new JUnit4TestFinder();
    private static final JUnit5TestFinder JUNIT5_TEST_FINDER = new JUnit5TestFinder();

    public static void findTestItemsInTypeBinding(ITypeBinding typeBinding, List<TestItem> result, TestItem parentClassTestItem, IProgressMonitor monitor) throws JavaModelException {
        if (monitor.isCanceled()) {
            return;
        }
        ArrayList<TestFrameworkSearcher> searchers = new ArrayList<TestFrameworkSearcher>();
        IType type = (IType)typeBinding.getJavaElement();
        TestFrameworkSearcher[] testFrameworkSearcherArray = FRAMEWORK_SEARCHERS;
        int n = FRAMEWORK_SEARCHERS.length;
        int n2 = 0;
        while (n2 < n) {
            TestFrameworkSearcher searcher = testFrameworkSearcherArray[n2];
            if (CoreTestSearchEngine.isAccessibleClass((IType)type, (String)searcher.getJdtTestKind())) {
                searchers.add(searcher);
            }
            ++n2;
        }
        if (searchers.size() == 0) {
            return;
        }
        LinkedList<TestItem> testMethods = new LinkedList<TestItem>();
        LinkedList<String> testMethodIds = new LinkedList<String>();
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n3 = iMethodBindingArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IMethodBinding methodBinding = iMethodBindingArray[n4];
            for (TestFrameworkSearcher searcher : searchers) {
                if (!searcher.isTestMethod(methodBinding)) continue;
                TestItem methodItem = searcher.parseTestItem(methodBinding);
                testMethods.add(methodItem);
                testMethodIds.add(methodItem.getId());
                break;
            }
            ++n4;
        }
        TestItem classItem = null;
        if (testMethods.size() > 0) {
            result.addAll(testMethods);
            classItem = TestItemUtils.constructTestItem((IJavaElement)((IType)typeBinding.getJavaElement()), TestLevel.CLASS);
            classItem.setChildren(testMethodIds);
            classItem.setKind(((TestItem)testMethods.get(0)).getKind());
            result.add(classItem);
        } else if (JUNIT4_TEST_FINDER.isTest(type)) {
            classItem = TestItemUtils.constructTestItem((IJavaElement)type, TestLevel.CLASS, TestKind.JUnit);
            result.add(classItem);
        } else if (JUNIT5_TEST_FINDER.isTest(type)) {
            classItem = TestItemUtils.constructTestItem((IJavaElement)type, TestLevel.CLASS, TestKind.JUnit5);
            result.add(classItem);
        }
        if (classItem != null && parentClassTestItem != null) {
            parentClassTestItem.addChild(classItem.getId());
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getDeclaredTypes();
        int n5 = iTypeBindingArray.length;
        n3 = 0;
        while (n3 < n5) {
            ITypeBinding childTypeBinding = iTypeBindingArray[n3];
            TestFrameworkUtils.findTestItemsInTypeBinding(childTypeBinding, result, classItem, monitor);
            ++n3;
        }
    }

    public static boolean isEquivalentAnnotationType(ITypeBinding annotationType, String annotationName) {
        return annotationType != null && Objects.equals(annotationType.getQualifiedName(), annotationName);
    }

    public static TestItem resolveTestItemForMethod(IMethod method) throws JavaModelException {
        TestFrameworkSearcher[] testFrameworkSearcherArray = FRAMEWORK_SEARCHERS;
        int n = FRAMEWORK_SEARCHERS.length;
        int n2 = 0;
        while (n2 < n) {
            TestFrameworkSearcher searcher = testFrameworkSearcherArray[n2];
            if (searcher.isTestMethod(method)) {
                return searcher.parseTestItem(method);
            }
            ++n2;
        }
        return null;
    }

    public static TestItem resolveTestItemForClass(IType type) throws JavaModelException {
        TestFrameworkSearcher[] testFrameworkSearcherArray = FRAMEWORK_SEARCHERS;
        int n = FRAMEWORK_SEARCHERS.length;
        int n2 = 0;
        while (n2 < n) {
            TestFrameworkSearcher searcher = testFrameworkSearcherArray[n2];
            if (searcher.isTestClass(type)) {
                return searcher.parseTestItem(type);
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public static Optional<IAnnotation> getAnnotation(IMember member, String annotationToSearch, boolean checkHierarchy) {
        if (!IAnnotatable.class.isInstance(member)) {
            return Optional.empty();
        }
        IJavaProject javaProject = member.getJavaProject();
        if (javaProject == null) {
            return Optional.empty();
        }
        IType declaringType = null;
        if (IMethod.class.isInstance(member)) {
            declaringType = member.getDeclaringType();
        } else if (IType.class.isInstance(member)) {
            declaringType = (IType)member;
        }
        if (declaringType == null) {
            return Optional.empty();
        }
        IAnnotatable annotatable = (IAnnotatable)member;
        try {
            IAnnotation[] iAnnotationArray = annotatable.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                HashSet<IType> hierarchy;
                IAnnotation annotation = iAnnotationArray[n2];
                IType annotationType = TestFrameworkUtils.getResolvedType(annotation.getElementName(), declaringType, javaProject);
                if (annotationType != null && annotationToSearch.equals(annotationType.getFullyQualifiedName())) {
                    return Optional.of(annotation);
                }
                if (checkHierarchy && TestFrameworkUtils.matchesInAnnotationHierarchy(annotationToSearch, annotationType, javaProject, hierarchy = new HashSet<IType>())) {
                    return Optional.of(annotation);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Deprecated
    public static boolean hasAnnotation(IMember member, String annotationToSearch, boolean checkHierarchy) {
        return TestFrameworkUtils.getAnnotation(member, annotationToSearch, checkHierarchy).isPresent();
    }

    private static IType getResolvedType(String typeName, IType type, IJavaProject javaProject) throws JavaModelException {
        IType resolvedType = null;
        if (typeName != null) {
            String[][] resolvedTypeNames;
            int pos = typeName.indexOf(60);
            if (pos != -1) {
                typeName = typeName.substring(0, pos);
            }
            if ((resolvedTypeNames = type.resolveType(typeName)) != null && resolvedTypeNames.length > 0) {
                String[] resolvedTypeName = resolvedTypeNames[0];
                resolvedType = javaProject.findType(resolvedTypeName[0], resolvedTypeName[1]);
            }
        }
        return resolvedType;
    }

    private static boolean matchesInAnnotationHierarchy(String annotationFullName, IType annotationType, IJavaProject javaProject, Set<IType> hierarchy) throws JavaModelException {
        if (annotationType != null) {
            IAnnotation[] iAnnotationArray = annotationType.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                IType annType = TestFrameworkUtils.getResolvedType(annotation.getElementName(), annotationType, javaProject);
                if (annType != null && hierarchy.add(annType) && (annotationFullName.equals(annotationType.getFullyQualifiedName()) || TestFrameworkUtils.matchesInAnnotationHierarchy(annotationFullName, annType, javaProject, hierarchy))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

