/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;

public class CorrectMainTypeNameProposal
extends ASTRewriteCorrectionProposal {
    private final String fOldName;
    private final String fNewName;
    private final IInvocationContext fContext;

    public CorrectMainTypeNameProposal(ICompilationUnit cu, IInvocationContext context, String oldTypeName, String newTypeName, int relevance) {
        super("", "quickfix", cu, (ASTRewrite)null, relevance);
        this.fContext = context;
        this.setDisplayName(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renametype_description, BasicElementLabels.getJavaElementName((String)newTypeName)));
        this.fOldName = oldTypeName;
        this.fNewName = newTypeName;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = this.fContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        AbstractTypeDeclaration decl = this.findTypeDeclaration(astRoot.types(), this.fOldName);
        if (decl != null) {
            SimpleName[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)astRoot, (SimpleName)decl.getName());
            int i = 0;
            while (i < sameNodes.length) {
                rewrite.replace((ASTNode)sameNodes[i], (ASTNode)ast.newSimpleName(this.fNewName), null);
                ++i;
            }
        }
        return rewrite;
    }

    private AbstractTypeDeclaration findTypeDeclaration(List<AbstractTypeDeclaration> types, String name) {
        for (AbstractTypeDeclaration decl : types) {
            if (!name.equals(decl.getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }
}

