/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.runner.testng;

import com.microsoft.java.test.runner.common.TestRunnerMessageHelper;
import java.util.Collection;
import java.util.Iterator;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;

public class TestNGListener
implements ISuiteListener,
ITestListener,
ITestNGListener {
    public void onTestStart(ITestResult result) {
        TestRunnerMessageHelper.testStarted(result.getTestClass().getName() + "#" + result.getName());
    }

    public void onTestSuccess(ITestResult result) {
        long duration = result.getEndMillis() - result.getStartMillis();
        TestRunnerMessageHelper.testFinished(result.getTestClass().getName() + "#" + result.getName(), duration);
    }

    public void onTestFailure(ITestResult result) {
        long duration = result.getEndMillis() - result.getStartMillis();
        TestRunnerMessageHelper.testFailed(result.getTestClass().getName() + "#" + result.getName(), result.getThrowable(), duration);
    }

    public void onTestSkipped(ITestResult result) {
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            this.onTestFailure(result);
            return;
        }
        TestRunnerMessageHelper.testIgnored(result.getTestClass().getName() + "#" + result.getName());
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
        ITestContext context = ((ISuiteResult)TestNGListener.getFirst(suite.getResults().values())).getTestContext();
        TestRunnerMessageHelper.testRunFinished(context.getAllTestMethods().length, context.getFailedTests().size(), context.getSkippedTests().size());
    }

    private static <T> T getFirst(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T entry = iterator.next();
            return entry;
        }
        return null;
    }
}

