"use strict";
// *****************************************************************************
// Copyright (C) 2019 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceScope = void 0;
var PreferenceScope;
(function (PreferenceScope) {
    PreferenceScope[PreferenceScope["Default"] = 0] = "Default";
    PreferenceScope[PreferenceScope["User"] = 1] = "User";
    PreferenceScope[PreferenceScope["Workspace"] = 2] = "Workspace";
    PreferenceScope[PreferenceScope["Folder"] = 3] = "Folder";
})(PreferenceScope = exports.PreferenceScope || (exports.PreferenceScope = {}));
(function (PreferenceScope) {
    function is(scope) {
        return typeof scope === 'number' && getScopes().includes(scope);
    }
    PreferenceScope.is = is;
    /**
     * @returns preference scopes from broadest to narrowest: Default -> Folder.
     */
    function getScopes() {
        return Object.values(PreferenceScope).filter(nameOrIndex => !isNaN(Number(nameOrIndex)));
    }
    PreferenceScope.getScopes = getScopes;
    /**
     * @returns preference scopes from narrowest to broadest. Folder -> Default.
     */
    function getReversedScopes() {
        return getScopes().reverse();
    }
    PreferenceScope.getReversedScopes = getReversedScopes;
    function getScopeNames(scope) {
        const names = [];
        const scopes = getScopes();
        if (scope) {
            for (const scopeIndex of scopes) {
                if (scopeIndex <= scope) {
                    names.push(PreferenceScope[scopeIndex]);
                }
            }
        }
        return names;
    }
    PreferenceScope.getScopeNames = getScopeNames;
    function fromString(strScope) {
        switch (strScope) {
            case 'application':
                return PreferenceScope.User;
            case 'window':
                return PreferenceScope.Folder;
            case 'resource':
                return PreferenceScope.Folder;
            case 'language-overridable':
                return PreferenceScope.Folder;
        }
    }
    PreferenceScope.fromString = fromString;
})(PreferenceScope = exports.PreferenceScope || (exports.PreferenceScope = {}));
//# sourceMappingURL=preference-scope.js.map