/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainText {
    public String getPlainText(Element element) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor traversor = new NodeTraversor((NodeVisitor)formatter);
        traversor.traverse((Node)element);
        return formatter.toString();
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private StringBuilder accum = new StringBuilder();
        private int listNesting;

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("ul")) {
                ++this.listNesting;
            } else if (name.equals("li")) {
                this.append("\n ");
                int i = 1;
                while (i < this.listNesting) {
                    this.append("  ");
                    ++i;
                }
                if (this.listNesting == 1) {
                    this.append("* ");
                } else {
                    this.append("- ");
                }
            } else if (name.equals("dt")) {
                this.append("  ");
            } else if (StringUtil.in((String)name, (String[])new String[]{"p", "h1", "h2", "h3", "h4", "h5", "tr"})) {
                this.append("\n");
            }
        }

        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (StringUtil.in((String)name, (String[])new String[]{"br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5"})) {
                this.append("\n");
            } else if (StringUtil.in((String)name, (String[])new String[]{"th", "td"})) {
                this.append(" ");
            } else if (name.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            } else if (name.equals("ul")) {
                --this.listNesting;
            }
        }

        private void append(String text) {
            if (text.equals(" ") && (this.accum.length() == 0 || StringUtil.in((String)this.accum.substring(this.accum.length() - 1), (String[])new String[]{" ", "\n"}))) {
                return;
            }
            this.accum.append(text);
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

