/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.fix.ICleanUpCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.LinkedCorrectionProposal;
import org.eclipse.ltk.core.refactoring.TextChange;

public class FixCorrectionProposal
extends LinkedCorrectionProposal {
    private final IProposableFix fFix;
    private final ICleanUpCore fCleanUp;
    private CompilationUnit fCompilationUnit;

    public FixCorrectionProposal(IProposableFix fix, ICleanUpCore cleanUp, int relevance, IInvocationContext context) {
        this(fix, cleanUp, relevance, context, "quickfix");
    }

    public FixCorrectionProposal(IProposableFix fix, ICleanUpCore cleanUp, int relevance, IInvocationContext context, String codeActionKind) {
        super(fix.getDisplayString(), codeActionKind, context.getCompilationUnit(), (ASTRewrite)null, relevance);
        this.fFix = fix;
        this.fCleanUp = cleanUp;
        this.fCompilationUnit = context.getASTRoot();
    }

    public IStatus getFixStatus() {
        return this.fFix.getStatus();
    }

    public ICleanUpCore getCleanUp() {
        return this.fCleanUp;
    }

    @Override
    public String getAdditionalProposalInfo(IProgressMonitor monitor) {
        String info;
        StringBuffer result = new StringBuffer();
        IStatus status = this.getFixStatus();
        if (status != null && !status.isOK()) {
            result.append("<b>");
            if (status.getSeverity() == 2) {
                result.append(CorrectionMessages.FixCorrectionProposal_WarningAdditionalProposalInfo);
            } else if (status.getSeverity() == 4) {
                result.append(CorrectionMessages.FixCorrectionProposal_ErrorAdditionalProposalInfo);
            }
            result.append("</b>");
            result.append(status.getMessage());
            result.append("<br><br>");
        }
        if ((info = this.fFix.getAdditionalProposalInfo()) != null) {
            result.append(info);
        } else {
            result.append(super.getAdditionalProposalInfo(monitor));
        }
        return result.toString();
    }

    public int getRelevance() {
        IStatus status = this.getFixStatus();
        if (status != null && !status.isOK()) {
            return super.getRelevance() - 100;
        }
        return super.getRelevance();
    }

    @Override
    protected TextChange createTextChange() throws CoreException {
        CompilationUnitChange createChange = this.fFix.createChange(null);
        createChange.setSaveMode(4);
        return createChange;
    }
}

