/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.highlighting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.HighlightedPositionCore;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.lsp4j.SemanticHighlightingInformation;
import org.eclipse.lsp4j.util.SemanticHighlightingTokens;

public class SemanticHighlightingDiffCalculator {
    public List<SemanticHighlightingInformation> getDiffInfos(SemanticHighlightingService.HighlightedPositionDiffContext context) throws BadLocationException {
        IDocument newState = context.newState;
        IDocument oldState = context.oldState;
        int lineShiftCount = this.getLineShift(oldState, context.event);
        int eventOffset = context.event.getOffset();
        int eventOldLength = context.event.getLength();
        int eventEnd = eventOffset + eventOldLength;
        HashMap infosPerLine = Maps.newHashMap();
        HashMultimap tokensPerLine = HashMultimap.create();
        HashMultimap pendingPositions = HashMultimap.create();
        HashMap newPositions = Maps.newHashMap();
        for (HighlightedPositionCore highlightedPositionCore : context.newPositions) {
            LookupKey key = this.createKey(newState, highlightedPositionCore);
            newPositions.put(key, highlightedPositionCore);
            pendingPositions.put((Object)key.line, (Object)highlightedPositionCore);
        }
        for (HighlightedPositionCore highlightedPositionCore : context.oldPositions) {
            int oldLength;
            int[] oldLineAndColumn = this.getLineAndColumn(oldState, highlightedPositionCore);
            int originalOldLine = oldLineAndColumn[0];
            int oldColumn = oldLineAndColumn[1];
            int oldOffset = highlightedPositionCore.getOffset();
            int oldEnd = oldOffset + (oldLength = highlightedPositionCore.getLength());
            int adjustedOldLine = oldEnd < eventEnd ? originalOldLine : originalOldLine + lineShiftCount;
            int scope = SemanticHighlightingService.getIndex((List)highlightedPositionCore.getHighlighting());
            LookupKey key = this.createKey(adjustedOldLine, oldColumn, this.getTextAt(oldState, (Position)highlightedPositionCore), scope);
            HighlightedPositionCore newPosition = (HighlightedPositionCore)newPositions.remove(key);
            if (newPosition != null || infosPerLine.containsKey(originalOldLine)) continue;
            infosPerLine.put(originalOldLine, new SemanticHighlightingInformation(originalOldLine, null));
        }
        for (Map.Entry entry : newPositions.entrySet()) {
            LookupKey lookupKey = (LookupKey)entry.getKey();
            int line = lookupKey.line;
            int length = lookupKey.text.length();
            int character = lookupKey.column;
            int scope = lookupKey.scope;
            SemanticHighlightingInformation info = (SemanticHighlightingInformation)infosPerLine.get(line);
            if (info == null) {
                info = new SemanticHighlightingInformation(line, null);
                infosPerLine.put(line, info);
            }
            tokensPerLine.put((Object)line, (Object)new SemanticHighlightingTokens.Token(character, length, scope));
            Collection pendings = pendingPositions.removeAll((Object)line);
            if (pendings == null) continue;
            for (HighlightedPositionCore pendingPosition : pendings) {
                if (pendingPosition == entry.getValue()) continue;
                int[] lineAndColumn = this.getLineAndColumn(newState, pendingPosition);
                int pendingCharacter = lineAndColumn[1];
                int pendingLength = pendingPosition.length;
                int pendingScope = SemanticHighlightingService.getIndex((List)pendingPosition.getHighlighting());
                tokensPerLine.put((Object)line, (Object)new SemanticHighlightingTokens.Token(pendingCharacter, pendingLength, pendingScope));
            }
        }
        for (Map.Entry entry : tokensPerLine.asMap().entrySet()) {
            ArrayList tokens = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            Collections.sort(tokens);
            ((SemanticHighlightingInformation)infosPerLine.get(entry.getKey())).setTokens(SemanticHighlightingTokens.encode((Iterable)tokens));
        }
        return FluentIterable.from(infosPerLine.values()).toSortedList(HighlightingInformationComparator.INSTANCE);
    }

    protected int[] getLineAndColumn(IDocument document, HighlightedPositionCore position) {
        int[] lineAndColumn = JsonRpcHelpers.toLine(document, position.offset);
        Assert.isNotNull((Object)lineAndColumn, (String)("Cannot retrieve the line and column information for document. Position was: " + position + " Document was:>" + document.get() + "<."));
        return lineAndColumn;
    }

    protected int getLineShift(IDocument oldState, DocumentEvent event) throws BadLocationException {
        if (event.fLength == 0) {
            Preconditions.checkNotNull((Object)event.fText, (Object)"fText");
            int beforeEndLine = event.fDocument.getLineOfOffset(event.fOffset + event.fLength);
            int afterEndLine = event.fDocument.getLineOfOffset(event.fOffset + event.fText.length());
            return afterEndLine - beforeEndLine;
        }
        if (event.fText == null || event.fText.isEmpty()) {
            return event.fDocument.getLineOfOffset(event.fOffset) - oldState.getLineOfOffset(event.fOffset + event.fLength);
        }
        int startLine = oldState.getLineOfOffset(event.fOffset + event.fLength);
        int lineShift = event.fDocument.getLineOfOffset(event.fOffset + event.fText.length()) - startLine;
        return lineShift;
    }

    protected String getTextAt(IDocument document, Position position) throws BadLocationException {
        return document.get(position.offset, position.length);
    }

    protected LookupKey createKey(IDocument document, HighlightedPositionCore position) throws BadLocationException {
        int[] lineAndColumn = this.getLineAndColumn(document, position);
        int scope = SemanticHighlightingService.getIndex((List)position.getHighlighting());
        return this.createKey(lineAndColumn[0], lineAndColumn[1], this.getTextAt(document, (Position)position), scope);
    }

    protected LookupKey createKey(int line, int column, String text, int scope) {
        return new LookupKey(line, column, text, scope);
    }

    protected static class HighlightingInformationComparator
    implements Comparator<SemanticHighlightingInformation> {
        protected static final Comparator<SemanticHighlightingInformation> INSTANCE = new HighlightingInformationComparator();

        protected HighlightingInformationComparator() {
        }

        @Override
        public int compare(SemanticHighlightingInformation left, SemanticHighlightingInformation right) {
            return ComparisonChain.start().compare(left.getLine(), right.getLine()).result();
        }
    }

    private static final class LookupKey {
        private final int line;
        private final int column;
        private final String text;
        private final int scope;

        private LookupKey(int line, int column, String text, int scope) {
            this.line = line;
            this.column = column;
            this.text = text;
            this.scope = scope;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.column;
            result = 31 * result + this.line;
            result = 31 * result + this.scope;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LookupKey other = (LookupKey)obj;
            if (this.column != other.column) {
                return false;
            }
            if (this.line != other.line) {
                return false;
            }
            if (this.scope != other.scope) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Line: ");
            sb.append(this.line);
            sb.append("\nColumn: ");
            sb.append(this.column);
            sb.append("\nText: ");
            sb.append(this.text);
            sb.append("\nScopes: ");
            sb.append(Iterables.toString(SemanticHighlightingService.getScopes(this.scope)));
            return sb.toString();
        }
    }
}

