"use strict";
// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternalDebugSessionOptions = void 0;
var InternalDebugSessionOptions;
(function (InternalDebugSessionOptions) {
    const SEPARATOR = '__CONF__';
    function is(options) {
        return 'id' in options;
    }
    InternalDebugSessionOptions.is = is;
    function toValue(debugSessionOptions) {
        return debugSessionOptions.configuration.name + SEPARATOR +
            debugSessionOptions.configuration.type + SEPARATOR +
            debugSessionOptions.configuration.request + SEPARATOR +
            debugSessionOptions.workspaceFolderUri + SEPARATOR +
            debugSessionOptions.providerType;
    }
    InternalDebugSessionOptions.toValue = toValue;
    function parseValue(value) {
        const split = value.split(SEPARATOR);
        if (split.length !== 5) {
            throw new Error('Unexpected argument, the argument is expected to have been generated by the \'toValue\' function');
        }
        return { name: split[0], type: split[1], request: split[2], workspaceFolderUri: split[3], providerType: split[4] };
    }
    InternalDebugSessionOptions.parseValue = parseValue;
})(InternalDebugSessionOptions = exports.InternalDebugSessionOptions || (exports.InternalDebugSessionOptions = {}));
//# sourceMappingURL=debug-session-options.js.map