"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderDownloads = exports.renderDocumentation = exports.renderSourceCode = exports.renderTickets = exports.renderSupport = exports.renderWhatIsNot = exports.renderWhatIs = void 0;
const browser_1 = require("@theia/core/lib/browser");
const React = require("react");
function ExternalBrowserLink(props) {
    return React.createElement("a", { role: 'button', tabIndex: 0, onClick: () => openExternalLink(props.url, props.windowService), onKeyDown: (e) => {
            var _a;
            if (browser_1.Key.ENTER.keyCode === ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode)) {
                openExternalLink(props.url, props.windowService);
            }
        } }, props.text);
}
function openExternalLink(url, windowService) {
    windowService.openNewWindow(url, { external: true });
}
function renderWhatIs(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "What is Theia Blueprint?"),
        React.createElement("div", null,
            "Eclipse Theia Blueprint is a ",
            React.createElement("span", { className: 'gs-text-bold' }, "template"),
            " to showcase the capabilities of Eclipse Theia as well as how to build desktop-based products based on the platform. Theia Blueprint assembles a selected subset of existing Theia features and extensions. We provide installers for Theia Blueprint to be downloaded (see below) as well as ",
            React.createElement(ExternalBrowserLink, { text: "documentation", url: "https://theia-ide.org/docs/blueprint_documentation/", windowService: windowService }),
            " on how to customize this template to build a product and installers for your own Theia-based product."));
}
exports.renderWhatIs = renderWhatIs;
function renderWhatIsNot() {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "What is it not?"),
        React.createElement("div", null,
            "Eclipse Theia Blueprint is ",
            React.createElement("span", { className: 'gs-text-bold' },
                React.createElement("span", { className: 'gs-text-underline' }, "not"),
                " a production-ready product"),
            ". Therefore, it is also not a replacement for Visual Studio Code or any other IDE."));
}
exports.renderWhatIsNot = renderWhatIsNot;
function renderSupport(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Professional Support"),
        React.createElement("div", null,
            "Professional support, implementation services, consulting and training for building tools like this instance of Theia Blueprint and for building other tools based on Eclipse Theia is available by selected companies as listed on the",
            React.createElement(ExternalBrowserLink, { text: "Theia support page", url: "https://theia-ide.org/support/", windowService: windowService }),
            "."));
}
exports.renderSupport = renderSupport;
function renderTickets(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Reporting feature requests and bugs"),
        React.createElement("div", null,
            "The features in Eclipse Theia Blueprint are based on Theia and the included extensions/plugins. For bugs in Theia please consider opening an issue in the ",
            React.createElement(ExternalBrowserLink, { text: "Theia project on Github", url: "https://github.com/eclipse-theia/theia/issues/new/choose", windowService: windowService }),
            "."),
        React.createElement("div", null,
            "Eclipse Theia Blueprint only packages existing functionality into a product and installers for the product. If you believe there is a mistake in packaging, something needs to be added to the packaging or the installers do not work properly, please ",
            React.createElement(ExternalBrowserLink, { text: "open an issue on Github", url: "https://github.com/eclipse-theia/theia-blueprint/issues/new/choose", windowService: windowService }),
            " to let us know."));
}
exports.renderTickets = renderTickets;
function renderSourceCode(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Source Code"),
        React.createElement("div", null,
            "The source code of Eclipse Theia Blueprint is available on ",
            React.createElement(ExternalBrowserLink, { text: "Github", url: "https://github.com/eclipse-theia/theia-blueprint", windowService: windowService }),
            "."));
}
exports.renderSourceCode = renderSourceCode;
function renderDocumentation(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Documentation"),
        React.createElement("div", null,
            "Please see ",
            React.createElement(ExternalBrowserLink, { text: "here", url: "https://theia-ide.org/docs/blueprint_documentation/", windowService: windowService }),
            " for documentation how to customize Eclipse Theia Blueprint."));
}
exports.renderDocumentation = renderDocumentation;
function renderDownloads() {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Updates and Downloads"),
        React.createElement("div", { className: 'gs-action-container' },
            "You can update Eclipse Theia Blueprint directly in this application by navigating to File ",
            '>',
            " Settings ",
            '>',
            " Check for Updates\u2026 Moreover the application will check for Updates after each launch automatically."),
        React.createElement("div", { className: 'gs-action-container' }, "Alternatively you can download the most recent version from the download page."));
}
exports.renderDownloads = renderDownloads;
//# sourceMappingURL=branding-util.js.map