"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
require("./browser/coreCommands");
require("./browser/widget/codeEditorWidget");
require("./browser/widget/diffEditorWidget");
require("./browser/widget/diffNavigator");
require("./contrib/anchorSelect/browser/anchorSelect");
require("./contrib/bracketMatching/browser/bracketMatching");
require("./contrib/caretOperations/browser/caretOperations");
require("./contrib/caretOperations/browser/transpose");
require("./contrib/clipboard/browser/clipboard");
require("./contrib/codeAction/browser/codeActionContributions");
require("./contrib/codelens/browser/codelensController");
require("./contrib/colorPicker/browser/colorContributions");
require("./contrib/comment/browser/comment");
require("./contrib/contextmenu/browser/contextmenu");
require("./contrib/cursorUndo/browser/cursorUndo");
require("./contrib/dnd/browser/dnd");
require("./contrib/find/browser/findController");
require("./contrib/folding/browser/folding");
require("./contrib/fontZoom/browser/fontZoom");
require("./contrib/format/browser/formatActions");
require("./contrib/documentSymbols/browser/documentSymbols");
require("./contrib/inlineCompletions/browser/inlineCompletionsContribution");
require("./contrib/gotoSymbol/browser/goToCommands");
require("./contrib/gotoSymbol/browser/link/goToDefinitionAtPosition");
require("./contrib/gotoError/browser/gotoError");
require("./contrib/hover/browser/hover");
require("./contrib/indentation/browser/indentation");
require("./contrib/inlayHints/browser/inlayHintsContribution");
require("./contrib/inPlaceReplace/browser/inPlaceReplace");
require("./contrib/lineSelection/browser/lineSelection");
require("./contrib/linesOperations/browser/linesOperations");
require("./contrib/linkedEditing/browser/linkedEditing");
require("./contrib/links/browser/links");
require("./contrib/multicursor/browser/multicursor");
require("./contrib/parameterHints/browser/parameterHints");
require("./contrib/rename/browser/rename");
require("./contrib/smartSelect/browser/smartSelect");
require("./contrib/snippet/browser/snippetController2");
require("./contrib/suggest/browser/suggestController");
require("./contrib/tokenization/browser/tokenization");
require("./contrib/toggleTabFocusMode/browser/toggleTabFocusMode");
require("./contrib/unicodeHighlighter/browser/unicodeHighlighter");
require("./contrib/unusualLineTerminators/browser/unusualLineTerminators");
require("./contrib/viewportSemanticTokens/browser/viewportSemanticTokens");
require("./contrib/wordHighlighter/browser/wordHighlighter");
require("./contrib/wordOperations/browser/wordOperations");
require("./contrib/wordPartOperations/browser/wordPartOperations");
// Load up these strings even in VSCode, even if they are not used
// in order to get them translated
require("./common/standaloneStrings");
require("../base/browser/ui/codicons/codiconStyles"); // The codicons are defined here and must be loaded
//# sourceMappingURL=editor.all.js.map