/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.model.TestItem;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Range;

public class TestItemUtils {
    public static final String DEFAULT_PACKAGE_NAME = "<Default Package>";

    public static TestItem constructTestItem(IJavaElement element, TestLevel level) throws JavaModelException {
        return TestItemUtils.constructTestItem(element, level, null);
    }

    public static TestItem constructTestItem(IJavaElement element, TestLevel level, TestKind kind) throws JavaModelException {
        String fullName;
        String displayName;
        if (element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage()) {
            displayName = DEFAULT_PACKAGE_NAME;
            fullName = DEFAULT_PACKAGE_NAME;
        } else {
            displayName = element.getElementName();
            fullName = TestItemUtils.parseTestItemFullName(element, level);
        }
        String uri = JDTUtils.getFileURI((IResource)element.getResource());
        Range range = TestItemUtils.parseTestItemRange(element);
        String projectName = element.getJavaProject().getProject().getName();
        return new TestItem(displayName, fullName, uri, projectName, range, level, kind);
    }

    public static Range parseTestItemRange(IJavaElement element) throws JavaModelException {
        if (element instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)element).getNameRange();
            return JDTUtils.toRange((IOpenable)element.getOpenable(), (int)range.getOffset(), (int)range.getLength());
        }
        return new Range();
    }

    private static String parseTestItemFullName(IJavaElement element, TestLevel level) {
        switch (level) {
            case CLASS: {
                IType type = (IType)element;
                return type.getFullyQualifiedName();
            }
            case METHOD: {
                IMethod method = (IMethod)element;
                return String.valueOf(method.getDeclaringType().getFullyQualifiedName()) + "#" + method.getElementName();
            }
        }
        return element.getElementName();
    }
}

