/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyCore;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentSymbolHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyOutgoingCall;
import org.eclipse.lsp4j.CallHierarchyOutgoingCallsParams;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolTag;

public class CallHierarchyHandler {
    private static Map<IJavaElement, MethodWrapper> incomingMethodWrapperCache = new ConcurrentHashMap<IJavaElement, MethodWrapper>();
    private static Map<IJavaElement, MethodWrapper> outgoingMethodWrapperCache = new ConcurrentHashMap<IJavaElement, MethodWrapper>();

    public List<CallHierarchyItem> prepareCallHierarchy(CallHierarchyPrepareParams params, IProgressMonitor monitor) {
        IMember candidate2;
        block4: {
            Assert.isNotNull((Object)params, (String)"params");
            incomingMethodWrapperCache.clear();
            outgoingMethodWrapperCache.clear();
            String uri = params.getTextDocument().getUri();
            int line = params.getPosition().getLine();
            int character = params.getPosition().getCharacter();
            candidate2 = this.getCallHierarchyElement(uri, line, character, monitor);
            if (candidate2 != null) break block4;
            return null;
        }
        try {
            this.checkMonitor(monitor);
            return Arrays.asList(this.toCallHierarchyItem(candidate2));
        }
        catch (OperationCanceledException candidate2) {
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
        }
        return null;
    }

    public List<CallHierarchyIncomingCall> callHierarchyIncomingCalls(CallHierarchyIncomingCallsParams params, IProgressMonitor monitor) {
        Assert.isNotNull((Object)params, (String)"params");
        CallHierarchyItem item = params.getItem();
        Assert.isNotNull((Object)item, (String)"call item");
        Position position = item.getSelectionRange().getStart();
        int line = position.getLine();
        int character = position.getCharacter();
        try {
            return this.getIncomingCallItemsAt(item.getUri(), line, character, monitor);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        return null;
    }

    public List<CallHierarchyOutgoingCall> callHierarchyOutgoingCalls(CallHierarchyOutgoingCallsParams params, IProgressMonitor monitor) {
        Assert.isNotNull((Object)params, (String)"params");
        CallHierarchyItem item = params.getItem();
        Assert.isNotNull((Object)item, (String)"call item");
        Position position = item.getSelectionRange().getStart();
        int line = position.getLine();
        int character = position.getCharacter();
        try {
            return this.getOutgoingCallItemsAt(item.getUri(), line, character, monitor);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        return null;
    }

    private IMember getCallHierarchyElement(String uri, int line, int character, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)uri, (String)"uri");
        ITypeRoot root = JDTUtils.resolveTypeRoot(uri);
        if (root == null) {
            return null;
        }
        if (root instanceof ICompilationUnit) {
            ICompilationUnit unit = (ICompilationUnit)root;
            if (root.getResource() == null) {
                return null;
            }
            this.reconcile(unit, monitor);
        }
        this.checkMonitor(monitor);
        IMember candidate = null;
        int offset = JsonRpcHelpers.toOffset((IOpenable)root, line, character);
        List<IJavaElement> selectedElements = this.codeResolve((IJavaElement)root, offset);
        Stream<IJavaElement> possibleElements = selectedElements.stream().filter(CallHierarchyCore::isPossibleInputElement);
        Optional<IJavaElement> firstElement = possibleElements.findFirst();
        if (firstElement.isPresent() && firstElement.get() instanceof IMember) {
            candidate = (IMember)firstElement.get();
        }
        if (candidate == null) {
            candidate = this.getEnclosingMember(root, offset);
        }
        return candidate;
    }

    private List<CallHierarchyIncomingCall> getIncomingCallItemsAt(String uri, int line, int character, IProgressMonitor monitor) throws JavaModelException {
        MethodWrapper wrapper;
        IMember candidate = this.getCallHierarchyElement(uri, line, character, monitor);
        if (candidate == null) {
            return null;
        }
        this.checkMonitor(monitor);
        MethodWrapper methodWrapper = wrapper = incomingMethodWrapperCache.containsKey(candidate) ? incomingMethodWrapperCache.get(candidate) : this.getCallRoot(candidate, true);
        if (wrapper == null) {
            return null;
        }
        MethodWrapper[] calls = wrapper.getCalls(monitor);
        if (calls == null) {
            return null;
        }
        ArrayList<CallHierarchyIncomingCall> result = new ArrayList<CallHierarchyIncomingCall>();
        MethodWrapper[] methodWrapperArray = calls;
        int n = calls.length;
        int n2 = 0;
        while (n2 < n) {
            MethodWrapper call = methodWrapperArray[n2];
            IMember member = call.getMember();
            if (member != null) {
                incomingMethodWrapperCache.put((IJavaElement)member, call);
            }
            CallHierarchyItem symbol = this.toCallHierarchyItem(call.getMember());
            List<Range> ranges = this.toCallRanges(call.getMethodCall().getCallLocations());
            result.add(new CallHierarchyIncomingCall(symbol, ranges));
            ++n2;
        }
        return result;
    }

    private List<CallHierarchyOutgoingCall> getOutgoingCallItemsAt(String uri, int line, int character, IProgressMonitor monitor) throws JavaModelException {
        MethodWrapper wrapper;
        IMember candidate = this.getCallHierarchyElement(uri, line, character, monitor);
        if (candidate == null) {
            return null;
        }
        this.checkMonitor(monitor);
        MethodWrapper methodWrapper = wrapper = outgoingMethodWrapperCache.containsKey(candidate) ? outgoingMethodWrapperCache.get(candidate) : this.getCallRoot(candidate, false);
        if (wrapper == null) {
            return null;
        }
        MethodWrapper[] calls = wrapper.getCalls(monitor);
        if (calls == null) {
            return null;
        }
        ArrayList<CallHierarchyOutgoingCall> result = new ArrayList<CallHierarchyOutgoingCall>();
        MethodWrapper[] methodWrapperArray = calls;
        int n = calls.length;
        int n2 = 0;
        while (n2 < n) {
            MethodWrapper call = methodWrapperArray[n2];
            IMember member = call.getMember();
            if (member != null) {
                outgoingMethodWrapperCache.put((IJavaElement)member, call);
            }
            CallHierarchyItem symbol = this.toCallHierarchyItem(call.getMember());
            List<Range> ranges = this.toCallRanges(call.getMethodCall().getCallLocations());
            result.add(new CallHierarchyOutgoingCall(symbol, ranges));
            ++n2;
        }
        return result;
    }

    private List<IJavaElement> codeResolve(IJavaElement input, int offset) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            return Arrays.asList(((ICodeAssist)input).codeSelect(offset, 0));
        }
        return Collections.emptyList();
    }

    private MethodWrapper getCallRoot(IMember member, boolean isIncomingCall) {
        Assert.isNotNull((Object)member, (String)"member");
        IMember[] members = new IMember[]{member};
        CallHierarchyCore callHierarchy = CallHierarchyCore.getDefault();
        MethodWrapper[] result = isIncomingCall ? callHierarchy.getCallerRoots(members) : callHierarchy.getCalleeRoots(members);
        if (result == null || result.length < 1) {
            return null;
        }
        return result[0];
    }

    private CallHierarchyItem toCallHierarchyItem(IMember member) throws JavaModelException {
        Location fullLocation = this.getLocation((IJavaElement)member, JDTUtils.LocationType.FULL_RANGE);
        Range range = fullLocation.getRange();
        String uri = fullLocation.getUri();
        CallHierarchyItem item = new CallHierarchyItem();
        item.setName(JDTUtils.getName((IJavaElement)member));
        item.setKind(DocumentSymbolHandler.mapKind((IJavaElement)member));
        item.setRange(range);
        item.setSelectionRange(this.getLocation((IJavaElement)member, JDTUtils.LocationType.NAME_RANGE).getRange());
        item.setUri(uri);
        IType declaringType = member.getDeclaringType();
        item.setDetail(declaringType == null ? null : declaringType.getFullyQualifiedName());
        if (JDTUtils.isDeprecated((IJavaElement)member)) {
            item.setTags(Arrays.asList(SymbolTag.Deprecated));
        }
        return item;
    }

    private List<Range> toCallRanges(Collection<CallLocation> callLocations) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (callLocations != null) {
            for (CallLocation location : callLocations) {
                ICompilationUnit openable = location.getMember().getCompilationUnit();
                if (openable == null) {
                    openable = location.getMember().getTypeRoot();
                }
                int[] start = JsonRpcHelpers.toLine((IOpenable)openable, location.getStart());
                int[] end = JsonRpcHelpers.toLine((IOpenable)openable, location.getEnd());
                Assert.isNotNull((Object)start, (String)"start");
                Assert.isNotNull((Object)end, (String)"end");
                Range callRange = new Range(new Position(start[0], start[1]), new Position(end[0], end[1]));
                ranges.add(callRange);
            }
        }
        return ranges;
    }

    private void checkMonitor(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private Location getLocation(IJavaElement element, JDTUtils.LocationType locationType) throws JavaModelException {
        Assert.isNotNull((Object)element, (String)"element");
        Assert.isNotNull((Object)((Object)locationType), (String)"locationType");
        Location location = locationType.toLocation(element);
        if (location == null && element instanceof IType) {
            IType type = (IType)element;
            ICompilationUnit unit = (ICompilationUnit)type.getAncestor(5);
            IClassFile classFile = (IClassFile)type.getAncestor(6);
            if (unit != null || classFile != null && classFile.getSourceRange() != null) {
                location = locationType.toLocation((IJavaElement)type);
            }
        }
        if (location == null && element instanceof IMember && ((IMember)element).getClassFile() != null) {
            location = JDTUtils.toLocation(((IMember)element).getClassFile());
        }
        return location;
    }

    private IMember getEnclosingMember(ITypeRoot root, int offset) {
        Assert.isNotNull((Object)root, (String)"root");
        try {
            IJavaElement enclosingElement = root.getElementAt(offset);
            if (enclosingElement instanceof IMethod || enclosingElement instanceof IInitializer || enclosingElement instanceof IField) {
                return (IMember)enclosingElement;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
        }
        return null;
    }

    private void reconcile(ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        unit.reconcile(0, false, null, monitor);
    }
}

