/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import '../services/markerDecorations';
import './media/editor.css';
import * as nls from '../../../nls';
import * as dom from '../../../base/browser/dom';
import { onUnexpectedError } from '../../../base/common/errors';
import { Emitter } from '../../../base/common/event';
import { hash } from '../../../base/common/hash';
import { Disposable, dispose } from '../../../base/common/lifecycle';
import { Schemas } from '../../../base/common/network';
import { Configuration } from '../config/configuration';
import { EditorExtensionsRegistry } from '../editorExtensions';
import { ICodeEditorService } from '../services/codeEditorService';
import { View } from '../view/viewImpl';
import { ViewUserInputEvents } from '../view/viewUserInputEvents';
import { filterValidationDecorations } from '../../common/config/editorOptions';
import { Cursor } from '../../common/controller/cursor';
import { CursorColumns } from '../../common/controller/cursorCommon';
import { Position } from '../../common/core/position';
import { Range } from '../../common/core/range';
import { Selection } from '../../common/core/selection';
import { InternalEditorAction } from '../../common/editorAction';
import * as editorCommon from '../../common/editorCommon';
import { EditorContextKeys } from '../../common/editorContextKeys';
import { ModelDecorationOptions } from '../../common/model/textModel';
import * as modes from '../../common/modes';
import { editorUnnecessaryCodeBorder, editorUnnecessaryCodeOpacity } from '../../common/view/editorColorRegistry';
import { editorErrorBorder, editorErrorForeground, editorHintBorder, editorHintForeground, editorInfoBorder, editorInfoForeground, editorWarningBorder, editorWarningForeground, editorForeground, editorErrorBackground, editorInfoBackground, editorWarningBackground } from '../../../platform/theme/common/colorRegistry';
import { ViewModel } from '../../common/viewModel/viewModelImpl';
import { ICommandService } from '../../../platform/commands/common/commands';
import { IContextKeyService } from '../../../platform/contextkey/common/contextkey';
import { IInstantiationService } from '../../../platform/instantiation/common/instantiation';
import { ServiceCollection } from '../../../platform/instantiation/common/serviceCollection';
import { INotificationService } from '../../../platform/notification/common/notification';
import { IThemeService, registerThemingParticipant } from '../../../platform/theme/common/themeService';
import { IAccessibilityService } from '../../../platform/accessibility/common/accessibility';
import { withNullAsUndefined } from '../../../base/common/types';
import { MonospaceLineBreaksComputerFactory } from '../../common/viewModel/monospaceLineBreaksComputer';
import { DOMLineBreaksComputerFactory } from '../view/domLineBreaksComputer';
import { WordOperations } from '../../common/controller/cursorWordOperations';
var EDITOR_ID = 0;
var ModelData = /** @class */ (function () {
    function ModelData(model, viewModel, view, hasRealView, listenersToRemove) {
        this.model = model;
        this.viewModel = viewModel;
        this.view = view;
        this.hasRealView = hasRealView;
        this.listenersToRemove = listenersToRemove;
    }
    ModelData.prototype.dispose = function () {
        dispose(this.listenersToRemove);
        this.model.onBeforeDetached();
        if (this.hasRealView) {
            this.view.dispose();
        }
        this.viewModel.dispose();
    };
    return ModelData;
}());
var CodeEditorWidget = /** @class */ (function (_super) {
    __extends(CodeEditorWidget, _super);
    function CodeEditorWidget(domElement, _options, codeEditorWidgetOptions, instantiationService, codeEditorService, commandService, contextKeyService, themeService, notificationService, accessibilityService) {
        var e_1, _a;
        var _this = _super.call(this) || this;
        //#region Eventing
        _this._onDidDispose = _this._register(new Emitter());
        _this.onDidDispose = _this._onDidDispose.event;
        _this._onDidChangeModelContent = _this._register(new Emitter());
        _this.onDidChangeModelContent = _this._onDidChangeModelContent.event;
        _this._onDidChangeModelLanguage = _this._register(new Emitter());
        _this.onDidChangeModelLanguage = _this._onDidChangeModelLanguage.event;
        _this._onDidChangeModelLanguageConfiguration = _this._register(new Emitter());
        _this.onDidChangeModelLanguageConfiguration = _this._onDidChangeModelLanguageConfiguration.event;
        _this._onDidChangeModelOptions = _this._register(new Emitter());
        _this.onDidChangeModelOptions = _this._onDidChangeModelOptions.event;
        _this._onDidChangeModelDecorations = _this._register(new Emitter());
        _this.onDidChangeModelDecorations = _this._onDidChangeModelDecorations.event;
        _this._onDidChangeConfiguration = _this._register(new Emitter());
        _this.onDidChangeConfiguration = _this._onDidChangeConfiguration.event;
        _this._onDidChangeModel = _this._register(new Emitter());
        _this.onDidChangeModel = _this._onDidChangeModel.event;
        _this._onDidChangeCursorPosition = _this._register(new Emitter());
        _this.onDidChangeCursorPosition = _this._onDidChangeCursorPosition.event;
        _this._onDidChangeCursorSelection = _this._register(new Emitter());
        _this.onDidChangeCursorSelection = _this._onDidChangeCursorSelection.event;
        _this._onDidAttemptReadOnlyEdit = _this._register(new Emitter());
        _this.onDidAttemptReadOnlyEdit = _this._onDidAttemptReadOnlyEdit.event;
        _this._onDidLayoutChange = _this._register(new Emitter());
        _this.onDidLayoutChange = _this._onDidLayoutChange.event;
        _this._editorTextFocus = _this._register(new BooleanEventEmitter());
        _this.onDidFocusEditorText = _this._editorTextFocus.onDidChangeToTrue;
        _this.onDidBlurEditorText = _this._editorTextFocus.onDidChangeToFalse;
        _this._editorWidgetFocus = _this._register(new BooleanEventEmitter());
        _this.onDidFocusEditorWidget = _this._editorWidgetFocus.onDidChangeToTrue;
        _this.onDidBlurEditorWidget = _this._editorWidgetFocus.onDidChangeToFalse;
        _this._onWillType = _this._register(new Emitter());
        _this.onWillType = _this._onWillType.event;
        _this._onDidType = _this._register(new Emitter());
        _this.onDidType = _this._onDidType.event;
        _this._onDidCompositionStart = _this._register(new Emitter());
        _this.onDidCompositionStart = _this._onDidCompositionStart.event;
        _this._onDidCompositionEnd = _this._register(new Emitter());
        _this.onDidCompositionEnd = _this._onDidCompositionEnd.event;
        _this._onDidPaste = _this._register(new Emitter());
        _this.onDidPaste = _this._onDidPaste.event;
        _this._onMouseUp = _this._register(new Emitter());
        _this.onMouseUp = _this._onMouseUp.event;
        _this._onMouseDown = _this._register(new Emitter());
        _this.onMouseDown = _this._onMouseDown.event;
        _this._onMouseDrag = _this._register(new Emitter());
        _this.onMouseDrag = _this._onMouseDrag.event;
        _this._onMouseDrop = _this._register(new Emitter());
        _this.onMouseDrop = _this._onMouseDrop.event;
        _this._onMouseDropCanceled = _this._register(new Emitter());
        _this.onMouseDropCanceled = _this._onMouseDropCanceled.event;
        _this._onContextMenu = _this._register(new Emitter());
        _this.onContextMenu = _this._onContextMenu.event;
        _this._onMouseMove = _this._register(new Emitter());
        _this.onMouseMove = _this._onMouseMove.event;
        _this._onMouseLeave = _this._register(new Emitter());
        _this.onMouseLeave = _this._onMouseLeave.event;
        _this._onMouseWheel = _this._register(new Emitter());
        _this.onMouseWheel = _this._onMouseWheel.event;
        _this._onKeyUp = _this._register(new Emitter());
        _this.onKeyUp = _this._onKeyUp.event;
        _this._onKeyDown = _this._register(new Emitter());
        _this.onKeyDown = _this._onKeyDown.event;
        _this._onDidContentSizeChange = _this._register(new Emitter());
        _this.onDidContentSizeChange = _this._onDidContentSizeChange.event;
        _this._onDidScrollChange = _this._register(new Emitter());
        _this.onDidScrollChange = _this._onDidScrollChange.event;
        _this._onDidChangeViewZones = _this._register(new Emitter());
        _this.onDidChangeViewZones = _this._onDidChangeViewZones.event;
        var options = __assign({}, _options);
        _this._domElement = domElement;
        _this._overflowWidgetsDomNode = options.overflowWidgetsDomNode;
        delete options.overflowWidgetsDomNode;
        _this._id = (++EDITOR_ID);
        _this._decorationTypeKeysToIds = {};
        _this._decorationTypeSubtypes = {};
        _this.isSimpleWidget = codeEditorWidgetOptions.isSimpleWidget || false;
        _this._telemetryData = codeEditorWidgetOptions.telemetryData;
        _this._configuration = _this._register(_this._createConfiguration(options, accessibilityService));
        _this._register(_this._configuration.onDidChange(function (e) {
            _this._onDidChangeConfiguration.fire(e);
            var options = _this._configuration.options;
            if (e.hasChanged(124 /* layoutInfo */)) {
                var layoutInfo = options.get(124 /* layoutInfo */);
                _this._onDidLayoutChange.fire(layoutInfo);
            }
        }));
        _this._contextKeyService = _this._register(contextKeyService.createScoped(_this._domElement));
        _this._notificationService = notificationService;
        _this._codeEditorService = codeEditorService;
        _this._commandService = commandService;
        _this._themeService = themeService;
        _this._register(new EditorContextKeysManager(_this, _this._contextKeyService));
        _this._register(new EditorModeContext(_this, _this._contextKeyService));
        _this._instantiationService = instantiationService.createChild(new ServiceCollection([IContextKeyService, _this._contextKeyService]));
        _this._modelData = null;
        _this._contributions = {};
        _this._actions = {};
        _this._focusTracker = new CodeEditorWidgetFocusTracker(domElement);
        _this._focusTracker.onChange(function () {
            _this._editorWidgetFocus.setValue(_this._focusTracker.hasFocus());
        });
        _this._contentWidgets = {};
        _this._overlayWidgets = {};
        var contributions;
        if (Array.isArray(codeEditorWidgetOptions.contributions)) {
            contributions = codeEditorWidgetOptions.contributions;
        }
        else {
            contributions = EditorExtensionsRegistry.getEditorContributions();
        }
        try {
            for (var contributions_1 = __values(contributions), contributions_1_1 = contributions_1.next(); !contributions_1_1.done; contributions_1_1 = contributions_1.next()) {
                var desc = contributions_1_1.value;
                try {
                    var contribution = _this._instantiationService.createInstance(desc.ctor, _this);
                    _this._contributions[desc.id] = contribution;
                }
                catch (err) {
                    onUnexpectedError(err);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (contributions_1_1 && !contributions_1_1.done && (_a = contributions_1.return)) _a.call(contributions_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        EditorExtensionsRegistry.getEditorActions().forEach(function (action) {
            var internalAction = new InternalEditorAction(action.id, action.label, action.alias, withNullAsUndefined(action.precondition), function () {
                return _this._instantiationService.invokeFunction(function (accessor) {
                    return Promise.resolve(action.runEditorCommand(accessor, _this, null));
                });
            }, _this._contextKeyService);
            _this._actions[internalAction.id] = internalAction;
        });
        _this._codeEditorService.addCodeEditor(_this);
        return _this;
    }
    CodeEditorWidget.prototype._createConfiguration = function (options, accessibilityService) {
        return new Configuration(this.isSimpleWidget, options, this._domElement, accessibilityService);
    };
    CodeEditorWidget.prototype.getId = function () {
        return this.getEditorType() + ':' + this._id;
    };
    CodeEditorWidget.prototype.getEditorType = function () {
        return editorCommon.EditorType.ICodeEditor;
    };
    CodeEditorWidget.prototype.dispose = function () {
        this._codeEditorService.removeCodeEditor(this);
        this._focusTracker.dispose();
        var keys = Object.keys(this._contributions);
        for (var i = 0, len = keys.length; i < len; i++) {
            var contributionId = keys[i];
            this._contributions[contributionId].dispose();
        }
        this._removeDecorationTypes();
        this._postDetachModelCleanup(this._detachModel());
        this._onDidDispose.fire();
        _super.prototype.dispose.call(this);
    };
    CodeEditorWidget.prototype.invokeWithinContext = function (fn) {
        return this._instantiationService.invokeFunction(fn);
    };
    CodeEditorWidget.prototype.updateOptions = function (newOptions) {
        this._configuration.updateOptions(newOptions);
    };
    CodeEditorWidget.prototype.getOptions = function () {
        return this._configuration.options;
    };
    CodeEditorWidget.prototype.getOption = function (id) {
        return this._configuration.options.get(id);
    };
    CodeEditorWidget.prototype.getRawOptions = function () {
        return this._configuration.getRawOptions();
    };
    CodeEditorWidget.prototype.getOverflowWidgetsDomNode = function () {
        return this._overflowWidgetsDomNode;
    };
    CodeEditorWidget.prototype.getConfiguredWordAtPosition = function (position) {
        if (!this._modelData) {
            return null;
        }
        return WordOperations.getWordAtPosition(this._modelData.model, this._configuration.options.get(110 /* wordSeparators */), position);
    };
    CodeEditorWidget.prototype.getValue = function (options) {
        if (options === void 0) { options = null; }
        if (!this._modelData) {
            return '';
        }
        var preserveBOM = (options && options.preserveBOM) ? true : false;
        var eolPreference = 0 /* TextDefined */;
        if (options && options.lineEnding && options.lineEnding === '\n') {
            eolPreference = 1 /* LF */;
        }
        else if (options && options.lineEnding && options.lineEnding === '\r\n') {
            eolPreference = 2 /* CRLF */;
        }
        return this._modelData.model.getValue(eolPreference, preserveBOM);
    };
    CodeEditorWidget.prototype.setValue = function (newValue) {
        if (!this._modelData) {
            return;
        }
        this._modelData.model.setValue(newValue);
    };
    CodeEditorWidget.prototype.getModel = function () {
        if (!this._modelData) {
            return null;
        }
        return this._modelData.model;
    };
    CodeEditorWidget.prototype.setModel = function (_model) {
        if (_model === void 0) { _model = null; }
        var model = _model;
        if (this._modelData === null && model === null) {
            // Current model is the new model
            return;
        }
        if (this._modelData && this._modelData.model === model) {
            // Current model is the new model
            return;
        }
        var hasTextFocus = this.hasTextFocus();
        var detachedModel = this._detachModel();
        this._attachModel(model);
        if (hasTextFocus && this.hasModel()) {
            this.focus();
        }
        var e = {
            oldModelUrl: detachedModel ? detachedModel.uri : null,
            newModelUrl: model ? model.uri : null
        };
        this._removeDecorationTypes();
        this._onDidChangeModel.fire(e);
        this._postDetachModelCleanup(detachedModel);
    };
    CodeEditorWidget.prototype._removeDecorationTypes = function () {
        this._decorationTypeKeysToIds = {};
        if (this._decorationTypeSubtypes) {
            for (var decorationType in this._decorationTypeSubtypes) {
                var subTypes = this._decorationTypeSubtypes[decorationType];
                for (var subType in subTypes) {
                    this._removeDecorationType(decorationType + '-' + subType);
                }
            }
            this._decorationTypeSubtypes = {};
        }
    };
    CodeEditorWidget.prototype.getVisibleRanges = function () {
        if (!this._modelData) {
            return [];
        }
        return this._modelData.viewModel.getVisibleRanges();
    };
    CodeEditorWidget.prototype.getVisibleRangesPlusViewportAboveBelow = function () {
        if (!this._modelData) {
            return [];
        }
        return this._modelData.viewModel.getVisibleRangesPlusViewportAboveBelow();
    };
    CodeEditorWidget.prototype.getWhitespaces = function () {
        if (!this._modelData) {
            return [];
        }
        return this._modelData.viewModel.viewLayout.getWhitespaces();
    };
    CodeEditorWidget._getVerticalOffsetForPosition = function (modelData, modelLineNumber, modelColumn) {
        var modelPosition = modelData.model.validatePosition({
            lineNumber: modelLineNumber,
            column: modelColumn
        });
        var viewPosition = modelData.viewModel.coordinatesConverter.convertModelPositionToViewPosition(modelPosition);
        return modelData.viewModel.viewLayout.getVerticalOffsetForLineNumber(viewPosition.lineNumber);
    };
    CodeEditorWidget.prototype.getTopForLineNumber = function (lineNumber) {
        if (!this._modelData) {
            return -1;
        }
        return CodeEditorWidget._getVerticalOffsetForPosition(this._modelData, lineNumber, 1);
    };
    CodeEditorWidget.prototype.getTopForPosition = function (lineNumber, column) {
        if (!this._modelData) {
            return -1;
        }
        return CodeEditorWidget._getVerticalOffsetForPosition(this._modelData, lineNumber, column);
    };
    CodeEditorWidget.prototype.setHiddenAreas = function (ranges) {
        if (this._modelData) {
            this._modelData.viewModel.setHiddenAreas(ranges.map(function (r) { return Range.lift(r); }));
        }
    };
    CodeEditorWidget.prototype.getVisibleColumnFromPosition = function (rawPosition) {
        if (!this._modelData) {
            return rawPosition.column;
        }
        var position = this._modelData.model.validatePosition(rawPosition);
        var tabSize = this._modelData.model.getOptions().tabSize;
        return CursorColumns.visibleColumnFromColumn(this._modelData.model.getLineContent(position.lineNumber), position.column, tabSize) + 1;
    };
    CodeEditorWidget.prototype.getStatusbarColumn = function (rawPosition) {
        if (!this._modelData) {
            return rawPosition.column;
        }
        var position = this._modelData.model.validatePosition(rawPosition);
        var tabSize = this._modelData.model.getOptions().tabSize;
        return CursorColumns.toStatusbarColumn(this._modelData.model.getLineContent(position.lineNumber), position.column, tabSize);
    };
    CodeEditorWidget.prototype.getPosition = function () {
        if (!this._modelData) {
            return null;
        }
        return this._modelData.viewModel.getPosition();
    };
    CodeEditorWidget.prototype.setPosition = function (position) {
        if (!this._modelData) {
            return;
        }
        if (!Position.isIPosition(position)) {
            throw new Error('Invalid arguments');
        }
        this._modelData.viewModel.setSelections('api', [{
                selectionStartLineNumber: position.lineNumber,
                selectionStartColumn: position.column,
                positionLineNumber: position.lineNumber,
                positionColumn: position.column
            }]);
    };
    CodeEditorWidget.prototype._sendRevealRange = function (modelRange, verticalType, revealHorizontal, scrollType) {
        if (!this._modelData) {
            return;
        }
        if (!Range.isIRange(modelRange)) {
            throw new Error('Invalid arguments');
        }
        var validatedModelRange = this._modelData.model.validateRange(modelRange);
        var viewRange = this._modelData.viewModel.coordinatesConverter.convertModelRangeToViewRange(validatedModelRange);
        this._modelData.viewModel.revealRange('api', revealHorizontal, viewRange, verticalType, scrollType);
    };
    CodeEditorWidget.prototype.revealLine = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLine(lineNumber, 0 /* Simple */, scrollType);
    };
    CodeEditorWidget.prototype.revealLineInCenter = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLine(lineNumber, 1 /* Center */, scrollType);
    };
    CodeEditorWidget.prototype.revealLineInCenterIfOutsideViewport = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLine(lineNumber, 2 /* CenterIfOutsideViewport */, scrollType);
    };
    CodeEditorWidget.prototype.revealLineNearTop = function (lineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLine(lineNumber, 5 /* NearTop */, scrollType);
    };
    CodeEditorWidget.prototype._revealLine = function (lineNumber, revealType, scrollType) {
        if (typeof lineNumber !== 'number') {
            throw new Error('Invalid arguments');
        }
        this._sendRevealRange(new Range(lineNumber, 1, lineNumber, 1), revealType, false, scrollType);
    };
    CodeEditorWidget.prototype.revealPosition = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealPosition(position, 0 /* Simple */, true, scrollType);
    };
    CodeEditorWidget.prototype.revealPositionInCenter = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealPosition(position, 1 /* Center */, true, scrollType);
    };
    CodeEditorWidget.prototype.revealPositionInCenterIfOutsideViewport = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealPosition(position, 2 /* CenterIfOutsideViewport */, true, scrollType);
    };
    CodeEditorWidget.prototype.revealPositionNearTop = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealPosition(position, 5 /* NearTop */, true, scrollType);
    };
    CodeEditorWidget.prototype._revealPosition = function (position, verticalType, revealHorizontal, scrollType) {
        if (!Position.isIPosition(position)) {
            throw new Error('Invalid arguments');
        }
        this._sendRevealRange(new Range(position.lineNumber, position.column, position.lineNumber, position.column), verticalType, revealHorizontal, scrollType);
    };
    CodeEditorWidget.prototype.getSelection = function () {
        if (!this._modelData) {
            return null;
        }
        return this._modelData.viewModel.getSelection();
    };
    CodeEditorWidget.prototype.getSelections = function () {
        if (!this._modelData) {
            return null;
        }
        return this._modelData.viewModel.getSelections();
    };
    CodeEditorWidget.prototype.setSelection = function (something) {
        var isSelection = Selection.isISelection(something);
        var isRange = Range.isIRange(something);
        if (!isSelection && !isRange) {
            throw new Error('Invalid arguments');
        }
        if (isSelection) {
            this._setSelectionImpl(something);
        }
        else if (isRange) {
            // act as if it was an IRange
            var selection = {
                selectionStartLineNumber: something.startLineNumber,
                selectionStartColumn: something.startColumn,
                positionLineNumber: something.endLineNumber,
                positionColumn: something.endColumn
            };
            this._setSelectionImpl(selection);
        }
    };
    CodeEditorWidget.prototype._setSelectionImpl = function (sel) {
        if (!this._modelData) {
            return;
        }
        var selection = new Selection(sel.selectionStartLineNumber, sel.selectionStartColumn, sel.positionLineNumber, sel.positionColumn);
        this._modelData.viewModel.setSelections('api', [selection]);
    };
    CodeEditorWidget.prototype.revealLines = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLines(startLineNumber, endLineNumber, 0 /* Simple */, scrollType);
    };
    CodeEditorWidget.prototype.revealLinesInCenter = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLines(startLineNumber, endLineNumber, 1 /* Center */, scrollType);
    };
    CodeEditorWidget.prototype.revealLinesInCenterIfOutsideViewport = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLines(startLineNumber, endLineNumber, 2 /* CenterIfOutsideViewport */, scrollType);
    };
    CodeEditorWidget.prototype.revealLinesNearTop = function (startLineNumber, endLineNumber, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealLines(startLineNumber, endLineNumber, 5 /* NearTop */, scrollType);
    };
    CodeEditorWidget.prototype._revealLines = function (startLineNumber, endLineNumber, verticalType, scrollType) {
        if (typeof startLineNumber !== 'number' || typeof endLineNumber !== 'number') {
            throw new Error('Invalid arguments');
        }
        this._sendRevealRange(new Range(startLineNumber, 1, endLineNumber, 1), verticalType, false, scrollType);
    };
    CodeEditorWidget.prototype.revealRange = function (range, scrollType, revealVerticalInCenter, revealHorizontal) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        if (revealVerticalInCenter === void 0) { revealVerticalInCenter = false; }
        if (revealHorizontal === void 0) { revealHorizontal = true; }
        this._revealRange(range, revealVerticalInCenter ? 1 /* Center */ : 0 /* Simple */, revealHorizontal, scrollType);
    };
    CodeEditorWidget.prototype.revealRangeInCenter = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealRange(range, 1 /* Center */, true, scrollType);
    };
    CodeEditorWidget.prototype.revealRangeInCenterIfOutsideViewport = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealRange(range, 2 /* CenterIfOutsideViewport */, true, scrollType);
    };
    CodeEditorWidget.prototype.revealRangeNearTop = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealRange(range, 5 /* NearTop */, true, scrollType);
    };
    CodeEditorWidget.prototype.revealRangeNearTopIfOutsideViewport = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealRange(range, 6 /* NearTopIfOutsideViewport */, true, scrollType);
    };
    CodeEditorWidget.prototype.revealRangeAtTop = function (range, scrollType) {
        if (scrollType === void 0) { scrollType = 0 /* Smooth */; }
        this._revealRange(range, 3 /* Top */, true, scrollType);
    };
    CodeEditorWidget.prototype._revealRange = function (range, verticalType, revealHorizontal, scrollType) {
        if (!Range.isIRange(range)) {
            throw new Error('Invalid arguments');
        }
        this._sendRevealRange(Range.lift(range), verticalType, revealHorizontal, scrollType);
    };
    CodeEditorWidget.prototype.setSelections = function (ranges, source, reason) {
        if (source === void 0) { source = 'api'; }
        if (reason === void 0) { reason = 0 /* NotSet */; }
        if (!this._modelData) {
            return;
        }
        if (!ranges || ranges.length === 0) {
            throw new Error('Invalid arguments');
        }
        for (var i = 0, len = ranges.length; i < len; i++) {
            if (!Selection.isISelection(ranges[i])) {
                throw new Error('Invalid arguments');
            }
        }
        this._modelData.viewModel.setSelections(source, ranges, reason);
    };
    CodeEditorWidget.prototype.getContentWidth = function () {
        if (!this._modelData) {
            return -1;
        }
        return this._modelData.viewModel.viewLayout.getContentWidth();
    };
    CodeEditorWidget.prototype.getScrollWidth = function () {
        if (!this._modelData) {
            return -1;
        }
        return this._modelData.viewModel.viewLayout.getScrollWidth();
    };
    CodeEditorWidget.prototype.getScrollLeft = function () {
        if (!this._modelData) {
            return -1;
        }
        return this._modelData.viewModel.viewLayout.getCurrentScrollLeft();
    };
    CodeEditorWidget.prototype.getContentHeight = function () {
        if (!this._modelData) {
            return -1;
        }
        return this._modelData.viewModel.viewLayout.getContentHeight();
    };
    CodeEditorWidget.prototype.getScrollHeight = function () {
        if (!this._modelData) {
            return -1;
        }
        return this._modelData.viewModel.viewLayout.getScrollHeight();
    };
    CodeEditorWidget.prototype.getScrollTop = function () {
        if (!this._modelData) {
            return -1;
        }
        return this._modelData.viewModel.viewLayout.getCurrentScrollTop();
    };
    CodeEditorWidget.prototype.setScrollLeft = function (newScrollLeft, scrollType) {
        if (scrollType === void 0) { scrollType = 1 /* Immediate */; }
        if (!this._modelData) {
            return;
        }
        if (typeof newScrollLeft !== 'number') {
            throw new Error('Invalid arguments');
        }
        this._modelData.viewModel.setScrollPosition({
            scrollLeft: newScrollLeft
        }, scrollType);
    };
    CodeEditorWidget.prototype.setScrollTop = function (newScrollTop, scrollType) {
        if (scrollType === void 0) { scrollType = 1 /* Immediate */; }
        if (!this._modelData) {
            return;
        }
        if (typeof newScrollTop !== 'number') {
            throw new Error('Invalid arguments');
        }
        this._modelData.viewModel.setScrollPosition({
            scrollTop: newScrollTop
        }, scrollType);
    };
    CodeEditorWidget.prototype.setScrollPosition = function (position, scrollType) {
        if (scrollType === void 0) { scrollType = 1 /* Immediate */; }
        if (!this._modelData) {
            return;
        }
        this._modelData.viewModel.setScrollPosition(position, scrollType);
    };
    CodeEditorWidget.prototype.saveViewState = function () {
        var e_2, _a;
        if (!this._modelData) {
            return null;
        }
        var contributionsState = {};
        var keys = Object.keys(this._contributions);
        try {
            for (var keys_1 = __values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var id = keys_1_1.value;
                var contribution = this._contributions[id];
                if (typeof contribution.saveViewState === 'function') {
                    contributionsState[id] = contribution.saveViewState();
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return)) _a.call(keys_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        var cursorState = this._modelData.viewModel.saveCursorState();
        var viewState = this._modelData.viewModel.saveState();
        return {
            cursorState: cursorState,
            viewState: viewState,
            contributionsState: contributionsState
        };
    };
    CodeEditorWidget.prototype.restoreViewState = function (s) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return;
        }
        var codeEditorState = s;
        if (codeEditorState && codeEditorState.cursorState && codeEditorState.viewState) {
            var cursorState = codeEditorState.cursorState;
            if (Array.isArray(cursorState)) {
                this._modelData.viewModel.restoreCursorState(cursorState);
            }
            else {
                // Backwards compatibility
                this._modelData.viewModel.restoreCursorState([cursorState]);
            }
            var contributionsState = codeEditorState.contributionsState || {};
            var keys = Object.keys(this._contributions);
            for (var i = 0, len = keys.length; i < len; i++) {
                var id = keys[i];
                var contribution = this._contributions[id];
                if (typeof contribution.restoreViewState === 'function') {
                    contribution.restoreViewState(contributionsState[id]);
                }
            }
            var reducedState = this._modelData.viewModel.reduceRestoreState(codeEditorState.viewState);
            this._modelData.view.restoreState(reducedState);
        }
    };
    CodeEditorWidget.prototype.onVisible = function () {
        var _a;
        (_a = this._modelData) === null || _a === void 0 ? void 0 : _a.view.refreshFocusState();
    };
    CodeEditorWidget.prototype.onHide = function () {
        var _a;
        (_a = this._modelData) === null || _a === void 0 ? void 0 : _a.view.refreshFocusState();
        this._focusTracker.refreshState();
    };
    CodeEditorWidget.prototype.getContribution = function (id) {
        return (this._contributions[id] || null);
    };
    CodeEditorWidget.prototype.getActions = function () {
        var result = [];
        var keys = Object.keys(this._actions);
        for (var i = 0, len = keys.length; i < len; i++) {
            var id = keys[i];
            result.push(this._actions[id]);
        }
        return result;
    };
    CodeEditorWidget.prototype.getSupportedActions = function () {
        var result = this.getActions();
        result = result.filter(function (action) { return action.isSupported(); });
        return result;
    };
    CodeEditorWidget.prototype.getAction = function (id) {
        return this._actions[id] || null;
    };
    CodeEditorWidget.prototype.trigger = function (source, handlerId, payload) {
        payload = payload || {};
        switch (handlerId) {
            case "compositionStart" /* CompositionStart */:
                this._startComposition();
                return;
            case "compositionEnd" /* CompositionEnd */:
                this._endComposition(source);
                return;
            case "type" /* Type */: {
                var args = payload;
                this._type(source, args.text || '');
                return;
            }
            case "replacePreviousChar" /* ReplacePreviousChar */: {
                var args = payload;
                this._compositionType(source, args.text || '', args.replaceCharCnt || 0, 0, 0);
                return;
            }
            case "compositionType" /* CompositionType */: {
                var args = payload;
                this._compositionType(source, args.text || '', args.replacePrevCharCnt || 0, args.replaceNextCharCnt || 0, args.positionDelta || 0);
                return;
            }
            case "paste" /* Paste */: {
                var args = payload;
                this._paste(source, args.text || '', args.pasteOnNewLine || false, args.multicursorText || null, args.mode || null);
                return;
            }
            case "cut" /* Cut */:
                this._cut(source);
                return;
        }
        var action = this.getAction(handlerId);
        if (action) {
            Promise.resolve(action.run()).then(undefined, onUnexpectedError);
            return;
        }
        if (!this._modelData) {
            return;
        }
        if (this._triggerEditorCommand(source, handlerId, payload)) {
            return;
        }
        this._commandService.executeCommand(handlerId, payload);
    };
    CodeEditorWidget.prototype._startComposition = function () {
        if (!this._modelData) {
            return;
        }
        this._modelData.viewModel.startComposition();
        this._onDidCompositionStart.fire();
    };
    CodeEditorWidget.prototype._endComposition = function (source) {
        if (!this._modelData) {
            return;
        }
        this._modelData.viewModel.endComposition(source);
        this._onDidCompositionEnd.fire();
    };
    CodeEditorWidget.prototype._type = function (source, text) {
        if (!this._modelData || text.length === 0) {
            return;
        }
        if (source === 'keyboard') {
            this._onWillType.fire(text);
        }
        this._modelData.viewModel.type(text, source);
        if (source === 'keyboard') {
            this._onDidType.fire(text);
        }
    };
    CodeEditorWidget.prototype._compositionType = function (source, text, replacePrevCharCnt, replaceNextCharCnt, positionDelta) {
        if (!this._modelData) {
            return;
        }
        this._modelData.viewModel.compositionType(text, replacePrevCharCnt, replaceNextCharCnt, positionDelta, source);
    };
    CodeEditorWidget.prototype._paste = function (source, text, pasteOnNewLine, multicursorText, mode) {
        if (!this._modelData || text.length === 0) {
            return;
        }
        var startPosition = this._modelData.viewModel.getSelection().getStartPosition();
        this._modelData.viewModel.paste(text, pasteOnNewLine, multicursorText, source);
        var endPosition = this._modelData.viewModel.getSelection().getStartPosition();
        if (source === 'keyboard') {
            this._onDidPaste.fire({
                range: new Range(startPosition.lineNumber, startPosition.column, endPosition.lineNumber, endPosition.column),
                mode: mode
            });
        }
    };
    CodeEditorWidget.prototype._cut = function (source) {
        if (!this._modelData) {
            return;
        }
        this._modelData.viewModel.cut(source);
    };
    CodeEditorWidget.prototype._triggerEditorCommand = function (source, handlerId, payload) {
        var _this = this;
        var command = EditorExtensionsRegistry.getEditorCommand(handlerId);
        if (command) {
            payload = payload || {};
            payload.source = source;
            this._instantiationService.invokeFunction(function (accessor) {
                Promise.resolve(command.runEditorCommand(accessor, _this, payload)).then(undefined, onUnexpectedError);
            });
            return true;
        }
        return false;
    };
    CodeEditorWidget.prototype._getViewModel = function () {
        if (!this._modelData) {
            return null;
        }
        return this._modelData.viewModel;
    };
    CodeEditorWidget.prototype.pushUndoStop = function () {
        if (!this._modelData) {
            return false;
        }
        if (this._configuration.options.get(75 /* readOnly */)) {
            // read only editor => sorry!
            return false;
        }
        this._modelData.model.pushStackElement();
        return true;
    };
    CodeEditorWidget.prototype.popUndoStop = function () {
        if (!this._modelData) {
            return false;
        }
        if (this._configuration.options.get(75 /* readOnly */)) {
            // read only editor => sorry!
            return false;
        }
        this._modelData.model.popStackElement();
        return true;
    };
    CodeEditorWidget.prototype.executeEdits = function (source, edits, endCursorState) {
        if (!this._modelData) {
            return false;
        }
        if (this._configuration.options.get(75 /* readOnly */)) {
            // read only editor => sorry!
            return false;
        }
        var cursorStateComputer;
        if (!endCursorState) {
            cursorStateComputer = function () { return null; };
        }
        else if (Array.isArray(endCursorState)) {
            cursorStateComputer = function () { return endCursorState; };
        }
        else {
            cursorStateComputer = endCursorState;
        }
        this._modelData.viewModel.executeEdits(source, edits, cursorStateComputer);
        return true;
    };
    CodeEditorWidget.prototype.executeCommand = function (source, command) {
        if (!this._modelData) {
            return;
        }
        this._modelData.viewModel.executeCommand(command, source);
    };
    CodeEditorWidget.prototype.executeCommands = function (source, commands) {
        if (!this._modelData) {
            return;
        }
        this._modelData.viewModel.executeCommands(commands, source);
    };
    CodeEditorWidget.prototype.changeDecorations = function (callback) {
        if (!this._modelData) {
            // callback will not be called
            return null;
        }
        return this._modelData.model.changeDecorations(callback, this._id);
    };
    CodeEditorWidget.prototype.getLineDecorations = function (lineNumber) {
        if (!this._modelData) {
            return null;
        }
        return this._modelData.model.getLineDecorations(lineNumber, this._id, filterValidationDecorations(this._configuration.options));
    };
    CodeEditorWidget.prototype.deltaDecorations = function (oldDecorations, newDecorations) {
        if (!this._modelData) {
            return [];
        }
        if (oldDecorations.length === 0 && newDecorations.length === 0) {
            return oldDecorations;
        }
        return this._modelData.model.deltaDecorations(oldDecorations, newDecorations, this._id);
    };
    CodeEditorWidget.prototype.setDecorations = function (decorationTypeKey, decorationOptions) {
        var e_3, _a;
        var newDecorationsSubTypes = {};
        var oldDecorationsSubTypes = this._decorationTypeSubtypes[decorationTypeKey] || {};
        this._decorationTypeSubtypes[decorationTypeKey] = newDecorationsSubTypes;
        var newModelDecorations = [];
        try {
            for (var decorationOptions_1 = __values(decorationOptions), decorationOptions_1_1 = decorationOptions_1.next(); !decorationOptions_1_1.done; decorationOptions_1_1 = decorationOptions_1.next()) {
                var decorationOption = decorationOptions_1_1.value;
                var typeKey = decorationTypeKey;
                if (decorationOption.renderOptions) {
                    // identify custom reder options by a hash code over all keys and values
                    // For custom render options register a decoration type if necessary
                    var subType = hash(decorationOption.renderOptions).toString(16);
                    // The fact that `decorationTypeKey` appears in the typeKey has no influence
                    // it is just a mechanism to get predictable and unique keys (repeatable for the same options and unique across clients)
                    typeKey = decorationTypeKey + '-' + subType;
                    if (!oldDecorationsSubTypes[subType] && !newDecorationsSubTypes[subType]) {
                        // decoration type did not exist before, register new one
                        this._registerDecorationType(typeKey, decorationOption.renderOptions, decorationTypeKey);
                    }
                    newDecorationsSubTypes[subType] = true;
                }
                var opts = this._resolveDecorationOptions(typeKey, !!decorationOption.hoverMessage);
                if (decorationOption.hoverMessage) {
                    opts.hoverMessage = decorationOption.hoverMessage;
                }
                newModelDecorations.push({ range: decorationOption.range, options: opts });
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (decorationOptions_1_1 && !decorationOptions_1_1.done && (_a = decorationOptions_1.return)) _a.call(decorationOptions_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        // remove decoration sub types that are no longer used, deregister decoration type if necessary
        for (var subType in oldDecorationsSubTypes) {
            if (!newDecorationsSubTypes[subType]) {
                this._removeDecorationType(decorationTypeKey + '-' + subType);
            }
        }
        // update all decorations
        var oldDecorationsIds = this._decorationTypeKeysToIds[decorationTypeKey] || [];
        this._decorationTypeKeysToIds[decorationTypeKey] = this.deltaDecorations(oldDecorationsIds, newModelDecorations);
    };
    CodeEditorWidget.prototype.setDecorationsFast = function (decorationTypeKey, ranges) {
        // remove decoration sub types that are no longer used, deregister decoration type if necessary
        var oldDecorationsSubTypes = this._decorationTypeSubtypes[decorationTypeKey] || {};
        for (var subType in oldDecorationsSubTypes) {
            this._removeDecorationType(decorationTypeKey + '-' + subType);
        }
        this._decorationTypeSubtypes[decorationTypeKey] = {};
        var opts = ModelDecorationOptions.createDynamic(this._resolveDecorationOptions(decorationTypeKey, false));
        var newModelDecorations = new Array(ranges.length);
        for (var i = 0, len = ranges.length; i < len; i++) {
            newModelDecorations[i] = { range: ranges[i], options: opts };
        }
        // update all decorations
        var oldDecorationsIds = this._decorationTypeKeysToIds[decorationTypeKey] || [];
        this._decorationTypeKeysToIds[decorationTypeKey] = this.deltaDecorations(oldDecorationsIds, newModelDecorations);
    };
    CodeEditorWidget.prototype.removeDecorations = function (decorationTypeKey) {
        // remove decorations for type and sub type
        var oldDecorationsIds = this._decorationTypeKeysToIds[decorationTypeKey];
        if (oldDecorationsIds) {
            this.deltaDecorations(oldDecorationsIds, []);
        }
        if (this._decorationTypeKeysToIds.hasOwnProperty(decorationTypeKey)) {
            delete this._decorationTypeKeysToIds[decorationTypeKey];
        }
        if (this._decorationTypeSubtypes.hasOwnProperty(decorationTypeKey)) {
            delete this._decorationTypeSubtypes[decorationTypeKey];
        }
    };
    CodeEditorWidget.prototype.getLayoutInfo = function () {
        var options = this._configuration.options;
        var layoutInfo = options.get(124 /* layoutInfo */);
        return layoutInfo;
    };
    CodeEditorWidget.prototype.createOverviewRuler = function (cssClassName) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return null;
        }
        return this._modelData.view.createOverviewRuler(cssClassName);
    };
    CodeEditorWidget.prototype.getContainerDomNode = function () {
        return this._domElement;
    };
    CodeEditorWidget.prototype.getDomNode = function () {
        if (!this._modelData || !this._modelData.hasRealView) {
            return null;
        }
        return this._modelData.view.domNode.domNode;
    };
    CodeEditorWidget.prototype.delegateVerticalScrollbarMouseDown = function (browserEvent) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return;
        }
        this._modelData.view.delegateVerticalScrollbarMouseDown(browserEvent);
    };
    CodeEditorWidget.prototype.layout = function (dimension) {
        this._configuration.observeReferenceElement(dimension);
        this.render();
    };
    CodeEditorWidget.prototype.focus = function () {
        if (!this._modelData || !this._modelData.hasRealView) {
            return;
        }
        this._modelData.view.focus();
    };
    CodeEditorWidget.prototype.hasTextFocus = function () {
        if (!this._modelData || !this._modelData.hasRealView) {
            return false;
        }
        return this._modelData.view.isFocused();
    };
    CodeEditorWidget.prototype.hasWidgetFocus = function () {
        return this._focusTracker && this._focusTracker.hasFocus();
    };
    CodeEditorWidget.prototype.addContentWidget = function (widget) {
        var widgetData = {
            widget: widget,
            position: widget.getPosition()
        };
        if (this._contentWidgets.hasOwnProperty(widget.getId())) {
            console.warn('Overwriting a content widget with the same id.');
        }
        this._contentWidgets[widget.getId()] = widgetData;
        if (this._modelData && this._modelData.hasRealView) {
            this._modelData.view.addContentWidget(widgetData);
        }
    };
    CodeEditorWidget.prototype.layoutContentWidget = function (widget) {
        var widgetId = widget.getId();
        if (this._contentWidgets.hasOwnProperty(widgetId)) {
            var widgetData = this._contentWidgets[widgetId];
            widgetData.position = widget.getPosition();
            if (this._modelData && this._modelData.hasRealView) {
                this._modelData.view.layoutContentWidget(widgetData);
            }
        }
    };
    CodeEditorWidget.prototype.removeContentWidget = function (widget) {
        var widgetId = widget.getId();
        if (this._contentWidgets.hasOwnProperty(widgetId)) {
            var widgetData = this._contentWidgets[widgetId];
            delete this._contentWidgets[widgetId];
            if (this._modelData && this._modelData.hasRealView) {
                this._modelData.view.removeContentWidget(widgetData);
            }
        }
    };
    CodeEditorWidget.prototype.addOverlayWidget = function (widget) {
        var widgetData = {
            widget: widget,
            position: widget.getPosition()
        };
        if (this._overlayWidgets.hasOwnProperty(widget.getId())) {
            console.warn('Overwriting an overlay widget with the same id.');
        }
        this._overlayWidgets[widget.getId()] = widgetData;
        if (this._modelData && this._modelData.hasRealView) {
            this._modelData.view.addOverlayWidget(widgetData);
        }
    };
    CodeEditorWidget.prototype.layoutOverlayWidget = function (widget) {
        var widgetId = widget.getId();
        if (this._overlayWidgets.hasOwnProperty(widgetId)) {
            var widgetData = this._overlayWidgets[widgetId];
            widgetData.position = widget.getPosition();
            if (this._modelData && this._modelData.hasRealView) {
                this._modelData.view.layoutOverlayWidget(widgetData);
            }
        }
    };
    CodeEditorWidget.prototype.removeOverlayWidget = function (widget) {
        var widgetId = widget.getId();
        if (this._overlayWidgets.hasOwnProperty(widgetId)) {
            var widgetData = this._overlayWidgets[widgetId];
            delete this._overlayWidgets[widgetId];
            if (this._modelData && this._modelData.hasRealView) {
                this._modelData.view.removeOverlayWidget(widgetData);
            }
        }
    };
    CodeEditorWidget.prototype.changeViewZones = function (callback) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return;
        }
        this._modelData.view.change(callback);
    };
    CodeEditorWidget.prototype.getTargetAtClientPoint = function (clientX, clientY) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return null;
        }
        return this._modelData.view.getTargetAtClientPoint(clientX, clientY);
    };
    CodeEditorWidget.prototype.getScrolledVisiblePosition = function (rawPosition) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return null;
        }
        var position = this._modelData.model.validatePosition(rawPosition);
        var options = this._configuration.options;
        var layoutInfo = options.get(124 /* layoutInfo */);
        var top = CodeEditorWidget._getVerticalOffsetForPosition(this._modelData, position.lineNumber, position.column) - this.getScrollTop();
        var left = this._modelData.view.getOffsetForColumn(position.lineNumber, position.column) + layoutInfo.glyphMarginWidth + layoutInfo.lineNumbersWidth + layoutInfo.decorationsWidth - this.getScrollLeft();
        return {
            top: top,
            left: left,
            height: options.get(53 /* lineHeight */)
        };
    };
    CodeEditorWidget.prototype.getOffsetForColumn = function (lineNumber, column) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return -1;
        }
        return this._modelData.view.getOffsetForColumn(lineNumber, column);
    };
    CodeEditorWidget.prototype.render = function (forceRedraw) {
        if (forceRedraw === void 0) { forceRedraw = false; }
        if (!this._modelData || !this._modelData.hasRealView) {
            return;
        }
        this._modelData.view.render(true, forceRedraw);
    };
    CodeEditorWidget.prototype.setAriaOptions = function (options) {
        if (!this._modelData || !this._modelData.hasRealView) {
            return;
        }
        this._modelData.view.setAriaOptions(options);
    };
    CodeEditorWidget.prototype.applyFontInfo = function (target) {
        Configuration.applyFontInfoSlow(target, this._configuration.options.get(38 /* fontInfo */));
    };
    CodeEditorWidget.prototype._attachModel = function (model) {
        var _this = this;
        if (!model) {
            this._modelData = null;
            return;
        }
        var listenersToRemove = [];
        this._domElement.setAttribute('data-mode-id', model.getLanguageIdentifier().language);
        this._configuration.setIsDominatedByLongLines(model.isDominatedByLongLines());
        this._configuration.setMaxLineNumber(model.getLineCount());
        model.onBeforeAttached();
        var viewModel = new ViewModel(this._id, this._configuration, model, DOMLineBreaksComputerFactory.create(), MonospaceLineBreaksComputerFactory.create(this._configuration.options), function (callback) { return dom.scheduleAtNextAnimationFrame(callback); });
        listenersToRemove.push(model.onDidChangeDecorations(function (e) { return _this._onDidChangeModelDecorations.fire(e); }));
        listenersToRemove.push(model.onDidChangeLanguage(function (e) {
            _this._domElement.setAttribute('data-mode-id', model.getLanguageIdentifier().language);
            _this._onDidChangeModelLanguage.fire(e);
        }));
        listenersToRemove.push(model.onDidChangeLanguageConfiguration(function (e) { return _this._onDidChangeModelLanguageConfiguration.fire(e); }));
        listenersToRemove.push(model.onDidChangeContent(function (e) { return _this._onDidChangeModelContent.fire(e); }));
        listenersToRemove.push(model.onDidChangeOptions(function (e) { return _this._onDidChangeModelOptions.fire(e); }));
        // Someone might destroy the model from under the editor, so prevent any exceptions by setting a null model
        listenersToRemove.push(model.onWillDispose(function () { return _this.setModel(null); }));
        listenersToRemove.push(viewModel.onEvent(function (e) {
            switch (e.kind) {
                case 0 /* ContentSizeChanged */:
                    _this._onDidContentSizeChange.fire(e);
                    break;
                case 1 /* FocusChanged */:
                    _this._editorTextFocus.setValue(e.hasFocus);
                    break;
                case 2 /* ScrollChanged */:
                    _this._onDidScrollChange.fire(e);
                    break;
                case 3 /* ViewZonesChanged */:
                    _this._onDidChangeViewZones.fire();
                    break;
                case 4 /* ReadOnlyEditAttempt */:
                    _this._onDidAttemptReadOnlyEdit.fire();
                    break;
                case 5 /* CursorStateChanged */: {
                    if (e.reachedMaxCursorCount) {
                        _this._notificationService.warn(nls.localize('cursors.maximum', "The number of cursors has been limited to {0}.", Cursor.MAX_CURSOR_COUNT));
                    }
                    var positions = [];
                    for (var i = 0, len = e.selections.length; i < len; i++) {
                        positions[i] = e.selections[i].getPosition();
                    }
                    var e1 = {
                        position: positions[0],
                        secondaryPositions: positions.slice(1),
                        reason: e.reason,
                        source: e.source
                    };
                    _this._onDidChangeCursorPosition.fire(e1);
                    var e2 = {
                        selection: e.selections[0],
                        secondarySelections: e.selections.slice(1),
                        modelVersionId: e.modelVersionId,
                        oldSelections: e.oldSelections,
                        oldModelVersionId: e.oldModelVersionId,
                        source: e.source,
                        reason: e.reason
                    };
                    _this._onDidChangeCursorSelection.fire(e2);
                    break;
                }
            }
        }));
        var _a = __read(this._createView(viewModel), 2), view = _a[0], hasRealView = _a[1];
        if (hasRealView) {
            this._domElement.appendChild(view.domNode.domNode);
            var keys = Object.keys(this._contentWidgets);
            for (var i = 0, len = keys.length; i < len; i++) {
                var widgetId = keys[i];
                view.addContentWidget(this._contentWidgets[widgetId]);
            }
            keys = Object.keys(this._overlayWidgets);
            for (var i = 0, len = keys.length; i < len; i++) {
                var widgetId = keys[i];
                view.addOverlayWidget(this._overlayWidgets[widgetId]);
            }
            view.render(false, true);
            view.domNode.domNode.setAttribute('data-uri', model.uri.toString());
        }
        this._modelData = new ModelData(model, viewModel, view, hasRealView, listenersToRemove);
    };
    CodeEditorWidget.prototype._createView = function (viewModel) {
        var _this = this;
        var commandDelegate;
        if (this.isSimpleWidget) {
            commandDelegate = {
                paste: function (text, pasteOnNewLine, multicursorText, mode) {
                    _this._paste('keyboard', text, pasteOnNewLine, multicursorText, mode);
                },
                type: function (text) {
                    _this._type('keyboard', text);
                },
                compositionType: function (text, replacePrevCharCnt, replaceNextCharCnt, positionDelta) {
                    _this._compositionType('keyboard', text, replacePrevCharCnt, replaceNextCharCnt, positionDelta);
                },
                startComposition: function () {
                    _this._startComposition();
                },
                endComposition: function () {
                    _this._endComposition('keyboard');
                },
                cut: function () {
                    _this._cut('keyboard');
                }
            };
        }
        else {
            commandDelegate = {
                paste: function (text, pasteOnNewLine, multicursorText, mode) {
                    var payload = { text: text, pasteOnNewLine: pasteOnNewLine, multicursorText: multicursorText, mode: mode };
                    _this._commandService.executeCommand("paste" /* Paste */, payload);
                },
                type: function (text) {
                    var payload = { text: text };
                    _this._commandService.executeCommand("type" /* Type */, payload);
                },
                compositionType: function (text, replacePrevCharCnt, replaceNextCharCnt, positionDelta) {
                    // Try if possible to go through the existing `replacePreviousChar` command
                    if (replaceNextCharCnt || positionDelta) {
                        // must be handled through the new command
                        var payload = { text: text, replacePrevCharCnt: replacePrevCharCnt, replaceNextCharCnt: replaceNextCharCnt, positionDelta: positionDelta };
                        _this._commandService.executeCommand("compositionType" /* CompositionType */, payload);
                    }
                    else {
                        var payload = { text: text, replaceCharCnt: replacePrevCharCnt };
                        _this._commandService.executeCommand("replacePreviousChar" /* ReplacePreviousChar */, payload);
                    }
                },
                startComposition: function () {
                    _this._commandService.executeCommand("compositionStart" /* CompositionStart */, {});
                },
                endComposition: function () {
                    _this._commandService.executeCommand("compositionEnd" /* CompositionEnd */, {});
                },
                cut: function () {
                    _this._commandService.executeCommand("cut" /* Cut */, {});
                }
            };
        }
        var viewUserInputEvents = new ViewUserInputEvents(viewModel.coordinatesConverter);
        viewUserInputEvents.onKeyDown = function (e) { return _this._onKeyDown.fire(e); };
        viewUserInputEvents.onKeyUp = function (e) { return _this._onKeyUp.fire(e); };
        viewUserInputEvents.onContextMenu = function (e) { return _this._onContextMenu.fire(e); };
        viewUserInputEvents.onMouseMove = function (e) { return _this._onMouseMove.fire(e); };
        viewUserInputEvents.onMouseLeave = function (e) { return _this._onMouseLeave.fire(e); };
        viewUserInputEvents.onMouseDown = function (e) { return _this._onMouseDown.fire(e); };
        viewUserInputEvents.onMouseUp = function (e) { return _this._onMouseUp.fire(e); };
        viewUserInputEvents.onMouseDrag = function (e) { return _this._onMouseDrag.fire(e); };
        viewUserInputEvents.onMouseDrop = function (e) { return _this._onMouseDrop.fire(e); };
        viewUserInputEvents.onMouseDropCanceled = function (e) { return _this._onMouseDropCanceled.fire(e); };
        viewUserInputEvents.onMouseWheel = function (e) { return _this._onMouseWheel.fire(e); };
        var view = new View(commandDelegate, this._configuration, this._themeService, viewModel, viewUserInputEvents, this._overflowWidgetsDomNode);
        return [view, true];
    };
    CodeEditorWidget.prototype._postDetachModelCleanup = function (detachedModel) {
        if (detachedModel) {
            detachedModel.removeAllDecorationsWithOwnerId(this._id);
        }
    };
    CodeEditorWidget.prototype._detachModel = function () {
        if (!this._modelData) {
            return null;
        }
        var model = this._modelData.model;
        var removeDomNode = this._modelData.hasRealView ? this._modelData.view.domNode.domNode : null;
        this._modelData.dispose();
        this._modelData = null;
        this._domElement.removeAttribute('data-mode-id');
        if (removeDomNode && this._domElement.contains(removeDomNode)) {
            this._domElement.removeChild(removeDomNode);
        }
        return model;
    };
    CodeEditorWidget.prototype._registerDecorationType = function (key, options, parentTypeKey) {
        this._codeEditorService.registerDecorationType(key, options, parentTypeKey, this);
    };
    CodeEditorWidget.prototype._removeDecorationType = function (key) {
        this._codeEditorService.removeDecorationType(key);
    };
    CodeEditorWidget.prototype._resolveDecorationOptions = function (typeKey, writable) {
        return this._codeEditorService.resolveDecorationOptions(typeKey, writable);
    };
    CodeEditorWidget.prototype.getTelemetryData = function () {
        return this._telemetryData;
    };
    CodeEditorWidget.prototype.hasModel = function () {
        return (this._modelData !== null);
    };
    CodeEditorWidget = __decorate([
        __param(3, IInstantiationService),
        __param(4, ICodeEditorService),
        __param(5, ICommandService),
        __param(6, IContextKeyService),
        __param(7, IThemeService),
        __param(8, INotificationService),
        __param(9, IAccessibilityService)
    ], CodeEditorWidget);
    return CodeEditorWidget;
}(Disposable));
export { CodeEditorWidget };
var BooleanEventEmitter = /** @class */ (function (_super) {
    __extends(BooleanEventEmitter, _super);
    function BooleanEventEmitter() {
        var _this = _super.call(this) || this;
        _this._onDidChangeToTrue = _this._register(new Emitter());
        _this.onDidChangeToTrue = _this._onDidChangeToTrue.event;
        _this._onDidChangeToFalse = _this._register(new Emitter());
        _this.onDidChangeToFalse = _this._onDidChangeToFalse.event;
        _this._value = 0 /* NotSet */;
        return _this;
    }
    BooleanEventEmitter.prototype.setValue = function (_value) {
        var value = (_value ? 2 /* True */ : 1 /* False */);
        if (this._value === value) {
            return;
        }
        this._value = value;
        if (this._value === 2 /* True */) {
            this._onDidChangeToTrue.fire();
        }
        else if (this._value === 1 /* False */) {
            this._onDidChangeToFalse.fire();
        }
    };
    return BooleanEventEmitter;
}(Disposable));
export { BooleanEventEmitter };
var EditorContextKeysManager = /** @class */ (function (_super) {
    __extends(EditorContextKeysManager, _super);
    function EditorContextKeysManager(editor, contextKeyService) {
        var _this = _super.call(this) || this;
        _this._editor = editor;
        contextKeyService.createKey('editorId', editor.getId());
        _this._editorSimpleInput = EditorContextKeys.editorSimpleInput.bindTo(contextKeyService);
        _this._editorFocus = EditorContextKeys.focus.bindTo(contextKeyService);
        _this._textInputFocus = EditorContextKeys.textInputFocus.bindTo(contextKeyService);
        _this._editorTextFocus = EditorContextKeys.editorTextFocus.bindTo(contextKeyService);
        _this._editorTabMovesFocus = EditorContextKeys.tabMovesFocus.bindTo(contextKeyService);
        _this._editorReadonly = EditorContextKeys.readOnly.bindTo(contextKeyService);
        _this._inDiffEditor = EditorContextKeys.inDiffEditor.bindTo(contextKeyService);
        _this._editorColumnSelection = EditorContextKeys.columnSelection.bindTo(contextKeyService);
        _this._hasMultipleSelections = EditorContextKeys.hasMultipleSelections.bindTo(contextKeyService);
        _this._hasNonEmptySelection = EditorContextKeys.hasNonEmptySelection.bindTo(contextKeyService);
        _this._canUndo = EditorContextKeys.canUndo.bindTo(contextKeyService);
        _this._canRedo = EditorContextKeys.canRedo.bindTo(contextKeyService);
        _this._register(_this._editor.onDidChangeConfiguration(function () { return _this._updateFromConfig(); }));
        _this._register(_this._editor.onDidChangeCursorSelection(function () { return _this._updateFromSelection(); }));
        _this._register(_this._editor.onDidFocusEditorWidget(function () { return _this._updateFromFocus(); }));
        _this._register(_this._editor.onDidBlurEditorWidget(function () { return _this._updateFromFocus(); }));
        _this._register(_this._editor.onDidFocusEditorText(function () { return _this._updateFromFocus(); }));
        _this._register(_this._editor.onDidBlurEditorText(function () { return _this._updateFromFocus(); }));
        _this._register(_this._editor.onDidChangeModel(function () { return _this._updateFromModel(); }));
        _this._register(_this._editor.onDidChangeConfiguration(function () { return _this._updateFromModel(); }));
        _this._updateFromConfig();
        _this._updateFromSelection();
        _this._updateFromFocus();
        _this._updateFromModel();
        _this._editorSimpleInput.set(_this._editor.isSimpleWidget);
        return _this;
    }
    EditorContextKeysManager.prototype._updateFromConfig = function () {
        var options = this._editor.getOptions();
        this._editorTabMovesFocus.set(options.get(123 /* tabFocusMode */));
        this._editorReadonly.set(options.get(75 /* readOnly */));
        this._inDiffEditor.set(options.get(49 /* inDiffEditor */));
        this._editorColumnSelection.set(options.get(15 /* columnSelection */));
    };
    EditorContextKeysManager.prototype._updateFromSelection = function () {
        var selections = this._editor.getSelections();
        if (!selections) {
            this._hasMultipleSelections.reset();
            this._hasNonEmptySelection.reset();
        }
        else {
            this._hasMultipleSelections.set(selections.length > 1);
            this._hasNonEmptySelection.set(selections.some(function (s) { return !s.isEmpty(); }));
        }
    };
    EditorContextKeysManager.prototype._updateFromFocus = function () {
        this._editorFocus.set(this._editor.hasWidgetFocus() && !this._editor.isSimpleWidget);
        this._editorTextFocus.set(this._editor.hasTextFocus() && !this._editor.isSimpleWidget);
        this._textInputFocus.set(this._editor.hasTextFocus());
    };
    EditorContextKeysManager.prototype._updateFromModel = function () {
        var model = this._editor.getModel();
        this._canUndo.set(Boolean(model && model.canUndo()));
        this._canRedo.set(Boolean(model && model.canRedo()));
    };
    return EditorContextKeysManager;
}(Disposable));
var EditorModeContext = /** @class */ (function (_super) {
    __extends(EditorModeContext, _super);
    function EditorModeContext(_editor, _contextKeyService) {
        var _this = _super.call(this) || this;
        _this._editor = _editor;
        _this._contextKeyService = _contextKeyService;
        _this._langId = EditorContextKeys.languageId.bindTo(_contextKeyService);
        _this._hasCompletionItemProvider = EditorContextKeys.hasCompletionItemProvider.bindTo(_contextKeyService);
        _this._hasCodeActionsProvider = EditorContextKeys.hasCodeActionsProvider.bindTo(_contextKeyService);
        _this._hasCodeLensProvider = EditorContextKeys.hasCodeLensProvider.bindTo(_contextKeyService);
        _this._hasDefinitionProvider = EditorContextKeys.hasDefinitionProvider.bindTo(_contextKeyService);
        _this._hasDeclarationProvider = EditorContextKeys.hasDeclarationProvider.bindTo(_contextKeyService);
        _this._hasImplementationProvider = EditorContextKeys.hasImplementationProvider.bindTo(_contextKeyService);
        _this._hasTypeDefinitionProvider = EditorContextKeys.hasTypeDefinitionProvider.bindTo(_contextKeyService);
        _this._hasHoverProvider = EditorContextKeys.hasHoverProvider.bindTo(_contextKeyService);
        _this._hasDocumentHighlightProvider = EditorContextKeys.hasDocumentHighlightProvider.bindTo(_contextKeyService);
        _this._hasDocumentSymbolProvider = EditorContextKeys.hasDocumentSymbolProvider.bindTo(_contextKeyService);
        _this._hasReferenceProvider = EditorContextKeys.hasReferenceProvider.bindTo(_contextKeyService);
        _this._hasRenameProvider = EditorContextKeys.hasRenameProvider.bindTo(_contextKeyService);
        _this._hasSignatureHelpProvider = EditorContextKeys.hasSignatureHelpProvider.bindTo(_contextKeyService);
        _this._hasInlineHintsProvider = EditorContextKeys.hasInlineHintsProvider.bindTo(_contextKeyService);
        _this._hasDocumentFormattingProvider = EditorContextKeys.hasDocumentFormattingProvider.bindTo(_contextKeyService);
        _this._hasDocumentSelectionFormattingProvider = EditorContextKeys.hasDocumentSelectionFormattingProvider.bindTo(_contextKeyService);
        _this._hasMultipleDocumentFormattingProvider = EditorContextKeys.hasMultipleDocumentFormattingProvider.bindTo(_contextKeyService);
        _this._hasMultipleDocumentSelectionFormattingProvider = EditorContextKeys.hasMultipleDocumentSelectionFormattingProvider.bindTo(_contextKeyService);
        _this._isInWalkThrough = EditorContextKeys.isInWalkThroughSnippet.bindTo(_contextKeyService);
        var update = function () { return _this._update(); };
        // update when model/mode changes
        _this._register(_editor.onDidChangeModel(update));
        _this._register(_editor.onDidChangeModelLanguage(update));
        // update when registries change
        _this._register(modes.CompletionProviderRegistry.onDidChange(update));
        _this._register(modes.CodeActionProviderRegistry.onDidChange(update));
        _this._register(modes.CodeLensProviderRegistry.onDidChange(update));
        _this._register(modes.DefinitionProviderRegistry.onDidChange(update));
        _this._register(modes.DeclarationProviderRegistry.onDidChange(update));
        _this._register(modes.ImplementationProviderRegistry.onDidChange(update));
        _this._register(modes.TypeDefinitionProviderRegistry.onDidChange(update));
        _this._register(modes.HoverProviderRegistry.onDidChange(update));
        _this._register(modes.DocumentHighlightProviderRegistry.onDidChange(update));
        _this._register(modes.DocumentSymbolProviderRegistry.onDidChange(update));
        _this._register(modes.ReferenceProviderRegistry.onDidChange(update));
        _this._register(modes.RenameProviderRegistry.onDidChange(update));
        _this._register(modes.DocumentFormattingEditProviderRegistry.onDidChange(update));
        _this._register(modes.DocumentRangeFormattingEditProviderRegistry.onDidChange(update));
        _this._register(modes.SignatureHelpProviderRegistry.onDidChange(update));
        _this._register(modes.InlineHintsProviderRegistry.onDidChange(update));
        update();
        return _this;
    }
    EditorModeContext.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
    };
    EditorModeContext.prototype.reset = function () {
        var _this = this;
        this._contextKeyService.bufferChangeEvents(function () {
            _this._langId.reset();
            _this._hasCompletionItemProvider.reset();
            _this._hasCodeActionsProvider.reset();
            _this._hasCodeLensProvider.reset();
            _this._hasDefinitionProvider.reset();
            _this._hasDeclarationProvider.reset();
            _this._hasImplementationProvider.reset();
            _this._hasTypeDefinitionProvider.reset();
            _this._hasHoverProvider.reset();
            _this._hasDocumentHighlightProvider.reset();
            _this._hasDocumentSymbolProvider.reset();
            _this._hasReferenceProvider.reset();
            _this._hasRenameProvider.reset();
            _this._hasDocumentFormattingProvider.reset();
            _this._hasDocumentSelectionFormattingProvider.reset();
            _this._hasSignatureHelpProvider.reset();
            _this._isInWalkThrough.reset();
        });
    };
    EditorModeContext.prototype._update = function () {
        var _this = this;
        var model = this._editor.getModel();
        if (!model) {
            this.reset();
            return;
        }
        this._contextKeyService.bufferChangeEvents(function () {
            _this._langId.set(model.getLanguageIdentifier().language);
            _this._hasCompletionItemProvider.set(modes.CompletionProviderRegistry.has(model));
            _this._hasCodeActionsProvider.set(modes.CodeActionProviderRegistry.has(model));
            _this._hasCodeLensProvider.set(modes.CodeLensProviderRegistry.has(model));
            _this._hasDefinitionProvider.set(modes.DefinitionProviderRegistry.has(model));
            _this._hasDeclarationProvider.set(modes.DeclarationProviderRegistry.has(model));
            _this._hasImplementationProvider.set(modes.ImplementationProviderRegistry.has(model));
            _this._hasTypeDefinitionProvider.set(modes.TypeDefinitionProviderRegistry.has(model));
            _this._hasHoverProvider.set(modes.HoverProviderRegistry.has(model));
            _this._hasDocumentHighlightProvider.set(modes.DocumentHighlightProviderRegistry.has(model));
            _this._hasDocumentSymbolProvider.set(modes.DocumentSymbolProviderRegistry.has(model));
            _this._hasReferenceProvider.set(modes.ReferenceProviderRegistry.has(model));
            _this._hasRenameProvider.set(modes.RenameProviderRegistry.has(model));
            _this._hasSignatureHelpProvider.set(modes.SignatureHelpProviderRegistry.has(model));
            _this._hasInlineHintsProvider.set(modes.InlineHintsProviderRegistry.has(model));
            _this._hasDocumentFormattingProvider.set(modes.DocumentFormattingEditProviderRegistry.has(model) || modes.DocumentRangeFormattingEditProviderRegistry.has(model));
            _this._hasDocumentSelectionFormattingProvider.set(modes.DocumentRangeFormattingEditProviderRegistry.has(model));
            _this._hasMultipleDocumentFormattingProvider.set(modes.DocumentFormattingEditProviderRegistry.all(model).length + modes.DocumentRangeFormattingEditProviderRegistry.all(model).length > 1);
            _this._hasMultipleDocumentSelectionFormattingProvider.set(modes.DocumentRangeFormattingEditProviderRegistry.all(model).length > 1);
            _this._isInWalkThrough.set(model.uri.scheme === Schemas.walkThroughSnippet);
        });
    };
    return EditorModeContext;
}(Disposable));
export { EditorModeContext };
var CodeEditorWidgetFocusTracker = /** @class */ (function (_super) {
    __extends(CodeEditorWidgetFocusTracker, _super);
    function CodeEditorWidgetFocusTracker(domElement) {
        var _this = _super.call(this) || this;
        _this._onChange = _this._register(new Emitter());
        _this.onChange = _this._onChange.event;
        _this._hasFocus = false;
        _this._domFocusTracker = _this._register(dom.trackFocus(domElement));
        _this._register(_this._domFocusTracker.onDidFocus(function () {
            _this._hasFocus = true;
            _this._onChange.fire(undefined);
        }));
        _this._register(_this._domFocusTracker.onDidBlur(function () {
            _this._hasFocus = false;
            _this._onChange.fire(undefined);
        }));
        return _this;
    }
    CodeEditorWidgetFocusTracker.prototype.hasFocus = function () {
        return this._hasFocus;
    };
    CodeEditorWidgetFocusTracker.prototype.refreshState = function () {
        if (this._domFocusTracker.refreshState) {
            this._domFocusTracker.refreshState();
        }
    };
    return CodeEditorWidgetFocusTracker;
}(Disposable));
var squigglyStart = encodeURIComponent("<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 6 3' enable-background='new 0 0 6 3' height='3' width='6'><g fill='");
var squigglyEnd = encodeURIComponent("'><polygon points='5.5,0 2.5,3 1.1,3 4.1,0'/><polygon points='4,0 6,2 6,0.6 5.4,0'/><polygon points='0,2 1,3 2.4,3 0,0.6'/></g></svg>");
function getSquigglySVGData(color) {
    return squigglyStart + encodeURIComponent(color.toString()) + squigglyEnd;
}
var dotdotdotStart = encodeURIComponent("<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"3\" width=\"12\"><g fill=\"");
var dotdotdotEnd = encodeURIComponent("\"><circle cx=\"1\" cy=\"1\" r=\"1\"/><circle cx=\"5\" cy=\"1\" r=\"1\"/><circle cx=\"9\" cy=\"1\" r=\"1\"/></g></svg>");
function getDotDotDotSVGData(color) {
    return dotdotdotStart + encodeURIComponent(color.toString()) + dotdotdotEnd;
}
registerThemingParticipant(function (theme, collector) {
    var errorBorderColor = theme.getColor(editorErrorBorder);
    if (errorBorderColor) {
        collector.addRule(".monaco-editor ." + "squiggly-error" /* EditorErrorDecoration */ + " { border-bottom: 4px double " + errorBorderColor + "; }");
    }
    var errorForeground = theme.getColor(editorErrorForeground);
    if (errorForeground) {
        collector.addRule(".monaco-editor ." + "squiggly-error" /* EditorErrorDecoration */ + " { background: url(\"data:image/svg+xml," + getSquigglySVGData(errorForeground) + "\") repeat-x bottom left; }");
    }
    var errorBackground = theme.getColor(editorErrorBackground);
    if (errorBackground) {
        collector.addRule(".monaco-editor ." + "squiggly-error" /* EditorErrorDecoration */ + "::before { display: block; content: ''; width: 100%; height: 100%; background: " + errorBackground + "; }");
    }
    var warningBorderColor = theme.getColor(editorWarningBorder);
    if (warningBorderColor) {
        collector.addRule(".monaco-editor ." + "squiggly-warning" /* EditorWarningDecoration */ + " { border-bottom: 4px double " + warningBorderColor + "; }");
    }
    var warningForeground = theme.getColor(editorWarningForeground);
    if (warningForeground) {
        collector.addRule(".monaco-editor ." + "squiggly-warning" /* EditorWarningDecoration */ + " { background: url(\"data:image/svg+xml," + getSquigglySVGData(warningForeground) + "\") repeat-x bottom left; }");
    }
    var warningBackground = theme.getColor(editorWarningBackground);
    if (warningBackground) {
        collector.addRule(".monaco-editor ." + "squiggly-warning" /* EditorWarningDecoration */ + "::before { display: block; content: ''; width: 100%; height: 100%; background: " + warningBackground + "; }");
    }
    var infoBorderColor = theme.getColor(editorInfoBorder);
    if (infoBorderColor) {
        collector.addRule(".monaco-editor ." + "squiggly-info" /* EditorInfoDecoration */ + " { border-bottom: 4px double " + infoBorderColor + "; }");
    }
    var infoForeground = theme.getColor(editorInfoForeground);
    if (infoForeground) {
        collector.addRule(".monaco-editor ." + "squiggly-info" /* EditorInfoDecoration */ + " { background: url(\"data:image/svg+xml," + getSquigglySVGData(infoForeground) + "\") repeat-x bottom left; }");
    }
    var infoBackground = theme.getColor(editorInfoBackground);
    if (infoBackground) {
        collector.addRule(".monaco-editor ." + "squiggly-info" /* EditorInfoDecoration */ + "::before { display: block; content: ''; width: 100%; height: 100%; background: " + infoBackground + "; }");
    }
    var hintBorderColor = theme.getColor(editorHintBorder);
    if (hintBorderColor) {
        collector.addRule(".monaco-editor ." + "squiggly-hint" /* EditorHintDecoration */ + " { border-bottom: 2px dotted " + hintBorderColor + "; }");
    }
    var hintForeground = theme.getColor(editorHintForeground);
    if (hintForeground) {
        collector.addRule(".monaco-editor ." + "squiggly-hint" /* EditorHintDecoration */ + " { background: url(\"data:image/svg+xml," + getDotDotDotSVGData(hintForeground) + "\") no-repeat bottom left; }");
    }
    var unnecessaryForeground = theme.getColor(editorUnnecessaryCodeOpacity);
    if (unnecessaryForeground) {
        collector.addRule(".monaco-editor.showUnused ." + "squiggly-inline-unnecessary" /* EditorUnnecessaryInlineDecoration */ + " { opacity: " + unnecessaryForeground.rgba.a + "; }");
    }
    var unnecessaryBorder = theme.getColor(editorUnnecessaryCodeBorder);
    if (unnecessaryBorder) {
        collector.addRule(".monaco-editor.showUnused ." + "squiggly-unnecessary" /* EditorUnnecessaryDecoration */ + " { border-bottom: 2px dashed " + unnecessaryBorder + "; }");
    }
    var deprecatedForeground = theme.getColor(editorForeground) || 'inherit';
    collector.addRule(".monaco-editor.showDeprecated ." + "squiggly-inline-deprecated" /* EditorDeprecatedInlineDecoration */ + " { text-decoration: line-through; text-decoration-color: " + deprecatedForeground + "}");
});
