/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.google.gson.Gson;
import com.microsoft.java.test.plugin.model.SearchTestItemParams;
import com.microsoft.java.test.plugin.model.TestItem;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.util.ProjectTestUtils;
import com.microsoft.java.test.plugin.util.TestFrameworkUtils;
import com.microsoft.java.test.plugin.util.TestItemUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.Location;

public class TestSearchUtils {
    public static List<TestItem> searchCodeLens(List<Object> arguments, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException, JavaModelException {
        LinkedList<TestItem> resultList = new LinkedList<TestItem>();
        if (arguments == null || arguments.size() == 0) {
            return resultList;
        }
        String uri = (String)arguments.get(0);
        Job.getJobManager().join((Object)"DocumentLifeCycleJobs", monitor);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uri);
        IType primaryType = unit.findPrimaryType();
        if (!TestSearchUtils.isJavaElementExist((IJavaElement)unit) || primaryType == null || monitor.isCanceled()) {
            return resultList;
        }
        CompilationUnit root = (CompilationUnit)TestSearchUtils.parseToAst(unit, monitor);
        if (root == null) {
            return resultList;
        }
        ASTNode node = root.findDeclaringNode(primaryType.getKey());
        if (!(node instanceof TypeDeclaration)) {
            return resultList;
        }
        ITypeBinding binding = ((TypeDeclaration)node).resolveBinding();
        if (binding == null) {
            return resultList;
        }
        TestFrameworkUtils.findTestItemsInTypeBinding(binding, resultList, null, monitor);
        return resultList;
    }

    public static ASTNode parseToAst(ICompilationUnit unit, IProgressMonitor monitor) {
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
        if (astRoot != null) {
            return astRoot;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ASTParser parser = ASTParser.newParser((int)14);
        parser.setSource(unit);
        parser.setFocalPosition(0);
        parser.setResolveBindings(true);
        parser.setIgnoreMethodBodies(true);
        return parser.createAST(monitor);
    }

    public static List<TestItem> searchTestItems(List<Object> arguments, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException, URISyntaxException, JavaModelException {
        LinkedList<TestItem> resultList = new LinkedList<TestItem>();
        if (arguments == null || arguments.size() == 0) {
            return resultList;
        }
        Gson gson = new Gson();
        SearchTestItemParams params = (SearchTestItemParams)gson.fromJson((String)arguments.get(0), SearchTestItemParams.class);
        switch (params.getLevel()) {
            case FOLDER: {
                TestSearchUtils.searchInFolder(resultList, params);
                break;
            }
            case PACKAGE: {
                TestSearchUtils.searchInPackage(resultList, params);
                break;
            }
            case CLASS: {
                TestSearchUtils.searchInClass(resultList, params);
                break;
            }
        }
        return resultList;
    }

    public static List<TestItem> searchAllTestItems(List<Object> arguments, IProgressMonitor monitor) throws CoreException, InterruptedException, URISyntaxException {
        if (arguments == null || arguments.size() == 0) {
            return Collections.emptyList();
        }
        Gson gson = new Gson();
        SearchTestItemParams params = (SearchTestItemParams)gson.fromJson((String)arguments.get(0), SearchTestItemParams.class);
        final IJavaSearchScope scope = TestSearchUtils.createSearchScope(params);
        SearchPattern pattern = TestFrameworkUtils.FRAMEWORK_SEARCHERS[0].getSearchPattern();
        int i = 1;
        while (i < TestFrameworkUtils.FRAMEWORK_SEARCHERS.length) {
            pattern = SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)TestFrameworkUtils.FRAMEWORK_SEARCHERS[i].getSearchPattern());
            ++i;
        }
        final HashMap classMap = new HashMap();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    if (!scope.encloses((IJavaElement)method)) {
                        return;
                    }
                    TestItem methodItem = TestFrameworkUtils.resolveTestItemForMethod(method);
                    if (methodItem == null) {
                        return;
                    }
                    IType type = (IType)method.getParent();
                    TestItem classItem = (TestItem)classMap.get(type.getFullyQualifiedName());
                    if (classItem != null) {
                        classItem.addChild(methodItem.getId());
                    } else {
                        TestItem newClassItem = TestItemUtils.constructTestItem((IJavaElement)type, TestLevel.CLASS, methodItem.getKind());
                        newClassItem.addChild(methodItem.getId());
                        classMap.put(type.getFullyQualifiedName(), newClassItem);
                    }
                } else if (element instanceof IType) {
                    IType type = (IType)element;
                    if (classMap.containsKey(type.getFullyQualifiedName())) {
                        return;
                    }
                    TestItem item = TestFrameworkUtils.resolveTestItemForClass(type);
                    if (item == null) {
                        return;
                    }
                    classMap.put(type.getFullyQualifiedName(), item);
                }
            }
        };
        try {
            new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
        return new ArrayList<TestItem>(classMap.values());
    }

    public static List<Location> searchLocation(List<Object> arguments, IProgressMonitor monitor) throws CoreException {
        final LinkedList<Location> searchResult = new LinkedList<Location>();
        if (arguments == null || arguments.size() == 0) {
            throw new IllegalArgumentException("Invalid arguments to search the location.");
        }
        String searchString = ((String)arguments.get(0)).replaceAll("[$#]", ".");
        int searchFor = 1;
        if (searchString.endsWith("<TestError>")) {
            searchString = searchString.substring(0, searchString.indexOf("<TestError>") - 1);
            searchFor = 5;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)searchString, (int)searchFor, (int)0, (int)2);
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)1);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IMethod || element instanceof IType) {
                    IJavaElement javaElement = (IJavaElement)element;
                    searchResult.add(new Location(JDTUtils.getFileURI((IResource)javaElement.getResource()), TestItemUtils.parseTestItemRange(javaElement)));
                }
            }
        };
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
        return searchResult;
    }

    private static boolean isInTestScope(IJavaElement element) throws JavaModelException {
        IJavaProject project = element.getJavaProject();
        IPath[] iPathArray = ProjectUtils.listSourcePaths((IJavaProject)project);
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sourcePath = iPathArray[n2];
            if (ProjectTestUtils.isTest(project, sourcePath) && sourcePath.isPrefixOf(element.getPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IJavaSearchScope createSearchScope(SearchTestItemParams params) throws JavaModelException, URISyntaxException {
        switch (params.getLevel()) {
            case ROOT: {
                IJavaProject[] projects = (IJavaProject[])Stream.of(ProjectUtils.getJavaProjects()).filter(javaProject -> !"jdt.ls-java-project".equals(javaProject.getProject().getName())).toArray(IJavaProject[]::new);
                return SearchEngine.createJavaSearchScope((IJavaElement[])projects, (int)1);
            }
            case FOLDER: {
                Set<IJavaProject> projectSet = ProjectTestUtils.parseProjects(params.getUri());
                return SearchEngine.createJavaSearchScope((IJavaElement[])projectSet.toArray(new IJavaElement[projectSet.size()]), (int)1);
            }
            case PACKAGE: {
                IPackageFragment packageElement = TestSearchUtils.resolvePackage(params.getUri(), params.getFullName());
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{packageElement}, (int)1);
            }
            case CLASS: {
                IType[] types;
                ICompilationUnit compilationUnit = JDTUtils.resolveCompilationUnit((String)params.getUri());
                IType[] iTypeArray = types = compilationUnit.getAllTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (type.getFullyQualifiedName().equals(params.getFullName())) {
                        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{type}, (int)1);
                    }
                    ++n2;
                }
                break;
            }
            case METHOD: {
                IType[] allTypes;
                String fullName = params.getFullName();
                String className = fullName.substring(0, fullName.lastIndexOf("#"));
                String methodName = fullName.substring(fullName.lastIndexOf("#") + 1);
                ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)params.getUri());
                IType[] iTypeArray = allTypes = unit.getAllTypes();
                int n = allTypes.length;
                int n3 = 0;
                while (n3 < n) {
                    IType type = iTypeArray[n3];
                    if (type.getFullyQualifiedName().equals(className)) {
                        IMethod[] iMethodArray = type.getMethods();
                        int n4 = iMethodArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            IMethod method = iMethodArray[n5];
                            if (method.getElementName().equals(methodName)) {
                                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{method}, (int)1);
                            }
                            ++n5;
                        }
                    }
                    ++n3;
                }
                break;
            }
        }
        throw new RuntimeException("Cannot resolve the search scope for " + params.getFullName());
    }

    private static void searchInFolder(List<TestItem> resultList, SearchTestItemParams params) throws URISyntaxException, JavaModelException {
        Set<IJavaProject> projectSet = ProjectTestUtils.parseProjects(params.getUri());
        for (IJavaProject project : projectSet) {
            IPackageFragment[] iPackageFragmentArray = project.getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment packageFragment = iPackageFragmentArray[n2];
                if (TestSearchUtils.isInTestScope((IJavaElement)packageFragment) && packageFragment.getCompilationUnits().length > 0) {
                    resultList.add(TestItemUtils.constructTestItem((IJavaElement)packageFragment, TestLevel.PACKAGE));
                }
                ++n2;
            }
        }
    }

    private static void searchInPackage(List<TestItem> resultList, SearchTestItemParams params) throws JavaModelException {
        IPackageFragment packageFragment = TestSearchUtils.resolvePackage(params.getUri(), params.getFullName());
        if (packageFragment == null) {
            return;
        }
        ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            IType[] iTypeArray = unit.getTypes();
            int n3 = iTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IType type = iTypeArray[n4];
                resultList.add(TestItemUtils.constructTestItem((IJavaElement)type, TestLevel.CLASS));
                ++n4;
            }
            ++n2;
        }
    }

    private static IPackageFragment resolvePackage(String uriString, String fullName) throws JavaModelException {
        if ("<Default Package>".equals(fullName)) {
            IFolder resource = (IFolder)JDTUtils.findResource((URI)JDTUtils.toURI((String)uriString), arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findContainersForLocationURI(arg_0));
            IJavaElement element = JavaCore.create((IFolder)resource);
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)element;
                IJavaElement[] iJavaElementArray = packageRoot.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    if (child instanceof IPackageFragment && ((IPackageFragment)child).isDefaultPackage()) {
                        return (IPackageFragment)child;
                    }
                    ++n2;
                }
            }
        } else {
            return JDTUtils.resolvePackage((String)uriString);
        }
        return null;
    }

    private static void searchInClass(List<TestItem> resultList, SearchTestItemParams params) throws JavaModelException {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)params.getUri());
        IType[] iTypeArray = unit.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getFullyQualifiedName().equals(params.getFullName())) {
                IType[] iTypeArray2 = type.getTypes();
                int n3 = iTypeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType innerType = iTypeArray2[n4];
                    resultList.add(TestItemUtils.constructTestItem((IJavaElement)innerType, TestLevel.CLASS));
                    ++n4;
                }
                if (TestSearchUtils.isTestableClass(type)) {
                    iTypeArray2 = type.getMethods();
                    n3 = iTypeArray2.length;
                    n4 = 0;
                    while (n4 < n3) {
                        IType method = iTypeArray2[n4];
                        TestItem item = TestFrameworkUtils.resolveTestItemForMethod((IMethod)method);
                        if (item != null) {
                            resultList.add(item);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean isTestableClass(IType type) throws JavaModelException {
        int flags = type.getFlags();
        if (Flags.isInterface((int)flags) || Flags.isAbstract((int)flags)) {
            return false;
        }
        IJavaElement parent = type.getParent();
        if (parent instanceof ITypeRoot) {
            return true;
        }
        if (!(parent instanceof IType)) {
            return false;
        }
        return TestSearchUtils.isJunit5TestableClass(type);
    }

    private static boolean isJunit5TestableClass(IType type) throws JavaModelException {
        int flags = type.getFlags();
        if (TestFrameworkUtils.hasAnnotation((IMember)type, "org.junit.platform.commons.annotation.Testable", true)) {
            return true;
        }
        if (TestFrameworkUtils.hasAnnotation((IMember)type, "org.junit.jupiter.api.Nested", true) || Flags.isStatic((int)flags) && Flags.isPublic((int)flags)) {
            return true;
        }
        IJavaElement[] iJavaElementArray = type.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof IType && TestSearchUtils.isJunit5TestableClass((IType)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isJavaElementExist(IJavaElement element) {
        return element != null && element.getResource() != null && element.getResource().exists();
    }
}

