/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;

public class JSONUtility {
    public static <T> T toModel(Object object, Class<T> clazz) {
        return JSONUtility.toModel(new Gson(), object, clazz);
    }

    public static <T> T toLsp4jModel(Object object, Class<T> clazz) {
        return JSONUtility.toModel(new MessageJsonHandler(new HashMap()).getGson(), object, clazz);
    }

    private static <T> T toModel(Gson gson, Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class can not be null");
        }
        if (object instanceof JsonElement) {
            return (T)gson.fromJson((JsonElement)object, clazz);
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if (object instanceof String) {
            return (T)gson.fromJson((String)object, clazz);
        }
        return null;
    }
}

