/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.microsoft.java.debug.plugin.internal.ResolveClasspathsHandler;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class ResolveJavaExecutableHandler {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final String[] javaExecCandidates = new String[]{"java", "java.exe", "javaw", "javaw.exe", "j9", "j9.exe", "j9w", "j9w.exe"};
    private static final String[] javaBinCandidates = new String[]{File.separator, "bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};

    public static String resolveJavaExecutable(List<Object> arguments) throws Exception {
        try {
            String mainClass = (String)arguments.get(0);
            String projectName = (String)arguments.get(1);
            IJavaProject targetProject = null;
            if (StringUtils.isNotBlank((CharSequence)projectName)) {
                targetProject = JdtUtils.getJavaProject(projectName);
            } else {
                List<IJavaProject> targetProjects = ResolveClasspathsHandler.getJavaProjectFromType(mainClass);
                if (!targetProjects.isEmpty()) {
                    targetProject = targetProjects.get(0);
                }
            }
            return ResolveJavaExecutableHandler.resolveJavaExecutable(targetProject);
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, "Failed to resolve java executable: " + e.getMessage(), e);
            return null;
        }
    }

    public static String resolveJavaExecutable(IJavaProject javaProject) throws CoreException {
        if (javaProject == null) {
            return null;
        }
        IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        if (vmInstall == null || vmInstall.getInstallLocation() == null) {
            return null;
        }
        File exe = ResolveJavaExecutableHandler.findJavaExecutable(vmInstall.getInstallLocation());
        if (exe == null) {
            return null;
        }
        return exe.getAbsolutePath();
    }

    private static File findJavaExecutable(File vmInstallLocation) {
        boolean isBin = Objects.equals("bin", vmInstallLocation.getName());
        int i = 0;
        while (i < javaExecCandidates.length) {
            int j = 0;
            while (j < javaBinCandidates.length) {
                File javaFile;
                if ((isBin || j != 0) && (javaFile = new File(vmInstallLocation, String.valueOf(javaBinCandidates[j]) + javaExecCandidates[i])).isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

