"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalhostMatcher = exports.URLMatcher = exports.AbstractCmdClickTerminalContribution = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const core_1 = require("@theia/core");
const terminal_widget_impl_1 = require("./terminal-widget-impl");
const opener_service_1 = require("@theia/core/lib/browser/opener-service");
const uri_1 = require("@theia/core/lib/common/uri");
let AbstractCmdClickTerminalContribution = class AbstractCmdClickTerminalContribution {
    getValidate(terminalWidget) {
        return () => Promise.resolve(true);
    }
    async onCreate(terminalWidget) {
        const term = terminalWidget.getTerminal();
        const regexp = await this.getRegExp(terminalWidget);
        const handler = this.getHandler(terminalWidget);
        const validate = this.getValidate(terminalWidget);
        const wrappedHandler = (event, match) => {
            event.preventDefault();
            if (this.isCommandPressed(event) || this.wasTouchEvent(event, terminalWidget.lastTouchEndEvent)) {
                handler(event, match);
            }
            else {
                term.focus();
            }
        };
        const matcherId = term.registerLinkMatcher(regexp, wrappedHandler, {
            willLinkActivate: (event, uri) => this.isCommandPressed(event) || this.wasTouchEvent(event, terminalWidget.lastTouchEndEvent),
            tooltipCallback: (event, uri) => {
                if (!this.wasTouchEvent(event, terminalWidget.lastTouchEndEvent)) {
                    terminalWidget.showHoverMessage(event.clientX, event.clientY, this.getHoverMessage());
                }
            },
            leaveCallback: () => {
                terminalWidget.hideHover();
            },
            validationCallback: async (uri, callBack) => {
                callBack(await validate(uri));
            }
        });
        terminalWidget.onDispose(() => {
            term.deregisterLinkMatcher(matcherId);
        });
    }
    isCommandPressed(event) {
        return core_1.isOSX ? event.metaKey : event.ctrlKey;
    }
    wasTouchEvent(event, lastTouchEnd) {
        if (!lastTouchEnd) {
            return false;
        }
        if ((event.timeStamp - lastTouchEnd.timeStamp) > 400) {
            // A 'touchend' event typically precedes a matching 'click' event by 50ms.
            return false;
        }
        if (Math.abs(event.pageX - lastTouchEnd.pageX) > 5) {
            // Matching 'touchend' and 'click' events typically have the same page coordinates,
            // plus or minus 1 pixel.
            return false;
        }
        if (Math.abs(event.pageY - lastTouchEnd.pageY) > 5) {
            return false;
        }
        // We have a match! This link was tapped.
        return true;
    }
    getHoverMessage() {
        return terminal_widget_impl_1.TerminalWidgetImpl.getFollowLinkHover();
    }
};
AbstractCmdClickTerminalContribution = __decorate([
    inversify_1.injectable()
], AbstractCmdClickTerminalContribution);
exports.AbstractCmdClickTerminalContribution = AbstractCmdClickTerminalContribution;
let URLMatcher = class URLMatcher extends AbstractCmdClickTerminalContribution {
    async getRegExp() {
        return /https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,4}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/;
    }
    getHandler() {
        return (event, uri) => opener_service_1.open(this.openerService, new uri_1.default(uri));
    }
};
__decorate([
    inversify_1.inject(opener_service_1.OpenerService),
    __metadata("design:type", Object)
], URLMatcher.prototype, "openerService", void 0);
URLMatcher = __decorate([
    inversify_1.injectable()
], URLMatcher);
exports.URLMatcher = URLMatcher;
let LocalhostMatcher = class LocalhostMatcher extends AbstractCmdClickTerminalContribution {
    async getRegExp() {
        return /(https?:\/\/)?(localhost|127\.0\.0\.1|0\.0\.0\.0)(:[0-9]{1,5})?([-a-zA-Z0-9@:%_\+.~#?&//=]*)/;
    }
    getHandler() {
        return (event, matched) => {
            const uri = matched.startsWith('http') ? matched : `http://${matched}`;
            opener_service_1.open(this.openerService, new uri_1.default(uri));
        };
    }
};
__decorate([
    inversify_1.inject(opener_service_1.OpenerService),
    __metadata("design:type", Object)
], LocalhostMatcher.prototype, "openerService", void 0);
LocalhostMatcher = __decorate([
    inversify_1.injectable()
], LocalhostMatcher);
exports.LocalhostMatcher = LocalhostMatcher;
//# sourceMappingURL=terminal-linkmatcher.js.map