/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { ThemeIcon } from '../common/themeService';
import { getIconRegistry } from '../common/iconRegistry';
import { asCSSPropertyValue, asCSSUrl } from '../../../base/browser/dom';
import { Emitter } from '../../../base/common/event';
export function getIconsStyleSheet() {
    var onDidChangeEmmiter = new Emitter();
    var iconRegistry = getIconRegistry();
    iconRegistry.onDidChange(function () { return onDidChangeEmmiter.fire(); });
    return {
        onDidChange: onDidChangeEmmiter.event,
        getCSS: function () {
            var e_1, _a;
            var usedFontIds = {};
            var formatIconRule = function (contribution) {
                var definition = contribution.defaults;
                while (ThemeIcon.isThemeIcon(definition)) {
                    var c = iconRegistry.getIcon(definition.id);
                    if (!c) {
                        return undefined;
                    }
                    definition = c.defaults;
                }
                var fontId = definition.fontId;
                if (fontId) {
                    var fontContribution = iconRegistry.getIconFont(fontId);
                    if (fontContribution) {
                        usedFontIds[fontId] = fontContribution;
                        return ".codicon-" + contribution.id + ":before { content: '" + definition.fontCharacter + "'; font-family: " + asCSSPropertyValue(fontId) + "; }";
                    }
                }
                return ".codicon-" + contribution.id + ":before { content: '" + definition.fontCharacter + "'; }";
            };
            var rules = [];
            try {
                for (var _b = __values(iconRegistry.getIcons()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var contribution = _c.value;
                    var rule = formatIconRule(contribution);
                    if (rule) {
                        rules.push(rule);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            for (var id in usedFontIds) {
                var fontContribution = usedFontIds[id];
                var src = fontContribution.definition.src.map(function (l) { return asCSSUrl(l.location) + " format('" + l.format + "')"; }).join(', ');
                rules.push("@font-face { src: " + src + "; font-family: " + asCSSPropertyValue(id) + "; }");
            }
            return rules.join('\n');
        }
    };
}
