/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as strings from '../../../base/common/strings';
import * as dom from '../../../base/browser/dom';
import { StandardKeyboardEvent } from '../../../base/browser/keyboardEvent';
import { Emitter, Event } from '../../../base/common/event';
import { SimpleKeybinding, createKeybinding } from '../../../base/common/keyCodes';
import { ImmortalReference, toDisposable, DisposableStore, Disposable } from '../../../base/common/lifecycle';
import { OS, isLinux, isMacintosh } from '../../../base/common/platform';
import Severity from '../../../base/common/severity';
import { URI } from '../../../base/common/uri';
import { isCodeEditor } from '../../browser/editorBrowser';
import { ResourceTextEdit } from '../../browser/services/bulkEditService';
import { isDiffEditorConfigurationKey, isEditorConfigurationKey } from '../../common/config/commonEditorConfig';
import { EditOperation } from '../../common/core/editOperation';
import { Position as Pos } from '../../common/core/position';
import { Range } from '../../common/core/range';
import { IModelService } from '../../common/services/modelService';
import { CommandsRegistry } from '../../../platform/commands/common/commands';
import { IConfigurationService } from '../../../platform/configuration/common/configuration';
import { Configuration, ConfigurationModel, DefaultConfigurationModel, ConfigurationChangeEvent } from '../../../platform/configuration/common/configurationModels';
import { AbstractKeybindingService } from '../../../platform/keybinding/common/abstractKeybindingService';
import { KeybindingResolver } from '../../../platform/keybinding/common/keybindingResolver';
import { KeybindingsRegistry } from '../../../platform/keybinding/common/keybindingsRegistry';
import { ResolvedKeybindingItem } from '../../../platform/keybinding/common/resolvedKeybindingItem';
import { USLayoutResolvedKeybinding } from '../../../platform/keybinding/common/usLayoutResolvedKeybinding';
import { NoOpNotification } from '../../../platform/notification/common/notification';
import { WorkspaceFolder } from '../../../platform/workspace/common/workspace';
import { SimpleServicesNLS } from '../../common/standaloneStrings';
import { basename } from '../../../base/common/resources';
var SimpleModel = /** @class */ (function () {
    function SimpleModel(model) {
        this.disposed = false;
        this.model = model;
        this._onDispose = new Emitter();
    }
    Object.defineProperty(SimpleModel.prototype, "onDispose", {
        get: function () {
            return this._onDispose.event;
        },
        enumerable: false,
        configurable: true
    });
    SimpleModel.prototype.load = function () {
        return Promise.resolve(this);
    };
    Object.defineProperty(SimpleModel.prototype, "textEditorModel", {
        get: function () {
            return this.model;
        },
        enumerable: false,
        configurable: true
    });
    SimpleModel.prototype.createSnapshot = function () {
        return this.model.createSnapshot();
    };
    SimpleModel.prototype.isReadonly = function () {
        return false;
    };
    SimpleModel.prototype.dispose = function () {
        this.disposed = true;
        this._onDispose.fire();
    };
    SimpleModel.prototype.isDisposed = function () {
        return this.disposed;
    };
    SimpleModel.prototype.isResolved = function () {
        return true;
    };
    SimpleModel.prototype.getMode = function () {
        return this.model.getModeId();
    };
    return SimpleModel;
}());
export { SimpleModel };
function withTypedEditor(widget, codeEditorCallback, diffEditorCallback) {
    if (isCodeEditor(widget)) {
        // Single Editor
        return codeEditorCallback(widget);
    }
    else {
        // Diff Editor
        return diffEditorCallback(widget);
    }
}
var SimpleEditorModelResolverService = /** @class */ (function () {
    function SimpleEditorModelResolverService(modelService) {
        this.modelService = modelService;
    }
    SimpleEditorModelResolverService.prototype.setEditor = function (editor) {
        this.editor = editor;
    };
    SimpleEditorModelResolverService.prototype.createModelReference = function (resource) {
        var _this = this;
        var model = null;
        if (this.editor) {
            model = withTypedEditor(this.editor, function (editor) { return _this.findModel(editor, resource); }, function (diffEditor) { return _this.findModel(diffEditor.getOriginalEditor(), resource) || _this.findModel(diffEditor.getModifiedEditor(), resource); });
        }
        if (!model) {
            return Promise.reject(new Error("Model not found"));
        }
        return Promise.resolve(new ImmortalReference(new SimpleModel(model)));
    };
    SimpleEditorModelResolverService.prototype.registerTextModelContentProvider = function (scheme, provider) {
        return {
            dispose: function () { }
        };
    };
    SimpleEditorModelResolverService.prototype.canHandleResource = function (resource) {
        return false;
    };
    SimpleEditorModelResolverService.prototype.findModel = function (editor, resource) {
        var model = this.modelService.getModel(resource);
        if (model && model.uri.toString() !== resource.toString()) {
            return null;
        }
        return model;
    };
    SimpleEditorModelResolverService = __decorate([
        __param(0, IModelService)
    ], SimpleEditorModelResolverService);
    return SimpleEditorModelResolverService;
}());
export { SimpleEditorModelResolverService };
var SimpleEditorProgressService = /** @class */ (function () {
    function SimpleEditorProgressService() {
    }
    SimpleEditorProgressService.prototype.show = function () {
        return SimpleEditorProgressService.NULL_PROGRESS_RUNNER;
    };
    SimpleEditorProgressService.prototype.showWhile = function (promise, delay) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, promise];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    SimpleEditorProgressService.NULL_PROGRESS_RUNNER = {
        done: function () { },
        total: function () { },
        worked: function () { }
    };
    return SimpleEditorProgressService;
}());
export { SimpleEditorProgressService };
var SimpleDialogService = /** @class */ (function () {
    function SimpleDialogService() {
    }
    SimpleDialogService.prototype.confirm = function (confirmation) {
        return this.doConfirm(confirmation).then(function (confirmed) {
            return {
                confirmed: confirmed,
                checkboxChecked: false // unsupported
            };
        });
    };
    SimpleDialogService.prototype.doConfirm = function (confirmation) {
        var messageText = confirmation.message;
        if (confirmation.detail) {
            messageText = messageText + '\n\n' + confirmation.detail;
        }
        return Promise.resolve(window.confirm(messageText));
    };
    SimpleDialogService.prototype.show = function (severity, message, buttons, options) {
        return Promise.resolve({ choice: 0 });
    };
    SimpleDialogService.prototype.input = function () {
        return Promise.resolve({ choice: 0 }); // unsupported
    };
    SimpleDialogService.prototype.about = function () {
        return Promise.resolve(undefined);
    };
    return SimpleDialogService;
}());
export { SimpleDialogService };
var SimpleNotificationService = /** @class */ (function () {
    function SimpleNotificationService() {
    }
    SimpleNotificationService.prototype.info = function (message) {
        return this.notify({ severity: Severity.Info, message: message });
    };
    SimpleNotificationService.prototype.warn = function (message) {
        return this.notify({ severity: Severity.Warning, message: message });
    };
    SimpleNotificationService.prototype.error = function (error) {
        return this.notify({ severity: Severity.Error, message: error });
    };
    SimpleNotificationService.prototype.notify = function (notification) {
        switch (notification.severity) {
            case Severity.Error:
                console.error(notification.message);
                break;
            case Severity.Warning:
                console.warn(notification.message);
                break;
            default:
                console.log(notification.message);
                break;
        }
        return SimpleNotificationService.NO_OP;
    };
    SimpleNotificationService.prototype.prompt = function (severity, message, choices, options) {
        return SimpleNotificationService.NO_OP;
    };
    SimpleNotificationService.prototype.status = function (message, options) {
        return Disposable.None;
    };
    SimpleNotificationService.prototype.setFilter = function (filter) { };
    SimpleNotificationService.NO_OP = new NoOpNotification();
    return SimpleNotificationService;
}());
export { SimpleNotificationService };
var StandaloneCommandService = /** @class */ (function () {
    function StandaloneCommandService(instantiationService) {
        this._onWillExecuteCommand = new Emitter();
        this._onDidExecuteCommand = new Emitter();
        this.onWillExecuteCommand = this._onWillExecuteCommand.event;
        this.onDidExecuteCommand = this._onDidExecuteCommand.event;
        this._instantiationService = instantiationService;
    }
    StandaloneCommandService.prototype.executeCommand = function (id) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var command = CommandsRegistry.getCommand(id);
        if (!command) {
            return Promise.reject(new Error("command '" + id + "' not found"));
        }
        try {
            this._onWillExecuteCommand.fire({ commandId: id, args: args });
            var result = this._instantiationService.invokeFunction.apply(this._instantiationService, __spreadArray([command.handler], __read(args)));
            this._onDidExecuteCommand.fire({ commandId: id, args: args });
            return Promise.resolve(result);
        }
        catch (err) {
            return Promise.reject(err);
        }
    };
    return StandaloneCommandService;
}());
export { StandaloneCommandService };
var StandaloneKeybindingService = /** @class */ (function (_super) {
    __extends(StandaloneKeybindingService, _super);
    function StandaloneKeybindingService(contextKeyService, commandService, telemetryService, notificationService, logService, domNode) {
        var _this = _super.call(this, contextKeyService, commandService, telemetryService, notificationService, logService) || this;
        _this._cachedResolver = null;
        _this._dynamicKeybindings = [];
        // for standard keybindings
        _this._register(dom.addDisposableListener(domNode, dom.EventType.KEY_DOWN, function (e) {
            var keyEvent = new StandardKeyboardEvent(e);
            var shouldPreventDefault = _this._dispatch(keyEvent, keyEvent.target);
            if (shouldPreventDefault) {
                keyEvent.preventDefault();
                keyEvent.stopPropagation();
            }
        }));
        // for single modifier chord keybindings (e.g. shift shift)
        _this._register(dom.addDisposableListener(window, dom.EventType.KEY_UP, function (e) {
            var keyEvent = new StandardKeyboardEvent(e);
            var shouldPreventDefault = _this._singleModifierDispatch(keyEvent, keyEvent.target);
            if (shouldPreventDefault) {
                keyEvent.preventDefault();
            }
        }));
        return _this;
    }
    StandaloneKeybindingService.prototype.addDynamicKeybinding = function (commandId, _keybinding, handler, when) {
        var _this = this;
        var keybinding = createKeybinding(_keybinding, OS);
        var toDispose = new DisposableStore();
        if (keybinding) {
            this._dynamicKeybindings.push({
                keybinding: keybinding,
                command: commandId,
                when: when,
                weight1: 1000,
                weight2: 0,
                extensionId: null,
                isBuiltinExtension: false
            });
            toDispose.add(toDisposable(function () {
                for (var i = 0; i < _this._dynamicKeybindings.length; i++) {
                    var kb = _this._dynamicKeybindings[i];
                    if (kb.command === commandId) {
                        _this._dynamicKeybindings.splice(i, 1);
                        _this.updateResolver({ source: 1 /* Default */ });
                        return;
                    }
                }
            }));
        }
        toDispose.add(CommandsRegistry.registerCommand(commandId, handler));
        this.updateResolver({ source: 1 /* Default */ });
        return toDispose;
    };
    StandaloneKeybindingService.prototype.updateResolver = function (event) {
        this._cachedResolver = null;
        this._onDidUpdateKeybindings.fire(event);
    };
    StandaloneKeybindingService.prototype._getResolver = function () {
        var _this = this;
        if (!this._cachedResolver) {
            var defaults = this._toNormalizedKeybindingItems(KeybindingsRegistry.getDefaultKeybindings(), true);
            var overrides = this._toNormalizedKeybindingItems(this._dynamicKeybindings, false);
            this._cachedResolver = new KeybindingResolver(defaults, overrides, function (str) { return _this._log(str); });
        }
        return this._cachedResolver;
    };
    StandaloneKeybindingService.prototype._documentHasFocus = function () {
        return document.hasFocus();
    };
    StandaloneKeybindingService.prototype._toNormalizedKeybindingItems = function (items, isDefault) {
        var e_1, _a, e_2, _b;
        var result = [], resultLen = 0;
        try {
            for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                var item = items_1_1.value;
                var when = item.when || undefined;
                var keybinding = item.keybinding;
                if (!keybinding) {
                    // This might be a removal keybinding item in user settings => accept it
                    result[resultLen++] = new ResolvedKeybindingItem(undefined, item.command, item.commandArgs, when, isDefault, null, false);
                }
                else {
                    var resolvedKeybindings = this.resolveKeybinding(keybinding);
                    try {
                        for (var resolvedKeybindings_1 = (e_2 = void 0, __values(resolvedKeybindings)), resolvedKeybindings_1_1 = resolvedKeybindings_1.next(); !resolvedKeybindings_1_1.done; resolvedKeybindings_1_1 = resolvedKeybindings_1.next()) {
                            var resolvedKeybinding = resolvedKeybindings_1_1.value;
                            result[resultLen++] = new ResolvedKeybindingItem(resolvedKeybinding, item.command, item.commandArgs, when, isDefault, null, false);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (resolvedKeybindings_1_1 && !resolvedKeybindings_1_1.done && (_b = resolvedKeybindings_1.return)) _b.call(resolvedKeybindings_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    StandaloneKeybindingService.prototype.resolveKeybinding = function (keybinding) {
        return [new USLayoutResolvedKeybinding(keybinding, OS)];
    };
    StandaloneKeybindingService.prototype.resolveKeyboardEvent = function (keyboardEvent) {
        var keybinding = new SimpleKeybinding(keyboardEvent.ctrlKey, keyboardEvent.shiftKey, keyboardEvent.altKey, keyboardEvent.metaKey, keyboardEvent.keyCode).toChord();
        return new USLayoutResolvedKeybinding(keybinding, OS);
    };
    StandaloneKeybindingService.prototype.resolveUserBinding = function (userBinding) {
        return [];
    };
    StandaloneKeybindingService.prototype._dumpDebugInfo = function () {
        return '';
    };
    StandaloneKeybindingService.prototype._dumpDebugInfoJSON = function () {
        return '';
    };
    StandaloneKeybindingService.prototype.registerSchemaContribution = function (contribution) {
        // noop
    };
    return StandaloneKeybindingService;
}(AbstractKeybindingService));
export { StandaloneKeybindingService };
function isConfigurationOverrides(thing) {
    return thing
        && typeof thing === 'object'
        && (!thing.overrideIdentifier || typeof thing.overrideIdentifier === 'string')
        && (!thing.resource || thing.resource instanceof URI);
}
var SimpleConfigurationService = /** @class */ (function () {
    function SimpleConfigurationService() {
        this._onDidChangeConfiguration = new Emitter();
        this.onDidChangeConfiguration = this._onDidChangeConfiguration.event;
        this._configuration = new Configuration(new DefaultConfigurationModel(), new ConfigurationModel());
    }
    SimpleConfigurationService.prototype.getValue = function (arg1, arg2) {
        var section = typeof arg1 === 'string' ? arg1 : undefined;
        var overrides = isConfigurationOverrides(arg1) ? arg1 : isConfigurationOverrides(arg2) ? arg2 : {};
        return this._configuration.getValue(section, overrides, undefined);
    };
    SimpleConfigurationService.prototype.updateValues = function (values) {
        var e_3, _a;
        var previous = { data: this._configuration.toData() };
        var changedKeys = [];
        try {
            for (var values_1 = __values(values), values_1_1 = values_1.next(); !values_1_1.done; values_1_1 = values_1.next()) {
                var entry = values_1_1.value;
                var _b = __read(entry, 2), key = _b[0], value = _b[1];
                if (this.getValue(key) === value) {
                    continue;
                }
                this._configuration.updateValue(key, value);
                changedKeys.push(key);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (values_1_1 && !values_1_1.done && (_a = values_1.return)) _a.call(values_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        if (changedKeys.length > 0) {
            var configurationChangeEvent = new ConfigurationChangeEvent({ keys: changedKeys, overrides: [] }, previous, this._configuration);
            configurationChangeEvent.source = 7 /* MEMORY */;
            configurationChangeEvent.sourceConfig = null;
            this._onDidChangeConfiguration.fire(configurationChangeEvent);
        }
        return Promise.resolve();
    };
    SimpleConfigurationService.prototype.updateValue = function (key, value, arg3, arg4) {
        return this.updateValues([[key, value]]);
    };
    SimpleConfigurationService.prototype.inspect = function (key, options) {
        if (options === void 0) { options = {}; }
        return this._configuration.inspect(key, options, undefined);
    };
    SimpleConfigurationService.prototype.keys = function () {
        return this._configuration.keys(undefined);
    };
    SimpleConfigurationService.prototype.reloadConfiguration = function () {
        return Promise.resolve(undefined);
    };
    SimpleConfigurationService.prototype.getConfigurationData = function () {
        var emptyModel = {
            contents: {},
            keys: [],
            overrides: []
        };
        return {
            defaults: emptyModel,
            user: emptyModel,
            workspace: emptyModel,
            folders: []
        };
    };
    return SimpleConfigurationService;
}());
export { SimpleConfigurationService };
var SimpleResourceConfigurationService = /** @class */ (function () {
    function SimpleResourceConfigurationService(configurationService) {
        var _this = this;
        this.configurationService = configurationService;
        this._onDidChangeConfiguration = new Emitter();
        this.onDidChangeConfiguration = this._onDidChangeConfiguration.event;
        this.configurationService.onDidChangeConfiguration(function (e) {
            _this._onDidChangeConfiguration.fire({ affectedKeys: e.affectedKeys, affectsConfiguration: function (resource, configuration) { return e.affectsConfiguration(configuration); } });
        });
    }
    SimpleResourceConfigurationService.prototype.getValue = function (resource, arg2, arg3) {
        var position = Pos.isIPosition(arg2) ? arg2 : null;
        var section = position ? (typeof arg3 === 'string' ? arg3 : undefined) : (typeof arg2 === 'string' ? arg2 : undefined);
        if (typeof section === 'undefined') {
            return this.configurationService.getValue();
        }
        return this.configurationService.getValue(section);
    };
    SimpleResourceConfigurationService.prototype.updateValue = function (resource, key, value, configurationTarget) {
        return this.configurationService.updateValue(key, value, { resource: resource }, configurationTarget);
    };
    return SimpleResourceConfigurationService;
}());
export { SimpleResourceConfigurationService };
var SimpleResourcePropertiesService = /** @class */ (function () {
    function SimpleResourcePropertiesService(configurationService) {
        this.configurationService = configurationService;
    }
    SimpleResourcePropertiesService.prototype.getEOL = function (resource, language) {
        var eol = this.configurationService.getValue('files.eol', { overrideIdentifier: language, resource: resource });
        if (eol && eol !== 'auto') {
            return eol;
        }
        return (isLinux || isMacintosh) ? '\n' : '\r\n';
    };
    SimpleResourcePropertiesService = __decorate([
        __param(0, IConfigurationService)
    ], SimpleResourcePropertiesService);
    return SimpleResourcePropertiesService;
}());
export { SimpleResourcePropertiesService };
var StandaloneTelemetryService = /** @class */ (function () {
    function StandaloneTelemetryService() {
        this.isOptedIn = false;
        this.sendErrorTelemetry = false;
    }
    StandaloneTelemetryService.prototype.setEnabled = function (value) {
    };
    StandaloneTelemetryService.prototype.setExperimentProperty = function (name, value) {
    };
    StandaloneTelemetryService.prototype.publicLog = function (eventName, data) {
        return Promise.resolve(undefined);
    };
    StandaloneTelemetryService.prototype.publicLog2 = function (eventName, data) {
        return this.publicLog(eventName, data);
    };
    StandaloneTelemetryService.prototype.publicLogError = function (eventName, data) {
        return Promise.resolve(undefined);
    };
    StandaloneTelemetryService.prototype.publicLogError2 = function (eventName, data) {
        return this.publicLogError(eventName, data);
    };
    StandaloneTelemetryService.prototype.getTelemetryInfo = function () {
        throw new Error("Not available");
    };
    return StandaloneTelemetryService;
}());
export { StandaloneTelemetryService };
var SimpleWorkspaceContextService = /** @class */ (function () {
    function SimpleWorkspaceContextService() {
        this._onDidChangeWorkspaceName = new Emitter();
        this.onDidChangeWorkspaceName = this._onDidChangeWorkspaceName.event;
        this._onDidChangeWorkspaceFolders = new Emitter();
        this.onDidChangeWorkspaceFolders = this._onDidChangeWorkspaceFolders.event;
        this._onDidChangeWorkbenchState = new Emitter();
        this.onDidChangeWorkbenchState = this._onDidChangeWorkbenchState.event;
        var resource = URI.from({ scheme: SimpleWorkspaceContextService.SCHEME, authority: 'model', path: '/' });
        this.workspace = { id: '4064f6ec-cb38-4ad0-af64-ee6467e63c82', folders: [new WorkspaceFolder({ uri: resource, name: '', index: 0 })] };
    }
    SimpleWorkspaceContextService.prototype.getCompleteWorkspace = function () {
        return Promise.resolve(this.getWorkspace());
    };
    SimpleWorkspaceContextService.prototype.getWorkspace = function () {
        return this.workspace;
    };
    SimpleWorkspaceContextService.prototype.getWorkbenchState = function () {
        if (this.workspace) {
            if (this.workspace.configuration) {
                return 3 /* WORKSPACE */;
            }
            return 2 /* FOLDER */;
        }
        return 1 /* EMPTY */;
    };
    SimpleWorkspaceContextService.prototype.getWorkspaceFolder = function (resource) {
        return resource && resource.scheme === SimpleWorkspaceContextService.SCHEME ? this.workspace.folders[0] : null;
    };
    SimpleWorkspaceContextService.prototype.isInsideWorkspace = function (resource) {
        return resource && resource.scheme === SimpleWorkspaceContextService.SCHEME;
    };
    SimpleWorkspaceContextService.prototype.isCurrentWorkspace = function (workspaceIdOrFolder) {
        return true;
    };
    SimpleWorkspaceContextService.SCHEME = 'inmemory';
    return SimpleWorkspaceContextService;
}());
export { SimpleWorkspaceContextService };
export function updateConfigurationService(configurationService, source, isDiffEditor) {
    if (!source) {
        return;
    }
    if (!(configurationService instanceof SimpleConfigurationService)) {
        return;
    }
    var toUpdate = [];
    Object.keys(source).forEach(function (key) {
        if (isEditorConfigurationKey(key)) {
            toUpdate.push(["editor." + key, source[key]]);
        }
        if (isDiffEditor && isDiffEditorConfigurationKey(key)) {
            toUpdate.push(["diffEditor." + key, source[key]]);
        }
    });
    if (toUpdate.length > 0) {
        configurationService.updateValues(toUpdate);
    }
}
var SimpleBulkEditService = /** @class */ (function () {
    function SimpleBulkEditService(_modelService) {
        this._modelService = _modelService;
        //
    }
    SimpleBulkEditService.prototype.hasPreviewHandler = function () {
        return false;
    };
    SimpleBulkEditService.prototype.setPreviewHandler = function () {
        return Disposable.None;
    };
    SimpleBulkEditService.prototype.apply = function (edits, _options) {
        return __awaiter(this, void 0, void 0, function () {
            var textEdits, edits_1, edits_1_1, edit, model, array, totalEdits, totalFiles, textEdits_1, textEdits_1_1, _a, model, edits_2;
            var e_4, _b, e_5, _c;
            return __generator(this, function (_d) {
                textEdits = new Map();
                try {
                    for (edits_1 = __values(edits), edits_1_1 = edits_1.next(); !edits_1_1.done; edits_1_1 = edits_1.next()) {
                        edit = edits_1_1.value;
                        if (!(edit instanceof ResourceTextEdit)) {
                            throw new Error('bad edit - only text edits are supported');
                        }
                        model = this._modelService.getModel(edit.resource);
                        if (!model) {
                            throw new Error('bad edit - model not found');
                        }
                        if (typeof edit.versionId === 'number' && model.getVersionId() !== edit.versionId) {
                            throw new Error('bad state - model changed in the meantime');
                        }
                        array = textEdits.get(model);
                        if (!array) {
                            array = [];
                            textEdits.set(model, array);
                        }
                        array.push(EditOperation.replaceMove(Range.lift(edit.textEdit.range), edit.textEdit.text));
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (edits_1_1 && !edits_1_1.done && (_b = edits_1.return)) _b.call(edits_1);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
                totalEdits = 0;
                totalFiles = 0;
                try {
                    for (textEdits_1 = __values(textEdits), textEdits_1_1 = textEdits_1.next(); !textEdits_1_1.done; textEdits_1_1 = textEdits_1.next()) {
                        _a = __read(textEdits_1_1.value, 2), model = _a[0], edits_2 = _a[1];
                        model.pushStackElement();
                        model.pushEditOperations([], edits_2, function () { return []; });
                        model.pushStackElement();
                        totalFiles += 1;
                        totalEdits += edits_2.length;
                    }
                }
                catch (e_5_1) { e_5 = { error: e_5_1 }; }
                finally {
                    try {
                        if (textEdits_1_1 && !textEdits_1_1.done && (_c = textEdits_1.return)) _c.call(textEdits_1);
                    }
                    finally { if (e_5) throw e_5.error; }
                }
                return [2 /*return*/, {
                        ariaSummary: strings.format(SimpleServicesNLS.bulkEditServiceSummary, totalEdits, totalFiles)
                    }];
            });
        });
    };
    return SimpleBulkEditService;
}());
export { SimpleBulkEditService };
var SimpleUriLabelService = /** @class */ (function () {
    function SimpleUriLabelService() {
        this.onDidChangeFormatters = Event.None;
    }
    SimpleUriLabelService.prototype.getUriLabel = function (resource, options) {
        if (resource.scheme === 'file') {
            return resource.fsPath;
        }
        return resource.path;
    };
    SimpleUriLabelService.prototype.getUriBasenameLabel = function (resource) {
        return basename(resource);
    };
    SimpleUriLabelService.prototype.getWorkspaceLabel = function (workspace, options) {
        return '';
    };
    SimpleUriLabelService.prototype.getSeparator = function (scheme, authority) {
        return '/';
    };
    SimpleUriLabelService.prototype.registerFormatter = function (formatter) {
        throw new Error('Not implemented');
    };
    SimpleUriLabelService.prototype.getHostLabel = function () {
        return '';
    };
    return SimpleUriLabelService;
}());
export { SimpleUriLabelService };
var SimpleLayoutService = /** @class */ (function () {
    function SimpleLayoutService(_codeEditorService, _container) {
        this._codeEditorService = _codeEditorService;
        this._container = _container;
        this.onDidLayout = Event.None;
    }
    Object.defineProperty(SimpleLayoutService.prototype, "dimension", {
        get: function () {
            if (!this._dimension) {
                this._dimension = dom.getClientArea(window.document.body);
            }
            return this._dimension;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SimpleLayoutService.prototype, "container", {
        get: function () {
            return this._container;
        },
        enumerable: false,
        configurable: true
    });
    SimpleLayoutService.prototype.focus = function () {
        var _a;
        (_a = this._codeEditorService.getFocusedCodeEditor()) === null || _a === void 0 ? void 0 : _a.focus();
    };
    return SimpleLayoutService;
}());
export { SimpleLayoutService };
