/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import './standaloneQuickInput.css';
import { registerEditorContribution } from '../../../browser/editorExtensions';
import { IThemeService } from '../../../../platform/theme/common/themeService';
import { CancellationToken } from '../../../../base/common/cancellation';
import { IInstantiationService } from '../../../../platform/instantiation/common/instantiation';
import { IContextKeyService } from '../../../../platform/contextkey/common/contextkey';
import { IAccessibilityService } from '../../../../platform/accessibility/common/accessibility';
import { ILayoutService } from '../../../../platform/layout/browser/layoutService';
import { ICodeEditorService } from '../../../browser/services/codeEditorService';
import { QuickInputService } from '../../../../platform/quickinput/browser/quickInput';
import { once } from '../../../../base/common/functional';
var EditorScopedQuickInputServiceImpl = /** @class */ (function (_super) {
    __extends(EditorScopedQuickInputServiceImpl, _super);
    function EditorScopedQuickInputServiceImpl(editor, instantiationService, contextKeyService, themeService, accessibilityService, layoutService) {
        var _this = _super.call(this, instantiationService, contextKeyService, themeService, accessibilityService, layoutService) || this;
        _this.host = undefined;
        // Use the passed in code editor as host for the quick input widget
        var contribution = QuickInputEditorContribution.get(editor);
        _this.host = {
            _serviceBrand: undefined,
            get container() { return contribution.widget.getDomNode(); },
            get dimension() { return editor.getLayoutInfo(); },
            get onDidLayout() { return editor.onDidLayoutChange; },
            focus: function () { return editor.focus(); }
        };
        return _this;
    }
    EditorScopedQuickInputServiceImpl.prototype.createController = function () {
        return _super.prototype.createController.call(this, this.host);
    };
    EditorScopedQuickInputServiceImpl = __decorate([
        __param(1, IInstantiationService),
        __param(2, IContextKeyService),
        __param(3, IThemeService),
        __param(4, IAccessibilityService),
        __param(5, ILayoutService)
    ], EditorScopedQuickInputServiceImpl);
    return EditorScopedQuickInputServiceImpl;
}(QuickInputService));
export { EditorScopedQuickInputServiceImpl };
var StandaloneQuickInputServiceImpl = /** @class */ (function () {
    function StandaloneQuickInputServiceImpl(instantiationService, codeEditorService) {
        this.instantiationService = instantiationService;
        this.codeEditorService = codeEditorService;
        this.mapEditorToService = new Map();
    }
    Object.defineProperty(StandaloneQuickInputServiceImpl.prototype, "activeService", {
        get: function () {
            var _this = this;
            var editor = this.codeEditorService.getFocusedCodeEditor();
            if (!editor) {
                throw new Error('Quick input service needs a focused editor to work.');
            }
            // Find the quick input implementation for the focused
            // editor or create it lazily if not yet created
            var quickInputService = this.mapEditorToService.get(editor);
            if (!quickInputService) {
                var newQuickInputService_1 = quickInputService = this.instantiationService.createInstance(EditorScopedQuickInputServiceImpl, editor);
                this.mapEditorToService.set(editor, quickInputService);
                once(editor.onDidDispose)(function () {
                    newQuickInputService_1.dispose();
                    _this.mapEditorToService.delete(editor);
                });
            }
            return quickInputService;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StandaloneQuickInputServiceImpl.prototype, "quickAccess", {
        get: function () { return this.activeService.quickAccess; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StandaloneQuickInputServiceImpl.prototype, "backButton", {
        get: function () { return this.activeService.backButton; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StandaloneQuickInputServiceImpl.prototype, "onShow", {
        get: function () { return this.activeService.onShow; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(StandaloneQuickInputServiceImpl.prototype, "onHide", {
        get: function () { return this.activeService.onHide; },
        enumerable: false,
        configurable: true
    });
    StandaloneQuickInputServiceImpl.prototype.pick = function (picks, options, token) {
        if (options === void 0) { options = {}; }
        if (token === void 0) { token = CancellationToken.None; }
        return this.activeService /* TS fail */.pick(picks, options, token);
    };
    StandaloneQuickInputServiceImpl.prototype.input = function (options, token) {
        return this.activeService.input(options, token);
    };
    StandaloneQuickInputServiceImpl.prototype.createQuickPick = function () {
        return this.activeService.createQuickPick();
    };
    StandaloneQuickInputServiceImpl.prototype.createInputBox = function () {
        return this.activeService.createInputBox();
    };
    StandaloneQuickInputServiceImpl.prototype.focus = function () {
        return this.activeService.focus();
    };
    StandaloneQuickInputServiceImpl.prototype.toggle = function () {
        return this.activeService.toggle();
    };
    StandaloneQuickInputServiceImpl.prototype.navigate = function (next, quickNavigate) {
        return this.activeService.navigate(next, quickNavigate);
    };
    StandaloneQuickInputServiceImpl.prototype.accept = function () {
        return this.activeService.accept();
    };
    StandaloneQuickInputServiceImpl.prototype.back = function () {
        return this.activeService.back();
    };
    StandaloneQuickInputServiceImpl.prototype.cancel = function () {
        return this.activeService.cancel();
    };
    StandaloneQuickInputServiceImpl = __decorate([
        __param(0, IInstantiationService),
        __param(1, ICodeEditorService)
    ], StandaloneQuickInputServiceImpl);
    return StandaloneQuickInputServiceImpl;
}());
export { StandaloneQuickInputServiceImpl };
var QuickInputEditorContribution = /** @class */ (function () {
    function QuickInputEditorContribution(editor) {
        this.editor = editor;
        this.widget = new QuickInputEditorWidget(this.editor);
    }
    QuickInputEditorContribution.get = function (editor) {
        return editor.getContribution(QuickInputEditorContribution.ID);
    };
    QuickInputEditorContribution.prototype.dispose = function () {
        this.widget.dispose();
    };
    QuickInputEditorContribution.ID = 'editor.controller.quickInput';
    return QuickInputEditorContribution;
}());
export { QuickInputEditorContribution };
var QuickInputEditorWidget = /** @class */ (function () {
    function QuickInputEditorWidget(codeEditor) {
        this.codeEditor = codeEditor;
        this.domNode = document.createElement('div');
        this.codeEditor.addOverlayWidget(this);
    }
    QuickInputEditorWidget.prototype.getId = function () {
        return QuickInputEditorWidget.ID;
    };
    QuickInputEditorWidget.prototype.getDomNode = function () {
        return this.domNode;
    };
    QuickInputEditorWidget.prototype.getPosition = function () {
        return { preference: 2 /* TOP_CENTER */ };
    };
    QuickInputEditorWidget.prototype.dispose = function () {
        this.codeEditor.removeOverlayWidget(this);
    };
    QuickInputEditorWidget.ID = 'editor.contrib.quickInputWidget';
    return QuickInputEditorWidget;
}());
export { QuickInputEditorWidget };
registerEditorContribution(QuickInputEditorContribution.ID, QuickInputEditorContribution);
