/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { Range } from '../../common/core/range';
var ReplaceAllCommand = /** @class */ (function () {
    function ReplaceAllCommand(editorSelection, ranges, replaceStrings) {
        this._editorSelection = editorSelection;
        this._ranges = ranges;
        this._replaceStrings = replaceStrings;
        this._trackedEditorSelectionId = null;
    }
    ReplaceAllCommand.prototype.getEditOperations = function (model, builder) {
        var e_1, _a;
        if (this._ranges.length > 0) {
            // Collect all edit operations
            var ops = [];
            for (var i = 0; i < this._ranges.length; i++) {
                ops.push({
                    range: this._ranges[i],
                    text: this._replaceStrings[i]
                });
            }
            // Sort them in ascending order by range starts
            ops.sort(function (o1, o2) {
                return Range.compareRangesUsingStarts(o1.range, o2.range);
            });
            // Merge operations that touch each other
            var resultOps = [];
            var previousOp = ops[0];
            for (var i = 1; i < ops.length; i++) {
                if (previousOp.range.endLineNumber === ops[i].range.startLineNumber && previousOp.range.endColumn === ops[i].range.startColumn) {
                    // These operations are one after another and can be merged
                    previousOp.range = previousOp.range.plusRange(ops[i].range);
                    previousOp.text = previousOp.text + ops[i].text;
                }
                else {
                    resultOps.push(previousOp);
                    previousOp = ops[i];
                }
            }
            resultOps.push(previousOp);
            try {
                for (var resultOps_1 = __values(resultOps), resultOps_1_1 = resultOps_1.next(); !resultOps_1_1.done; resultOps_1_1 = resultOps_1.next()) {
                    var op = resultOps_1_1.value;
                    builder.addEditOperation(op.range, op.text);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (resultOps_1_1 && !resultOps_1_1.done && (_a = resultOps_1.return)) _a.call(resultOps_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        this._trackedEditorSelectionId = builder.trackSelection(this._editorSelection);
    };
    ReplaceAllCommand.prototype.computeCursorState = function (model, helper) {
        return helper.getTrackedSelection(this._trackedEditorSelectionId);
    };
    return ReplaceAllCommand;
}());
export { ReplaceAllCommand };
