/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { CSSIcon } from './codicons';
import { matchesFuzzy } from './filters';
import { ltrim } from './strings';
export var iconStartMarker = '$(';
var iconsRegex = new RegExp("\\$\\(" + CSSIcon.iconNameExpression + "(?:" + CSSIcon.iconModifierExpression + ")?\\)", 'g'); // no capturing groups
var escapeIconsRegex = new RegExp("(\\\\)?" + iconsRegex.source, 'g');
export function escapeIcons(text) {
    return text.replace(escapeIconsRegex, function (match, escaped) { return escaped ? match : "\\" + match; });
}
var markdownEscapedIconsRegex = new RegExp("\\\\" + iconsRegex.source, 'g');
export function markdownEscapeEscapedIcons(text) {
    // Need to add an extra \ for escaping in markdown
    return text.replace(markdownEscapedIconsRegex, function (match) { return "\\" + match; });
}
var stripIconsRegex = new RegExp("(\\s)?(\\\\)?" + iconsRegex.source + "(\\s)?", 'g');
export function stripIcons(text) {
    if (text.indexOf(iconStartMarker) === -1) {
        return text;
    }
    return text.replace(stripIconsRegex, function (match, preWhitespace, escaped, postWhitespace) { return escaped ? match : preWhitespace || postWhitespace || ''; });
}
export function parseLabelWithIcons(text) {
    var firstIconIndex = text.indexOf(iconStartMarker);
    if (firstIconIndex === -1) {
        return { text: text }; // return early if the word does not include an icon
    }
    return doParseLabelWithIcons(text, firstIconIndex);
}
function doParseLabelWithIcons(text, firstIconIndex) {
    var iconOffsets = [];
    var textWithoutIcons = '';
    function appendChars(chars) {
        var e_1, _a;
        if (chars) {
            textWithoutIcons += chars;
            try {
                for (var chars_1 = __values(chars), chars_1_1 = chars_1.next(); !chars_1_1.done; chars_1_1 = chars_1.next()) {
                    var _ = chars_1_1.value;
                    iconOffsets.push(iconsOffset); // make sure to fill in icon offsets
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (chars_1_1 && !chars_1_1.done && (_a = chars_1.return)) _a.call(chars_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    }
    var currentIconStart = -1;
    var currentIconValue = '';
    var iconsOffset = 0;
    var char;
    var nextChar;
    var offset = firstIconIndex;
    var length = text.length;
    // Append all characters until the first icon
    appendChars(text.substr(0, firstIconIndex));
    // example: $(file-symlink-file) my cool $(other-icon) entry
    while (offset < length) {
        char = text[offset];
        nextChar = text[offset + 1];
        // beginning of icon: some value $( <--
        if (char === iconStartMarker[0] && nextChar === iconStartMarker[1]) {
            currentIconStart = offset;
            // if we had a previous potential icon value without
            // the closing ')', it was actually not an icon and
            // so we have to add it to the actual value
            appendChars(currentIconValue);
            currentIconValue = iconStartMarker;
            offset++; // jump over '('
        }
        // end of icon: some value $(some-icon) <--
        else if (char === ')' && currentIconStart !== -1) {
            var currentIconLength = offset - currentIconStart + 1; // +1 to include the closing ')'
            iconsOffset += currentIconLength;
            currentIconStart = -1;
            currentIconValue = '';
        }
        // within icon
        else if (currentIconStart !== -1) {
            // Make sure this is a real icon name
            if (/^[a-z0-9\-]$/i.test(char)) {
                currentIconValue += char;
            }
            else {
                // This is not a real icon, treat it as text
                appendChars(currentIconValue);
                currentIconStart = -1;
                currentIconValue = '';
            }
        }
        // any value outside of icon
        else {
            appendChars(char);
        }
        offset++;
    }
    // if we had a previous potential icon value without
    // the closing ')', it was actually not an icon and
    // so we have to add it to the actual value
    appendChars(currentIconValue);
    return { text: textWithoutIcons, iconOffsets: iconOffsets };
}
export function matchesFuzzyIconAware(query, target, enableSeparateSubstringMatching) {
    var e_2, _a;
    if (enableSeparateSubstringMatching === void 0) { enableSeparateSubstringMatching = false; }
    var text = target.text, iconOffsets = target.iconOffsets;
    // Return early if there are no icon markers in the word to match against
    if (!iconOffsets || iconOffsets.length === 0) {
        return matchesFuzzy(query, text, enableSeparateSubstringMatching);
    }
    // Trim the word to match against because it could have leading
    // whitespace now if the word started with an icon
    var wordToMatchAgainstWithoutIconsTrimmed = ltrim(text, ' ');
    var leadingWhitespaceOffset = text.length - wordToMatchAgainstWithoutIconsTrimmed.length;
    // match on value without icon
    var matches = matchesFuzzy(query, wordToMatchAgainstWithoutIconsTrimmed, enableSeparateSubstringMatching);
    // Map matches back to offsets with icon and trimming
    if (matches) {
        try {
            for (var matches_1 = __values(matches), matches_1_1 = matches_1.next(); !matches_1_1.done; matches_1_1 = matches_1.next()) {
                var match = matches_1_1.value;
                var iconOffset = iconOffsets[match.start + leadingWhitespaceOffset] /* icon offsets at index */ + leadingWhitespaceOffset /* overall leading whitespace offset */;
                match.start += iconOffset;
                match.end += iconOffset;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (matches_1_1 && !matches_1_1.done && (_a = matches_1.return)) _a.call(matches_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    return matches;
}
