"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var ElectronIpcConnectionProvider_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElectronIpcConnectionProvider = void 0;
const electron_1 = require("@theia/electron/shared/electron");
const inversify_1 = require("inversify");
const web_socket_channel_1 = require("../../common/messaging/web-socket-channel");
const abstract_connection_provider_1 = require("../../common/messaging/abstract-connection-provider");
const electron_connection_handler_1 = require("../../electron-common/messaging/electron-connection-handler");
/**
 * Connection provider between the Theia frontend and the electron-main process via IPC.
 */
let ElectronIpcConnectionProvider = ElectronIpcConnectionProvider_1 = class ElectronIpcConnectionProvider extends abstract_connection_provider_1.AbstractConnectionProvider {
    static createProxy(container, path, arg) {
        return container.get(ElectronIpcConnectionProvider_1).createProxy(path, arg);
    }
    constructor() {
        super();
        electron_1.ipcRenderer.on(electron_connection_handler_1.THEIA_ELECTRON_IPC_CHANNEL_NAME, (event, data) => {
            this.handleIncomingRawMessage(data);
        });
    }
    createChannel(id) {
        return new web_socket_channel_1.WebSocketChannel(id, content => {
            electron_1.ipcRenderer.send(electron_connection_handler_1.THEIA_ELECTRON_IPC_CHANNEL_NAME, content);
        });
    }
};
ElectronIpcConnectionProvider = ElectronIpcConnectionProvider_1 = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], ElectronIpcConnectionProvider);
exports.ElectronIpcConnectionProvider = ElectronIpcConnectionProvider;
//# sourceMappingURL=electron-ipc-connection-provider.js.map