"use strict";
/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var VSXExtensionsWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VSXExtensionsWidget = exports.generateExtensionWidgetId = exports.VSXExtensionsWidgetOptions = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const source_tree_1 = require("@theia/core/lib/browser/source-tree");
const vsx_extensions_source_1 = require("./vsx-extensions-source");
const nls_1 = require("@theia/core/lib/common/nls");
let VSXExtensionsWidgetOptions = class VSXExtensionsWidgetOptions extends vsx_extensions_source_1.VSXExtensionsSourceOptions {
};
VSXExtensionsWidgetOptions = __decorate([
    inversify_1.injectable()
], VSXExtensionsWidgetOptions);
exports.VSXExtensionsWidgetOptions = VSXExtensionsWidgetOptions;
exports.generateExtensionWidgetId = (widgetId) => VSXExtensionsWidget.ID + ':' + widgetId;
let VSXExtensionsWidget = VSXExtensionsWidget_1 = class VSXExtensionsWidget extends source_tree_1.SourceTreeWidget {
    static createWidget(parent, options) {
        const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
            virtualized: false,
            scrollIfActive: true
        });
        child.bind(vsx_extensions_source_1.VSXExtensionsSourceOptions).toConstantValue(options);
        child.bind(vsx_extensions_source_1.VSXExtensionsSource).toSelf();
        child.unbind(source_tree_1.SourceTreeWidget);
        child.bind(VSXExtensionsWidgetOptions).toConstantValue(options);
        child.bind(VSXExtensionsWidget_1).toSelf();
        return child.get(VSXExtensionsWidget_1);
    }
    init() {
        var _a;
        super.init();
        this.addClass('theia-vsx-extensions');
        this.id = exports.generateExtensionWidgetId(this.options.id);
        const title = (_a = this.options.title) !== null && _a !== void 0 ? _a : this.computeTitle();
        this.title.label = title;
        this.title.caption = title;
        this.toDispose.push(this.extensionsSource);
        this.source = this.extensionsSource;
    }
    computeTitle() {
        switch (this.options.id) {
            case vsx_extensions_source_1.VSXExtensionsSourceOptions.INSTALLED:
                return nls_1.nls.localizeByDefault('Installed');
            case vsx_extensions_source_1.VSXExtensionsSourceOptions.BUILT_IN:
                return nls_1.nls.localizeByDefault('Built-in');
            case vsx_extensions_source_1.VSXExtensionsSourceOptions.RECOMMENDED:
                return nls_1.nls.localizeByDefault('Recommended');
            case vsx_extensions_source_1.VSXExtensionsSourceOptions.SEARCH_RESULT:
                return nls_1.nls.localize('theia/vsx-registry/openVSX', 'Open VSX Registry');
            default:
                return '';
        }
    }
    handleClickEvent(node, event) {
        super.handleClickEvent(node, event);
        this.model.openNode(node); // Open the editor view on a single click.
    }
    handleDblClickEvent() {
        // Don't open the editor view on a double click.
    }
};
VSXExtensionsWidget.ID = 'vsx-extensions';
__decorate([
    inversify_1.inject(VSXExtensionsWidgetOptions),
    __metadata("design:type", VSXExtensionsWidgetOptions)
], VSXExtensionsWidget.prototype, "options", void 0);
__decorate([
    inversify_1.inject(vsx_extensions_source_1.VSXExtensionsSource),
    __metadata("design:type", vsx_extensions_source_1.VSXExtensionsSource)
], VSXExtensionsWidget.prototype, "extensionsSource", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], VSXExtensionsWidget.prototype, "init", null);
VSXExtensionsWidget = VSXExtensionsWidget_1 = __decorate([
    inversify_1.injectable()
], VSXExtensionsWidget);
exports.VSXExtensionsWidget = VSXExtensionsWidget;
//# sourceMappingURL=vsx-extensions-widget.js.map