"use strict";
/********************************************************************************
 * Copyright (C) 2019 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProblemMatchData = exports.ProblemPattern = exports.ProblemMatcher = exports.ProblemLocationKind = exports.WatchingMatcher = exports.FileLocationKind = exports.ApplyToKind = void 0;
var ApplyToKind;
(function (ApplyToKind) {
    ApplyToKind[ApplyToKind["allDocuments"] = 0] = "allDocuments";
    ApplyToKind[ApplyToKind["openDocuments"] = 1] = "openDocuments";
    ApplyToKind[ApplyToKind["closedDocuments"] = 2] = "closedDocuments";
})(ApplyToKind = exports.ApplyToKind || (exports.ApplyToKind = {}));
(function (ApplyToKind) {
    function fromString(value) {
        if (value) {
            value = value.toLowerCase();
            if (value === 'alldocuments') {
                return ApplyToKind.allDocuments;
            }
            else if (value === 'opendocuments') {
                return ApplyToKind.openDocuments;
            }
            else if (value === 'closeddocuments') {
                return ApplyToKind.closedDocuments;
            }
        }
        return undefined;
    }
    ApplyToKind.fromString = fromString;
})(ApplyToKind = exports.ApplyToKind || (exports.ApplyToKind = {}));
var FileLocationKind;
(function (FileLocationKind) {
    FileLocationKind[FileLocationKind["Auto"] = 0] = "Auto";
    FileLocationKind[FileLocationKind["Relative"] = 1] = "Relative";
    FileLocationKind[FileLocationKind["Absolute"] = 2] = "Absolute";
})(FileLocationKind = exports.FileLocationKind || (exports.FileLocationKind = {}));
(function (FileLocationKind) {
    function fromString(value) {
        value = value.toLowerCase();
        if (value === 'absolute') {
            return FileLocationKind.Absolute;
        }
        else if (value === 'relative') {
            return FileLocationKind.Relative;
        }
        else {
            return undefined;
        }
    }
    FileLocationKind.fromString = fromString;
})(FileLocationKind = exports.FileLocationKind || (exports.FileLocationKind = {}));
var WatchingMatcher;
(function (WatchingMatcher) {
    function fromWatchingMatcherContribution(value) {
        if (!value) {
            return undefined;
        }
        return {
            activeOnStart: !!value.activeOnStart,
            beginsPattern: typeof value.beginsPattern === 'string' ? { regexp: value.beginsPattern } : value.beginsPattern,
            endsPattern: typeof value.endsPattern === 'string' ? { regexp: value.endsPattern } : value.endsPattern
        };
    }
    WatchingMatcher.fromWatchingMatcherContribution = fromWatchingMatcherContribution;
})(WatchingMatcher = exports.WatchingMatcher || (exports.WatchingMatcher = {}));
var ProblemLocationKind;
(function (ProblemLocationKind) {
    ProblemLocationKind[ProblemLocationKind["File"] = 0] = "File";
    ProblemLocationKind[ProblemLocationKind["Location"] = 1] = "Location";
})(ProblemLocationKind = exports.ProblemLocationKind || (exports.ProblemLocationKind = {}));
(function (ProblemLocationKind) {
    function fromString(value) {
        value = value.toLowerCase();
        if (value === 'file') {
            return ProblemLocationKind.File;
        }
        else if (value === 'location') {
            return ProblemLocationKind.Location;
        }
        else {
            return undefined;
        }
    }
    ProblemLocationKind.fromString = fromString;
})(ProblemLocationKind = exports.ProblemLocationKind || (exports.ProblemLocationKind = {}));
var ProblemMatcher;
(function (ProblemMatcher) {
    function isWatchModeWatcher(matcher) {
        return !!matcher.watching;
    }
    ProblemMatcher.isWatchModeWatcher = isWatchModeWatcher;
})(ProblemMatcher = exports.ProblemMatcher || (exports.ProblemMatcher = {}));
var ProblemPattern;
(function (ProblemPattern) {
    function fromProblemPatternContribution(value) {
        return {
            name: value.name,
            regexp: value.regexp,
            kind: value.kind ? ProblemLocationKind.fromString(value.kind) : undefined,
            file: value.file,
            message: value.message,
            location: value.location,
            line: value.line,
            character: value.column || value.character,
            endLine: value.endLine,
            endCharacter: value.endColumn || value.endCharacter,
            code: value.code,
            severity: value.severity,
            loop: value.loop
        };
    }
    ProblemPattern.fromProblemPatternContribution = fromProblemPatternContribution;
})(ProblemPattern = exports.ProblemPattern || (exports.ProblemPattern = {}));
var ProblemMatchData;
(function (ProblemMatchData) {
    function is(data) {
        return 'marker' in data;
    }
    ProblemMatchData.is = is;
})(ProblemMatchData = exports.ProblemMatchData || (exports.ProblemMatchData = {}));
//# sourceMappingURL=problem-matcher-protocol.js.map