/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { createDecorator } from '../../instantiation/common/instantiation';
export var IUndoRedoService = createDecorator('undoRedoService');
var ResourceEditStackSnapshot = /** @class */ (function () {
    function ResourceEditStackSnapshot(resource, elements) {
        this.resource = resource;
        this.elements = elements;
    }
    return ResourceEditStackSnapshot;
}());
export { ResourceEditStackSnapshot };
var UndoRedoGroup = /** @class */ (function () {
    function UndoRedoGroup() {
        this.id = UndoRedoGroup._ID++;
        this.order = 1;
    }
    UndoRedoGroup.prototype.nextOrder = function () {
        if (this.id === 0) {
            return 0;
        }
        return this.order++;
    };
    UndoRedoGroup._ID = 0;
    UndoRedoGroup.None = new UndoRedoGroup();
    return UndoRedoGroup;
}());
export { UndoRedoGroup };
var UndoRedoSource = /** @class */ (function () {
    function UndoRedoSource() {
        this.id = UndoRedoSource._ID++;
        this.order = 1;
    }
    UndoRedoSource.prototype.nextOrder = function () {
        if (this.id === 0) {
            return 0;
        }
        return this.order++;
    };
    UndoRedoSource._ID = 0;
    UndoRedoSource.None = new UndoRedoSource();
    return UndoRedoSource;
}());
export { UndoRedoSource };
